/*
 * Decompiled with CFR 0.152.
 */
package elki.persistent;

import elki.index.tree.TreeIndexHeader;
import elki.logging.Logging;
import elki.persistent.AbstractStoringPageFile;
import elki.persistent.ExternalizablePage;
import elki.persistent.PageHeader;
import elki.utilities.exceptions.AbortException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class PersistentPageFile<P extends ExternalizablePage>
extends AbstractStoringPageFile<P> {
    private static final Logging LOG = Logging.getLogger(PersistentPageFile.class);
    private static final int EMPTY_PAGE = 0;
    private static final int FILLED_PAGE = 1;
    private final FileChannel file;
    protected PageHeader header;
    protected final Class<P> pageclass;
    private boolean existed;

    public PersistentPageFile(int pageSize, Path filename, Class<P> pageclass) {
        super(pageSize);
        this.pageclass = pageclass;
        this.existed = Files.exists(filename, new LinkOption[0]);
        try {
            this.file = FileChannel.open(filename, StandardOpenOption.READ, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new AbortException("IO error in loading persistent page file.", (Throwable)e);
        }
    }

    public P readPage(int pageID) {
        try {
            this.countRead();
            long offset = (long)(this.header.getReservedPages() + pageID) * (long)this.pageSize;
            byte[] buffer = new byte[this.pageSize];
            int read = this.file.read(ByteBuffer.wrap(buffer), offset);
            if (read != this.pageSize) {
                throw new IOException("Incomplete read at offset " + offset + " read " + read + " bytes, expected " + this.pageSize);
            }
            return this.byteArrayToPage(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred during reading of page " + pageID + "\n", e);
        }
    }

    public void deletePage(int pageID) {
        try {
            super.deletePage(pageID);
            this.countWrite();
            byte[] array = this.pageToByteArray(null);
            long offset = (long)(this.header.getReservedPages() + pageID) * (long)this.pageSize;
            int written = this.file.write(ByteBuffer.wrap(array), offset);
            if (written != this.pageSize) {
                throw new IOException("Incomplete write at offset " + offset + " wrote " + written + " bytes, expected " + array.length);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writePage(int pageID, P page) {
        try {
            this.countWrite();
            byte[] array = this.pageToByteArray(page);
            long offset = (long)(this.header.getReservedPages() + pageID) * (long)this.pageSize;
            assert (offset >= 0L) : this.header.getReservedPages() + " " + pageID + " " + this.pageSize + " " + offset;
            int written = this.file.write(ByteBuffer.wrap(array), offset);
            if (written != this.pageSize) {
                throw new IOException("Incomplete write at offset " + offset + " wrote " + written + " bytes, expected " + array.length);
            }
            page.setDirty(false);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing to page file.", e);
        }
    }

    public void close() {
        try {
            super.close();
            if (!this.emptyPages.isEmpty() && this.header instanceof TreeIndexHeader) {
                ((TreeIndexHeader)this.header).writeEmptyPages(this.emptyPages, this.file);
            }
            ((TreeIndexHeader)this.header).setLargestPageID(this.nextPageID);
            this.header.writeHeader(this.file);
            this.file.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        try {
            this.file.truncate(this.header.size());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private P byteArrayToPage(byte[] array) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(array);
            ObjectInputStream ois = new ObjectInputStream(bais);
            int type = ois.readInt();
            if (type == 0) {
                return null;
            }
            if (type != 1) {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
            try {
                ExternalizablePage page = (ExternalizablePage)this.pageclass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                page.readExternal((ObjectInput)ois);
                return (P)page;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new AbortException("Error instanciating an index page", (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new AbortException("IO Error in page file", (Throwable)e);
        }
    }

    private byte[] pageToByteArray(P page) {
        try {
            if (page == null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeInt(0);
                oos.close();
                baos.close();
                byte[] array = baos.toByteArray();
                byte[] result = new byte[this.pageSize];
                System.arraycopy(array, 0, result, 0, array.length);
                return result;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeInt(1);
            page.writeExternal((ObjectOutput)oos);
            oos.close();
            baos.close();
            byte[] array = baos.toByteArray();
            if (array.length > this.pageSize) {
                throw new IllegalArgumentException("Size of page " + page + " is greater than specified pagesize: " + array.length + " > " + this.pageSize);
            }
            if (array.length == this.pageSize) {
                return array;
            }
            byte[] result = new byte[this.pageSize];
            System.arraycopy(array, 0, result, 0, array.length);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred! ", e);
        }
    }

    public FileChannel getFile() {
        return this.file;
    }

    public PageHeader getHeader() {
        return this.header;
    }

    public void setNextPageID(int next_page_id) {
        this.nextPageID = next_page_id;
        while (!this.emptyPages.isEmpty() && this.emptyPages.get(this.emptyPages.size - 1) >= this.nextPageID) {
            --this.emptyPages.size;
        }
    }

    public boolean initialize(PageHeader header) {
        block12: {
            try {
                if (this.existed) {
                    LOG.debug((CharSequence)"Initializing from an existing page file.");
                    this.header = header;
                    header.readHeader(this.file);
                    if (header instanceof TreeIndexHeader) {
                        TreeIndexHeader tiHeader = (TreeIndexHeader)header;
                        this.nextPageID = tiHeader.getLargestPageID();
                        try {
                            this.emptyPages = tiHeader.readEmptyPages(this.file);
                            break block12;
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException("ClassNotFoundException occurred when reading empty pages.", e);
                        }
                    }
                    int i = 0;
                    while (this.file.position() + (long)this.pageSize <= this.file.size()) {
                        long offset = (long)(header.getReservedPages() + i) * (long)this.pageSize;
                        byte[] buffer = new byte[this.pageSize];
                        if (this.file.read(ByteBuffer.wrap(buffer), offset) != this.pageSize) {
                            throw new IOException("Incomplete read at position " + offset);
                        }
                        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
                        ObjectInputStream ois = new ObjectInputStream(bais);
                        int type = ois.readInt();
                        if (type == 0) {
                            this.emptyPages.add(i);
                        } else if (type == 1) {
                            this.nextPageID = i + 1;
                        } else {
                            throw new IllegalArgumentException("Unknown type: " + type);
                        }
                        ++i;
                    }
                    break block12;
                }
                LOG.debug((CharSequence)"Initializing with a new page file.");
                this.header = header;
                header.writeHeader(this.file);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException occurred.", e);
            }
        }
        return this.existed;
    }

    protected Logging getLogger() {
        return LOG;
    }
}

