/*
 * Decompiled with CFR 0.152.
 */
package elki.projection;

import elki.Algorithm;
import elki.database.relation.Relation;
import elki.index.Index;
import elki.logging.Logging;
import elki.result.Metadata;
import elki.result.ResultUtil;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.optionhandling.OptionID;

public abstract class AbstractProjectionAlgorithm<R>
implements Algorithm {
    private boolean keep;
    public static final OptionID KEEP_ID = new OptionID("tsne.retain-original", "Retain the original data.");

    public AbstractProjectionAlgorithm(boolean keep) {
        this.keep = keep;
    }

    protected void removePreviousRelation(Relation<?> relation) {
        if (this.keep) {
            return;
        }
        boolean first = true;
        It it = Metadata.hierarchyOf(relation).iterDescendants().filter(Index.class);
        while (it.valid()) {
            if (first) {
                Logging.getLogger(this.getClass()).statistics((CharSequence)"Index statistics when removing initial data relation.");
                first = false;
            }
            ((Index)it.get()).logStatistics();
            it.advance();
        }
        ResultUtil.removeRecursive(relation);
    }
}

