/*
 * Decompiled with CFR 0.152.
 */
package elki.projection;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.Statistic;
import elki.math.MathUtil;
import elki.math.MeanVariance;
import elki.projection.AffinityMatrix;
import elki.projection.AffinityMatrixBuilder;
import elki.projection.DenseAffinityMatrix;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import net.jafama.FastMath;

@Reference(authors="G. Hinton, S. Roweis", title="Stochastic Neighbor Embedding", booktitle="Advances in Neural Information Processing Systems 15", url="http://papers.nips.cc/paper/2276-stochastic-neighbor-embedding", bibkey="DBLP:conf/nips/HintonR02")
public class GaussianAffinityMatrixBuilder<O>
implements AffinityMatrixBuilder<O> {
    private static final Logging LOG = Logging.getLogger(GaussianAffinityMatrixBuilder.class);
    protected static final double MIN_PIJ = 1.0E-12;
    protected Distance<? super O> distance;
    protected double sigma;

    public GaussianAffinityMatrixBuilder(Distance<? super O> distance, double sigma) {
        this.distance = distance;
        this.sigma = sigma;
    }

    @Override
    public <T extends O> AffinityMatrix computeAffinityMatrix(Relation<T> relation, double initialScale) {
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        double[][] dist = this.buildDistanceMatrix(ids, new QueryBuilder(relation, this.distance).distanceQuery());
        return new DenseAffinityMatrix(GaussianAffinityMatrixBuilder.computePij(dist, this.sigma, initialScale), ids);
    }

    protected double[][] buildDistanceMatrix(ArrayDBIDs ids, DistanceQuery<?> dq) {
        int size = ids.size();
        double[][] dmat = new double[size][size];
        boolean square = !dq.getDistance().isSquared();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Computing distance matrix", size * (size - 1) >>> 1, LOG) : null;
        Duration timer = LOG.newDuration(this.getClass().getName() + ".runtime.distancematrix").begin();
        DBIDArrayIter ix = ids.iter();
        DBIDArrayIter iy = ids.iter();
        ix.seek(0);
        while (ix.valid()) {
            double[] dmat_x = dmat[ix.getOffset()];
            iy.seek(ix.getOffset() + 1);
            while (iy.valid()) {
                double dist = dq.distance((DBIDRef)ix, (DBIDRef)iy);
                double d = square ? dist * dist : dist;
                dmat_x[iy.getOffset()] = d;
                dmat[iy.getOffset()][ix.getOffset()] = d;
                iy.advance();
            }
            if (prog != null) {
                int row = ix.getOffset() + 1;
                prog.setProcessed(row * size - (row * (row + 1) >>> 1), LOG);
            }
            ix.advance();
        }
        LOG.ensureCompleted(prog);
        LOG.statistics((Statistic)timer.end());
        return dmat;
    }

    protected static double[][] computePij(double[][] dist, double sigma, double initialScale) {
        int size = dist.length;
        double msigmasq = -0.5 / (sigma * sigma);
        double[][] pij = new double[size][size];
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Computing affinities", size, LOG) : null;
        Duration timer = LOG.newDuration(GaussianAffinityMatrixBuilder.class.getName() + ".runtime.pijmatrix").begin();
        MeanVariance mv = LOG.isStatistics() ? new MeanVariance() : null;
        for (int i = 0; i < size; ++i) {
            double logP = GaussianAffinityMatrixBuilder.computeH(i, dist[i], pij[i], msigmasq);
            if (mv != null) {
                mv.put(FastMath.exp((double)logP));
            }
            LOG.incrementProcessed((AbstractProgress)prog);
        }
        LOG.ensureCompleted(prog);
        LOG.statistics((Statistic)timer.end());
        if (mv != null && LOG.isStatistics()) {
            LOG.statistics((Statistic)new DoubleStatistic(GaussianAffinityMatrixBuilder.class.getName() + ".perplexity.average", mv.getMean()));
            LOG.statistics((Statistic)new DoubleStatistic(GaussianAffinityMatrixBuilder.class.getName() + ".perplexity.stddev", mv.getSampleStddev()));
        }
        double sum = 0.0;
        for (int i = 1; i < size; ++i) {
            double[] pij_i = pij[i];
            for (int j = 0; j < i; ++j) {
                int n = j;
                double d = pij_i[n] + pij[j][i];
                pij_i[n] = d;
                sum += d;
            }
        }
        double scale = initialScale / (2.0 * sum);
        for (int i = 1; i < size; ++i) {
            double[] pij_i = pij[i];
            for (int j = 0; j < i; ++j) {
                double d = MathUtil.max((double)(pij_i[j] * scale), (double)1.0E-12);
                pij[j][i] = d;
                pij_i[j] = d;
            }
        }
        return pij;
    }

    protected static double computeH(int i, double[] dist_i, double[] pij_i, double mbeta) {
        int j;
        double sumP = 0.0;
        for (j = 0; j < i; ++j) {
            pij_i[j] = FastMath.exp((double)(dist_i[j] * mbeta));
            sumP += pij_i[j];
        }
        for (j = i + 1; j < dist_i.length; ++j) {
            pij_i[j] = FastMath.exp((double)(dist_i[j] * mbeta));
            sumP += pij_i[j];
        }
        if (!(sumP > 0.0)) {
            return Double.NEGATIVE_INFINITY;
        }
        double s = 1.0 / sumP;
        double sum = 0.0;
        for (int j2 = 0; j2 < dist_i.length; ++j2) {
            int n = j2;
            double d = pij_i[n] * s;
            pij_i[n] = d;
            sum += dist_i[j2] * d;
        }
        return FastMath.log((double)sumP) - mbeta * sum;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.distance.getInputTypeRestriction();
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID SIGMA_ID = new OptionID("sne.sigma", "Gaussian kernel standard deviation.");
        protected double sigma;
        protected Distance<? super O> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, SquaredEuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((DoubleParameter)new DoubleParameter(SIGMA_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.sigma = x;
            });
        }

        public GaussianAffinityMatrixBuilder<O> make() {
            return new GaussianAffinityMatrixBuilder<O>(this.distance, this.sigma);
        }
    }
}

