/*
 * Decompiled with CFR 0.152.
 */
package elki.projection;

import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRange;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNList;
import elki.database.query.LinearScanQuery;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.Statistic;
import elki.math.MathUtil;
import elki.math.Mean;
import elki.math.MeanVariance;
import elki.math.statistics.intrinsicdimensionality.AggregatedHillEstimator;
import elki.math.statistics.intrinsicdimensionality.DistanceBasedIntrinsicDimensionalityEstimator;
import elki.projection.AffinityMatrix;
import elki.projection.NearestNeighborAffinityMatrixBuilder;
import elki.projection.SparseAffinityMatrix;
import elki.utilities.datastructures.arraylike.DoubleArray;
import elki.utilities.datastructures.arraylike.IntegerArray;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import net.jafama.FastMath;

@Title(value="Intrinsic t-Stochastic Neighbor Embedding")
@Reference(authors="Erich Schubert, Michael Gertz", title="Intrinsic t-Stochastic Neighbor Embedding for Visualization and Outlier Detection: A Remedy Against the Curse of Dimensionality?", booktitle="Proc. Int. Conf. Similarity Search and Applications, SISAP 2017", url="https://doi.org/10.1007/978-3-319-68474-1_13", bibkey="DBLP:conf/sisap/SchubertG17")
public class IntrinsicNearestNeighborAffinityMatrixBuilder<O>
extends NearestNeighborAffinityMatrixBuilder<O> {
    private static final Logging LOG = Logging.getLogger(IntrinsicNearestNeighborAffinityMatrixBuilder.class);
    DistanceBasedIntrinsicDimensionalityEstimator estimator;

    public IntrinsicNearestNeighborAffinityMatrixBuilder(Distance<? super O> distance, double perplexity, DistanceBasedIntrinsicDimensionalityEstimator estimator) {
        super(distance, perplexity);
        this.estimator = estimator;
    }

    @Override
    public <T extends O> AffinityMatrix computeAffinityMatrix(Relation<T> relation, double initialScale) {
        int numberOfNeighbours = (int)FastMath.ceil((double)(3.0 * this.perplexity));
        KNNSearcher knnq = new QueryBuilder(relation, this.distance).kNNByDBID(numberOfNeighbours + 1);
        if (knnq instanceof LinearScanQuery && numberOfNeighbours * numberOfNeighbours < relation.size()) {
            LOG.warning((CharSequence)"To accelerate Barnes-Hut tSNE, please use an index.");
        }
        if (!(relation.getDBIDs() instanceof DBIDRange)) {
            throw new AbortException("Distance matrixes are currently only supported for DBID ranges (as used by static databases) for performance reasons (Patches welcome).");
        }
        DBIDRange rids = (DBIDRange)relation.getDBIDs();
        int size = rids.size();
        double[][] pij = new double[size][];
        int[][] indices = new int[size][];
        boolean square = !SquaredEuclideanDistance.class.isInstance(this.distance);
        this.computePij(rids, (KNNSearcher<DBIDRef>)knnq, square, numberOfNeighbours, pij, indices, initialScale);
        SparseAffinityMatrix mat = new SparseAffinityMatrix(pij, indices, (ArrayDBIDs)rids);
        return mat;
    }

    @Override
    protected void computePij(DBIDRange ids, KNNSearcher<DBIDRef> knnq, boolean square, int numberOfNeighbours, double[][] pij, int[][] indices, double initialScale) {
        Duration timer = LOG.newDuration(this.getClass().getName() + ".runtime.neighborspijmatrix").begin();
        double logPerp = FastMath.log((double)this.perplexity);
        DoubleArray dists = new DoubleArray(numberOfNeighbours + 10);
        IntegerArray inds = new IntegerArray(numberOfNeighbours + 10);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Finding neighbors and optimizing perplexity", ids.size(), LOG) : null;
        MeanVariance mv = LOG.isStatistics() ? new MeanVariance() : null;
        Mean mid = LOG.isStatistics() ? new Mean() : null;
        DBIDArrayIter ix = ids.iter();
        while (ix.valid()) {
            dists.clear();
            inds.clear();
            KNNList neighbours = knnq.getKNN((Object)ix, numberOfNeighbours + 1);
            this.convertNeighbors(ids, (DBIDRef)ix, square, neighbours, dists, inds, mid);
            double[] dArray = new double[dists.size()];
            pij[ix.getOffset()] = dArray;
            double beta = IntrinsicNearestNeighborAffinityMatrixBuilder.computeSigma(ix.getOffset(), dists, this.perplexity, logPerp, dArray);
            if (mv != null) {
                mv.put(beta > 0.0 ? Math.sqrt(0.5 / beta) : 0.0);
            }
            indices[ix.getOffset()] = inds.toArray();
            LOG.incrementProcessed((AbstractProgress)prog);
            ix.advance();
        }
        LOG.ensureCompleted(prog);
        if (mid != null) {
            LOG.statistics((Statistic)new DoubleStatistic(this.getClass() + ".average-original-id", mid.getMean()));
        }
        double sum = 0.0;
        for (int i = 0; i < pij.length; ++i) {
            double[] pij_i = pij[i];
            for (int offi = 0; offi < pij_i.length; ++offi) {
                int j = indices[i][offi];
                if (j > i) continue;
                assert (i != j);
                int offj = IntrinsicNearestNeighborAffinityMatrixBuilder.containsIndex(indices[j], i);
                if (offj < 0) continue;
                sum += Math.sqrt(pij_i[offi] * pij[j][offj]);
            }
        }
        double scale = initialScale / (2.0 * sum);
        for (int i = 0; i < pij.length; ++i) {
            double[] pij_i = pij[i];
            for (int offi = 0; offi < pij_i.length; ++offi) {
                int j = indices[i][offi];
                assert (i != j);
                int offj = IntrinsicNearestNeighborAffinityMatrixBuilder.containsIndex(indices[j], i);
                if (offj >= 0) {
                    assert (indices[j][offj] == i);
                    if (i >= j) continue;
                    double val = Math.sqrt(pij_i[offi] * pij[j][offj]);
                    double d = MathUtil.max((double)(val * scale), (double)1.0E-12);
                    pij[j][offj] = d;
                    pij_i[offi] = d;
                    continue;
                }
                pij_i[offi] = 0.0;
            }
        }
        LOG.statistics((Statistic)timer.end());
        if (mv != null && LOG.isStatistics()) {
            LOG.statistics((Statistic)new DoubleStatistic(NearestNeighborAffinityMatrixBuilder.class.getName() + ".sigma.average", mv.getMean()));
            LOG.statistics((Statistic)new DoubleStatistic(NearestNeighborAffinityMatrixBuilder.class.getName() + ".sigma.stddev", mv.getSampleStddev()));
        }
    }

    protected void convertNeighbors(DBIDRange ids, DBIDRef ix, boolean square, KNNList neighbours, DoubleArray dist, IntegerArray ind, Mean m) {
        double max;
        DoubleDBIDListIter iter = neighbours.iter();
        while (iter.valid()) {
            if (!DBIDUtil.equal((DBIDRef)iter, (DBIDRef)ix)) {
                dist.add(iter.doubleValue());
                ind.add(ids.getOffset((DBIDRef)iter));
            }
            iter.advance();
        }
        double id = this.estimator.estimate(dist.data, dist.size);
        if (m != null) {
            m.put(id);
        }
        if ((max = dist.data[dist.size - 1]) > 0.0) {
            double scaleexp = id * 0.5;
            double scalelin = 1.0 / max;
            for (int i = 0; i < dist.size; ++i) {
                dist.data[i] = FastMath.pow((double)(dist.data[i] * scalelin), (double)scaleexp);
            }
        }
    }

    public static class Par<O>
    extends NearestNeighborAffinityMatrixBuilder.Par<O> {
        public static final OptionID ESTIMATOR_ID = new OptionID("itsne.estimator", "Estimator for intrinsic dimensionality.");
        DistanceBasedIntrinsicDimensionalityEstimator estimator = AggregatedHillEstimator.STATIC;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            new ObjectParameter(ESTIMATOR_ID, DistanceBasedIntrinsicDimensionalityEstimator.class, AggregatedHillEstimator.class).grab(config, x -> {
                this.estimator = x;
            });
        }

        @Override
        public IntrinsicNearestNeighborAffinityMatrixBuilder<O> make() {
            return new IntrinsicNearestNeighborAffinityMatrixBuilder(this.distance, this.perplexity, this.estimator);
        }
    }
}

