/*
 * Decompiled with CFR 0.152.
 */
package elki.projection;

import elki.Algorithm;
import elki.data.type.TypeInformation;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.Statistic;
import elki.math.MathUtil;
import elki.math.MeanVariance;
import elki.projection.AffinityMatrix;
import elki.projection.DenseAffinityMatrix;
import elki.projection.GaussianAffinityMatrixBuilder;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import net.jafama.FastMath;

@Reference(authors="G. Hinton, S. Roweis", title="Stochastic Neighbor Embedding", booktitle="Advances in Neural Information Processing Systems 15", url="http://papers.nips.cc/paper/2276-stochastic-neighbor-embedding", bibkey="DBLP:conf/nips/HintonR02")
public class PerplexityAffinityMatrixBuilder<O>
extends GaussianAffinityMatrixBuilder<O> {
    private static final Logging LOG = Logging.getLogger(PerplexityAffinityMatrixBuilder.class);
    protected static final double PERPLEXITY_ERROR = 1.0E-5;
    protected static final int PERPLEXITY_MAXITER = 50;
    protected static final double MIN_PIJ = 1.0E-12;
    protected Distance<? super O> distance;
    protected double perplexity;

    public PerplexityAffinityMatrixBuilder(Distance<? super O> distance, double perplexity) {
        super(distance, Double.NaN);
        this.distance = distance;
        this.perplexity = perplexity;
    }

    @Override
    public <T extends O> AffinityMatrix computeAffinityMatrix(Relation<T> relation, double initialScale) {
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        double[][] dist = this.buildDistanceMatrix(ids, new QueryBuilder(relation, this.distance).distanceQuery());
        return new DenseAffinityMatrix(PerplexityAffinityMatrixBuilder.computePij(dist, this.perplexity, initialScale), ids);
    }

    protected static double[][] computePij(double[][] dist, double perplexity, double initialScale) {
        int size = dist.length;
        double logPerp = FastMath.log((double)perplexity);
        double[][] pij = new double[size][size];
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Optimizing perplexities", size, LOG) : null;
        Duration timer = LOG.newDuration(PerplexityAffinityMatrixBuilder.class.getName() + ".runtime.pijmatrix").begin();
        MeanVariance mv = LOG.isStatistics() ? new MeanVariance() : null;
        for (int i = 0; i < size; ++i) {
            double beta = PerplexityAffinityMatrixBuilder.computePi(i, dist[i], pij[i], perplexity, logPerp);
            if (mv != null) {
                mv.put(beta > 0.0 ? Math.sqrt(0.5 / beta) : 0.0);
            }
            LOG.incrementProcessed((AbstractProgress)prog);
        }
        LOG.ensureCompleted(prog);
        LOG.statistics((Statistic)timer.end());
        if (mv != null && LOG.isStatistics()) {
            LOG.statistics((Statistic)new DoubleStatistic(PerplexityAffinityMatrixBuilder.class.getName() + ".sigma.average", mv.getMean()));
            LOG.statistics((Statistic)new DoubleStatistic(PerplexityAffinityMatrixBuilder.class.getName() + ".sigma.stddev", mv.getSampleStddev()));
        }
        double sum = 0.0;
        for (int i = 1; i < size; ++i) {
            double[] pij_i = pij[i];
            for (int j = 0; j < i; ++j) {
                int n = j;
                double d = pij_i[n] + pij[j][i];
                pij_i[n] = d;
                sum += d;
            }
        }
        double scale = initialScale / (2.0 * sum);
        for (int i = 1; i < size; ++i) {
            double[] pij_i = pij[i];
            for (int j = 0; j < i; ++j) {
                double d = MathUtil.max((double)(pij_i[j] * scale), (double)1.0E-12);
                pij[j][i] = d;
                pij_i[j] = d;
            }
        }
        return pij;
    }

    protected static double computePi(int i, double[] dist_i, double[] pij_i, double perplexity, double logPerp) {
        double beta = PerplexityAffinityMatrixBuilder.estimateInitialBeta(dist_i, perplexity);
        double diff = PerplexityAffinityMatrixBuilder.computeH(i, dist_i, pij_i, -beta) - logPerp;
        double betaMin = 0.0;
        double betaMax = Double.POSITIVE_INFINITY;
        for (int tries = 0; tries < 50 && Math.abs(diff) > 1.0E-5; ++tries) {
            if (diff > 0.0) {
                betaMin = beta;
                beta += betaMax == Double.POSITIVE_INFINITY ? beta : (betaMax - beta) * 0.5;
            } else {
                betaMax = beta;
                beta -= (beta - betaMin) * 0.5;
            }
            diff = PerplexityAffinityMatrixBuilder.computeH(i, dist_i, pij_i, -beta) - logPerp;
        }
        return beta;
    }

    protected static double estimateInitialBeta(double[] dist_i, double perplexity) {
        double sum = 0.0;
        for (double d : dist_i) {
            double d2 = d * d;
            sum += d2 < Double.POSITIVE_INFINITY ? d2 : 0.0;
        }
        return sum > 0.0 && sum < Double.POSITIVE_INFINITY ? 0.5 / sum * perplexity * ((double)dist_i.length - 1.0) : 1.0;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.distance.getInputTypeRestriction();
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID PERPLEXITY_ID = new OptionID("sne.perplexity", "Desired perplexity (approximately the number of neighbors to preserve)");
        protected double perplexity;
        protected Distance<? super O> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, SquaredEuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((DoubleParameter)((DoubleParameter)new DoubleParameter(PERPLEXITY_ID).setDefaultValue((Object)40.0)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.perplexity = x;
            });
        }

        public PerplexityAffinityMatrixBuilder<O> make() {
            return new PerplexityAffinityMatrixBuilder<O>(this.distance, this.perplexity);
        }
    }
}

