/*
 * Decompiled with CFR 0.152.
 */
package elki.projection;

import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.math.linearalgebra.VMath;
import elki.projection.AffinityMatrix;

public class SparseAffinityMatrix
implements AffinityMatrix {
    double[][] pij;
    int[][] indices;
    ArrayDBIDs ids;

    public SparseAffinityMatrix(double[][] pij, int[][] indices, ArrayDBIDs ids) {
        this.pij = pij;
        this.indices = indices;
        this.ids = ids;
    }

    @Override
    public double get(int i, int j) {
        int[] ind = this.indices[i];
        for (int y = 0; y < ind.length; ++y) {
            if (ind[y] != j) continue;
            return this.pij[i][y];
        }
        return 0.0;
    }

    @Override
    public void scale(double d) {
        VMath.timesEquals((double[][])this.pij, (double)d);
    }

    @Override
    public int size() {
        return this.ids.size();
    }

    @Override
    public DBIDArrayIter iterDBIDs() {
        return this.ids.iter();
    }

    @Override
    public int iter(int x) {
        return 0;
    }

    @Override
    public int iterAdvance(int x, int iter) {
        return iter + 1;
    }

    @Override
    public int iterDim(int x, int iter) {
        return this.indices[x][iter];
    }

    @Override
    public double iterValue(int x, int iter) {
        return this.pij[x][iter];
    }

    @Override
    public boolean iterValid(int x, int iter) {
        return iter < this.pij[x].length;
    }
}

