/*
 * Decompiled with CFR 0.152.
 */
package elki.result;

import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.Model;
import elki.data.spatial.Polygon;
import elki.data.spatial.PolygonsObject;
import elki.data.spatial.SpatialComparable;
import elki.data.spatial.SpatialUtil;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.DatabaseUtil;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.DoubleRelation;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.math.geometry.FilteredConvexHull2D;
import elki.result.Metadata;
import elki.result.ResultHandler;
import elki.result.ResultUtil;
import elki.result.outlier.OutlierResult;
import elki.utilities.datastructures.hierarchy.Hierarchy;
import elki.utilities.datastructures.iterator.ArrayListIter;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.documentation.Reference;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.FormatUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.FileParameter;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.pairs.DoubleObjPair;
import elki.utilities.scaling.outlier.OutlierLinearScaling;
import elki.utilities.scaling.outlier.OutlierScaling;
import elki.workflow.OutputStep;
import java.awt.Color;
import java.awt.Desktop;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

@Reference(authors="Erich Achtert, Ahmed Hettab, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Spatial Outlier Detection: Data, Algorithms, Visualizations", booktitle="Proc. 12th Int. Symp. Spatial and Temporal Databases (SSTD 2011)", url="https://doi.org/10.1007/978-3-642-22922-0_41", bibkey="DBLP:conf/ssd/AchtertHKSZ11")
public class KMLOutputHandler
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(KMLOutputHandler.class);
    private static final int NUMSTYLES = 20;
    Path filename;
    OutlierScaling scaling;
    private boolean compat;
    private boolean autoopen;

    public KMLOutputHandler(Path filename, OutlierScaling scaling, boolean compat, boolean autoopen) {
        this.filename = filename;
        this.scaling = scaling;
        this.compat = compat;
        this.autoopen = autoopen;
    }

    public void processNewResult(Object newResult) {
        XMLStreamWriter xmlw;
        ZipOutputStream out;
        XMLOutputFactory factory;
        ArrayList ors = ResultUtil.filterResults((Object)newResult, OutlierResult.class);
        ArrayList crs = ResultUtil.filterResults((Object)newResult, Clustering.class);
        if (ors.size() + crs.size() > 1) {
            throw new AbortException("More than one visualizable result found. The KML writer only supports a single result!");
        }
        Database database = ResultUtil.findDatabase((Object)newResult);
        for (OutlierResult outlierResult : ors) {
            try {
                factory = XMLOutputFactory.newInstance();
                out = new ZipOutputStream(Files.newOutputStream(this.filename, new OpenOption[0]));
                out.putNextEntry(new ZipEntry("doc.kml"));
                xmlw = factory.createXMLStreamWriter(out);
                this.writeOutlierResult(xmlw, outlierResult, database);
                xmlw.flush();
                xmlw.close();
                out.closeEntry();
                out.flush();
                out.close();
                if (!this.autoopen) continue;
                Desktop.getDesktop().open(this.filename.toFile());
            }
            catch (XMLStreamException e) {
                LOG.exception((Throwable)e);
                throw new AbortException("XML error in KML output.", (Throwable)e);
            }
            catch (IOException e) {
                LOG.exception((Throwable)e);
                throw new AbortException("IO error in KML output.", (Throwable)e);
            }
        }
        for (Clustering clusteringResult : crs) {
            try {
                factory = XMLOutputFactory.newInstance();
                out = new ZipOutputStream(Files.newOutputStream(this.filename, new OpenOption[0]));
                out.putNextEntry(new ZipEntry("doc.kml"));
                xmlw = factory.createXMLStreamWriter(out);
                Clustering cres = clusteringResult;
                this.writeClusteringResult(xmlw, (Clustering<Model>)cres, database);
                xmlw.flush();
                xmlw.close();
                out.closeEntry();
                out.flush();
                out.close();
                if (!this.autoopen) continue;
                Desktop.getDesktop().open(this.filename.toFile());
            }
            catch (XMLStreamException e) {
                LOG.exception((Throwable)e);
                throw new AbortException("XML error in KML output.", (Throwable)e);
            }
            catch (IOException e) {
                LOG.exception((Throwable)e);
                throw new AbortException("IO error in KML output.", (Throwable)e);
            }
        }
    }

    private void writeOutlierResult(XMLStreamWriter xmlw, OutlierResult outlierResult, Database database) throws XMLStreamException {
        Relation polys = database.getRelation((TypeInformation)TypeUtil.POLYGON_TYPE, new Object[0]);
        Relation labels = DatabaseUtil.guessObjectLabelRepresentation((Database)database);
        xmlw.writeStartDocument();
        xmlw.writeCharacters("\n");
        xmlw.writeStartElement("kml");
        xmlw.writeDefaultNamespace("http://earth.google.com/kml/2.2");
        xmlw.writeStartElement("Document");
        xmlw.writeStartElement("name");
        xmlw.writeCharacters("ELKI KML output for " + Metadata.of((Object)outlierResult).getLongName());
        xmlw.writeEndElement();
        this.writeNewlineOnDebug(xmlw);
        xmlw.writeStartElement("description");
        xmlw.writeCharacters("ELKI KML output for " + Metadata.of((Object)outlierResult).getLongName());
        xmlw.writeEndElement();
        this.writeNewlineOnDebug(xmlw);
        for (int i = 0; i < 20; ++i) {
            Color col = KMLOutputHandler.getColorForValue((double)i / 19.0);
            xmlw.writeStartElement("Style");
            xmlw.writeAttribute("id", "s" + i);
            this.writeNewlineOnDebug(xmlw);
            xmlw.writeStartElement("LineStyle");
            xmlw.writeStartElement("width");
            xmlw.writeCharacters("0");
            xmlw.writeEndElement();
            xmlw.writeEndElement();
            this.writeNewlineOnDebug(xmlw);
            xmlw.writeStartElement("PolyStyle");
            xmlw.writeStartElement("color");
            xmlw.writeCharacters(String.format("%02x%02x%02x%02x", col.getAlpha(), col.getBlue(), col.getGreen(), col.getRed()));
            xmlw.writeEndElement();
            xmlw.writeStartElement("outline");
            xmlw.writeCharacters("0");
            xmlw.writeEndElement();
            xmlw.writeEndElement();
            this.writeNewlineOnDebug(xmlw);
            xmlw.writeEndElement();
            this.writeNewlineOnDebug(xmlw);
        }
        DoubleRelation scores = outlierResult.getScores();
        LinkedList otherrel = new LinkedList(database.getRelations());
        otherrel.remove(scores);
        otherrel.remove(polys);
        otherrel.remove(labels);
        otherrel.remove(database.getRelation((TypeInformation)TypeUtil.DBID, new Object[0]));
        ArrayModifiableDBIDs ids = DBIDUtil.newArray((DBIDs)scores.getDBIDs());
        this.scaling.prepare(outlierResult);
        DBIDArrayMIter iter = outlierResult.getOrdering().order((DBIDs)ids).iter();
        while (iter.valid()) {
            double score = scores.doubleValue((DBIDRef)iter);
            PolygonsObject poly = (PolygonsObject)polys.get((DBIDRef)iter);
            String label = (String)labels.get((DBIDRef)iter);
            if (Double.isNaN(score)) {
                LOG.warning((CharSequence)("No score for object " + DBIDUtil.toString((DBIDRef)iter)));
            }
            if (poly == null) {
                LOG.warning((CharSequence)("No polygon for object " + DBIDUtil.toString((DBIDRef)iter) + " - skipping."));
            } else {
                xmlw.writeStartElement("Placemark");
                xmlw.writeStartElement("name");
                xmlw.writeCharacters(score + " " + label);
                xmlw.writeEndElement();
                StringBuilder buf = this.makeDescription(otherrel, (DBIDRef)iter);
                xmlw.writeStartElement("description");
                xmlw.writeCData("<div>" + buf.toString() + "</div>");
                xmlw.writeEndElement();
                xmlw.writeStartElement("styleUrl");
                int style = (int)(this.scaling.getScaled(score) * 20.0);
                style = Math.max(0, Math.min(style, 19));
                xmlw.writeCharacters("#s" + style);
                xmlw.writeEndElement();
                xmlw.writeStartElement("Polygon");
                this.writeNewlineOnDebug(xmlw);
                if (this.compat) {
                    xmlw.writeStartElement("altitudeMode");
                    xmlw.writeCharacters("relativeToGround");
                    xmlw.writeEndElement();
                    this.writeNewlineOnDebug(xmlw);
                }
                boolean first = true;
                for (Polygon p : poly.getPolygons()) {
                    if (first) {
                        xmlw.writeStartElement("outerBoundaryIs");
                    } else {
                        xmlw.writeStartElement("innerBoundaryIs");
                    }
                    xmlw.writeStartElement("LinearRing");
                    xmlw.writeStartElement("coordinates");
                    boolean reverse = p.testClockwise() >= 0;
                    ArrayListIter it = p.iter();
                    if (reverse) {
                        it.seek(p.size() - 1);
                    }
                    while (it.valid()) {
                        double[] v = (double[])it.get();
                        xmlw.writeCharacters(FormatUtil.format((double[])v, (String)","));
                        if (this.compat && v.length == 2) {
                            xmlw.writeCharacters(",50");
                        }
                        xmlw.writeCharacters(" ");
                        if (!reverse) {
                            it.advance();
                            continue;
                        }
                        it.retract();
                    }
                    xmlw.writeEndElement();
                    xmlw.writeEndElement();
                    xmlw.writeEndElement();
                    first = false;
                }
                this.writeNewlineOnDebug(xmlw);
                xmlw.writeEndElement();
                xmlw.writeEndElement();
                this.writeNewlineOnDebug(xmlw);
            }
            iter.advance();
        }
        xmlw.writeEndElement();
        xmlw.writeEndElement();
        xmlw.writeEndDocument();
    }

    private void writeClusteringResult(XMLStreamWriter xmlw, Clustering<Model> clustering, Database database) throws XMLStreamException {
        xmlw.writeStartDocument();
        xmlw.writeCharacters("\n");
        xmlw.writeStartElement("kml");
        xmlw.writeDefaultNamespace("http://earth.google.com/kml/2.2");
        xmlw.writeStartElement("Document");
        xmlw.writeStartElement("name");
        xmlw.writeCharacters("ELKI KML output for " + Metadata.of(clustering).getLongName());
        xmlw.writeEndElement();
        this.writeNewlineOnDebug(xmlw);
        xmlw.writeStartElement("description");
        xmlw.writeCharacters("ELKI KML output for " + Metadata.of(clustering).getLongName());
        xmlw.writeEndElement();
        this.writeNewlineOnDebug(xmlw);
        List clusters = clustering.getAllClusters();
        Relation coords = database.getRelation((TypeInformation)TypeUtil.NUMBER_VECTOR_FIELD_2D, new Object[0]);
        List topc = clustering.getToplevelClusters();
        Hierarchy hier = clustering.getClusterHierarchy();
        HashMap<Object, DoubleObjPair<Polygon>> hullmap = new HashMap<Object, DoubleObjPair<Polygon>>();
        for (Cluster clu : topc) {
            this.buildHullsRecursively((Cluster<Model>)clu, (Hierarchy<Cluster<Model>>)hier, hullmap, (Relation<? extends NumberVector>)coords);
        }
        double projarea = 648.0;
        Iterator it = clusters.iterator();
        int i = 0;
        while (it.hasNext()) {
            Cluster clus = (Cluster)it.next();
            Color col = Color.getHSBColor((float)i / 4.294967f, 1.0f, 0.5f);
            DoubleObjPair pair = (DoubleObjPair)hullmap.get(clus);
            double hullarea = SpatialUtil.volume((SpatialComparable)((SpatialComparable)pair.second));
            double relativeArea = Math.max(1.0 - hullarea / 648.0, 0.0);
            double opacity = 0.65 * Math.sqrt(relativeArea) + 0.1;
            xmlw.writeStartElement("Style");
            xmlw.writeAttribute("id", "s" + i);
            this.writeNewlineOnDebug(xmlw);
            xmlw.writeStartElement("LineStyle");
            xmlw.writeStartElement("width");
            xmlw.writeCharacters("0");
            xmlw.writeEndElement();
            xmlw.writeEndElement();
            this.writeNewlineOnDebug(xmlw);
            xmlw.writeStartElement("PolyStyle");
            xmlw.writeStartElement("color");
            xmlw.writeCharacters(String.format("%02x%02x%02x%02x", (int)(255.0 * Math.min(0.75, opacity)), col.getBlue(), col.getGreen(), col.getRed()));
            xmlw.writeEndElement();
            xmlw.writeStartElement("outline");
            xmlw.writeCharacters("0");
            xmlw.writeEndElement();
            xmlw.writeEndElement();
            this.writeNewlineOnDebug(xmlw);
            xmlw.writeEndElement();
            this.writeNewlineOnDebug(xmlw);
            ++i;
        }
        Cluster ignore = topc.size() == 1 ? (Cluster)topc.get(0) : null;
        Iterator it2 = clusters.iterator();
        int cnum = 0;
        while (it2.hasNext()) {
            Cluster c = (Cluster)it2.next();
            if (c != ignore) {
                Polygon p = (Polygon)((DoubleObjPair)hullmap.get((Object)c)).second;
                xmlw.writeStartElement("Placemark");
                xmlw.writeStartElement("name");
                xmlw.writeCharacters(c.getNameAutomatic());
                xmlw.writeEndElement();
                xmlw.writeStartElement("description");
                xmlw.writeCData(this.makeDescription(c).toString());
                xmlw.writeEndElement();
                xmlw.writeStartElement("styleUrl");
                xmlw.writeCharacters("#s" + cnum);
                xmlw.writeEndElement();
                xmlw.writeStartElement("Polygon");
                this.writeNewlineOnDebug(xmlw);
                if (this.compat) {
                    xmlw.writeStartElement("altitudeMode");
                    xmlw.writeCharacters("relativeToGround");
                    xmlw.writeEndElement();
                    this.writeNewlineOnDebug(xmlw);
                }
                xmlw.writeStartElement("outerBoundaryIs");
                xmlw.writeStartElement("LinearRing");
                xmlw.writeStartElement("coordinates");
                boolean reverse = p.testClockwise() >= 0;
                ArrayListIter itp = p.iter();
                if (reverse) {
                    itp.seek(p.size() - 1);
                }
                while (itp.valid()) {
                    double[] v = (double[])itp.get();
                    xmlw.writeCharacters(FormatUtil.format((double[])v, (String)","));
                    if (this.compat && v.length == 2) {
                        xmlw.writeCharacters(",100");
                    }
                    xmlw.writeCharacters(" ");
                    if (!reverse) {
                        itp.advance();
                        continue;
                    }
                    itp.retract();
                }
                xmlw.writeEndElement();
                xmlw.writeEndElement();
                xmlw.writeEndElement();
                this.writeNewlineOnDebug(xmlw);
                xmlw.writeEndElement();
                xmlw.writeEndElement();
                this.writeNewlineOnDebug(xmlw);
            }
            ++cnum;
        }
        xmlw.writeEndElement();
        xmlw.writeEndElement();
        xmlw.writeEndDocument();
    }

    private DoubleObjPair<Polygon> buildHullsRecursively(Cluster<Model> clu, Hierarchy<Cluster<Model>> hier, Map<Object, DoubleObjPair<Polygon>> hulls, Relation<? extends NumberVector> coords) {
        int numc;
        DBIDs ids = clu.getIDs();
        FilteredConvexHull2D hull = new FilteredConvexHull2D();
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            hull.add(((NumberVector)coords.get((DBIDRef)iter)).toArray());
            iter.advance();
        }
        double weight = ids.size();
        if (hier != null && (numc = hier.numChildren(clu)) > 0) {
            It iter2 = hier.iterChildren(clu);
            while (iter2.valid()) {
                Cluster iclu = (Cluster)iter2.get();
                DoubleObjPair<Polygon> poly = hulls.get(iclu);
                if (poly == null) {
                    poly = this.buildHullsRecursively((Cluster<Model>)iclu, hier, hulls, coords);
                }
                ArrayListIter vi = ((Polygon)poly.second).iter();
                while (vi.valid()) {
                    hull.add((double[])vi.get());
                    vi.advance();
                }
                weight += poly.first / (double)numc;
                iter2.advance();
            }
        }
        DoubleObjPair pair = new DoubleObjPair(weight, (Object)hull.getHull());
        hulls.put(clu, (DoubleObjPair<Polygon>)pair);
        return pair;
    }

    private StringBuilder makeDescription(Collection<Relation<?>> relations, DBIDRef id) {
        StringBuilder buf = new StringBuilder();
        for (Relation<?> rel : relations) {
            String s;
            Object o = rel.get(id);
            if (o == null || (s = o.toString()) == null) continue;
            if (buf.length() > 0) {
                buf.append("<br />");
            }
            buf.append(s);
        }
        return buf;
    }

    private StringBuilder makeDescription(Cluster<?> c) {
        return new StringBuilder(200).append("<div>").append(c.getNameAutomatic()).append("<br />").append("Size: ").append(c.size()).append("</div>");
    }

    private void writeNewlineOnDebug(XMLStreamWriter out) throws XMLStreamException {
        if (LOG.isDebugging()) {
            out.writeCharacters("\n");
        }
    }

    public static final Color getColorForValue(double val) {
        double[] pos = new double[]{0.0, 0.6, 0.8, 1.0};
        Color[] cols = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.6f), new Color(0.0f, 0.0f, 1.0f, 0.8f), new Color(1.0f, 0.0f, 0.0f, 0.9f), new Color(1.0f, 1.0f, 0.0f, 1.0f)};
        assert (pos.length == cols.length);
        if (val < pos[0]) {
            val = pos[0];
        }
        for (int i = 1; i < pos.length; ++i) {
            if (!(val <= pos[i])) continue;
            Color prev = cols[i - 1];
            Color next = cols[i];
            double mix = (val - pos[i - 1]) / (pos[i] - pos[i - 1]);
            int r = (int)((1.0 - mix) * (double)prev.getRed() + mix * (double)next.getRed());
            int g = (int)((1.0 - mix) * (double)prev.getGreen() + mix * (double)next.getGreen());
            int b = (int)((1.0 - mix) * (double)prev.getBlue() + mix * (double)next.getBlue());
            int a = (int)((1.0 - mix) * (double)prev.getAlpha() + mix * (double)next.getAlpha());
            Color col = new Color(r, g, b, a);
            return col;
        }
        return cols[cols.length - 1];
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID SCALING_ID = new OptionID("kml.scaling", "Additional scaling function for KML colorization.");
        public static final OptionID COMPAT_ID = new OptionID("kml.compat", "Use simpler KML objects, compatibility mode.");
        public static final OptionID AUTOOPEN_ID = new OptionID("kml.autoopen", "Automatically open the result file.");
        Path filename;
        OutlierScaling scaling;
        boolean compat;
        boolean autoopen = false;

        public void configure(Parameterization config) {
            OptionID opt = new OptionID(OutputStep.Par.OUTPUT_ID.getName(), "Filename the KMZ file (compressed KML) is written to.");
            new FileParameter(opt, FileParameter.FileType.OUTPUT_FILE).grab(config, x -> {
                this.filename = Paths.get(x);
            });
            new ObjectParameter(SCALING_ID, OutlierScaling.class, OutlierLinearScaling.class).grab(config, x -> {
                this.scaling = x;
            });
            new Flag(COMPAT_ID).grab(config, x -> {
                this.compat = x;
            });
            new Flag(AUTOOPEN_ID).grab(config, x -> {
                this.autoopen = x;
            });
        }

        public KMLOutputHandler make() {
            return new KMLOutputHandler(this.filename, this.scaling, this.compat, this.autoopen);
        }
    }
}

