/*
 * Decompiled with CFR 0.152.
 */
package elki.result;

import elki.logging.Logging;
import elki.result.Metadata;
import elki.result.ResultHandler;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.documentation.Description;

@Description(value="Development result handler that merely logs the structure of the result tree.")
public class LogResultStructureResultHandler
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(LogResultStructureResultHandler.class);

    public void processNewResult(Object newResult) {
        if (LOG.isVerbose()) {
            StringBuilder buf = new StringBuilder();
            this.recursiveLogResult(buf, newResult, 0);
            LOG.verbose((CharSequence)buf.toString());
        }
    }

    private void recursiveLogResult(StringBuilder buf, Object result, int depth) {
        if (result == null) {
            buf.append("null");
            LOG.warning((CharSequence)"null result!");
            return;
        }
        if (depth > 50) {
            LOG.warning((CharSequence)"Probably infinitely nested results, aborting!");
            return;
        }
        for (int i = 0; i < depth; ++i) {
            buf.append(' ');
        }
        buf.append(result.getClass().getSimpleName()).append(": ");
        Metadata m = Metadata.get((Object)result);
        if (m != null) {
            buf.append(m.getLongName());
        }
        buf.append('\n');
        It iter = Metadata.hierarchyOf((Object)result).iterChildren();
        while (iter.valid()) {
            this.recursiveLogResult(buf, iter.get(), depth + 1);
            iter.advance();
        }
    }
}

