/*
 * Decompiled with CFR 0.152.
 */
package elki.result;

import elki.logging.Logging;
import elki.result.ResultHandler;
import elki.result.ResultUtil;
import elki.result.textwriter.MultipleFilesOutput;
import elki.result.textwriter.SingleStreamOutput;
import elki.result.textwriter.StreamFactory;
import elki.result.textwriter.TextWriter;
import elki.utilities.Priority;
import elki.utilities.io.FileUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameterization.UnParameterization;
import elki.utilities.optionhandling.parameters.FileParameter;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.PatternParameter;
import elki.workflow.OutputStep;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;

@Priority(value=100)
public class ResultWriter
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(ResultWriter.class);
    private Path out;
    private boolean gzip = false;
    private boolean warnoverwrite = true;
    private Pattern filter = null;

    public ResultWriter(Path out, boolean gzip, boolean warnoverwrite, Pattern filter) {
        this.out = out;
        this.gzip = gzip;
        this.warnoverwrite = warnoverwrite;
        this.filter = filter;
    }

    public void processNewResult(Object result) {
        TextWriter writer = new TextWriter();
        try (StreamFactory output = this.openStreamFactory();){
            writer.output(ResultUtil.findDatabase((Object)result), result, output, this.filter);
        }
        catch (IOException e) {
            throw new IllegalStateException("Input/Output error while writing result.", e);
        }
    }

    private StreamFactory openStreamFactory() throws IOException {
        if (this.out == null) {
            return new SingleStreamOutput();
        }
        String ext = FileUtil.getFilenameExtension((Path)this.out);
        if (!(Files.exists(this.out, new LinkOption[0]) || "gz".equals(ext) || "csv".equals(ext) || "ascii".equals(ext) || "txt".equals(ext))) {
            LOG.info((CharSequence)("Creating output directory: " + this.out));
            Files.createDirectories(this.out, new FileAttribute[0]);
        }
        if (Files.isDirectory(this.out, new LinkOption[0])) {
            if (this.warnoverwrite && Files.list(this.out).findFirst().isPresent()) {
                LOG.warning((CharSequence)"Output directory specified is not empty. Files will be overwritten and old files may be left over.");
            }
            return new MultipleFilesOutput(this.out, this.gzip);
        }
        if (this.warnoverwrite && Files.exists(this.out, new LinkOption[0]) && Files.size(this.out) > 0L) {
            LOG.warning((CharSequence)"Output file exists and will be overwritten!");
        }
        return new SingleStreamOutput(this.out, this.gzip);
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID GZIP_OUTPUT_ID = new OptionID("out.gzip", "Enable gzip compression of output files.");
        public static final OptionID OVERWRITE_OPTION_ID = new OptionID("out.silentoverwrite", "Silently overwrite output files.");
        public static final OptionID FILTER_PATTERN_ID = new OptionID("out.filter", "Filter pattern for output selection. Only output streams that match the given pattern will be written.");
        private Path out = null;
        private boolean gzip = false;
        private boolean warnoverwrite = true;
        private Pattern filter = null;

        public void configure(Parameterization config) {
            ((FileParameter)new FileParameter(OutputStep.Par.OUTPUT_ID, FileParameter.FileType.OUTPUT_FILE).setOptional(true)).grab(config, x -> {
                this.out = Paths.get(x);
            });
            if (this.out != null || config instanceof UnParameterization) {
                new Flag(GZIP_OUTPUT_ID).grab(config, x -> {
                    this.gzip = x;
                });
                new Flag(OVERWRITE_OPTION_ID).grab(config, x -> {
                    this.warnoverwrite = !x;
                });
            }
            ((PatternParameter)new PatternParameter(FILTER_PATTERN_ID).setOptional(true)).grab(config, x -> {
                this.filter = x;
            });
        }

        public ResultWriter make() {
            return new ResultWriter(this.out, this.gzip, this.warnoverwrite, this.filter);
        }
    }
}

