/*
 * Decompiled with CFR 0.152.
 */
package elki.result;

import elki.data.spatial.SpatialComparable;
import elki.database.relation.Relation;
import elki.math.scales.LinearScale;
import elki.math.scales.Scales;
import elki.result.Metadata;
import elki.utilities.datastructures.iterator.It;

public class ScalesResult {
    private LinearScale[] scales;

    public ScalesResult(Relation<? extends SpatialComparable> relation) {
        this(Scales.calcScales(relation));
    }

    public ScalesResult(LinearScale[] scales) {
        this.scales = scales;
    }

    public LinearScale getScale(int dim) {
        return this.scales[dim - 1];
    }

    public void setScale(int dim, LinearScale scale) {
        this.scales[dim - 1] = scale;
    }

    public LinearScale[] getScales() {
        return this.scales;
    }

    public static ScalesResult getScalesResult(Relation<? extends SpatialComparable> rel) {
        It it = Metadata.hierarchyOf(rel).iterDescendantsSelf().filter(ScalesResult.class);
        if (it.valid()) {
            return (ScalesResult)it.get();
        }
        ScalesResult newsca = new ScalesResult(rel);
        Metadata.hierarchyOf(rel).addChild((Object)newsca);
        return newsca;
    }
}

