/*
 * Decompiled with CFR 0.152.
 */
package elki.result;

import elki.result.Metadata;
import elki.utilities.optionhandling.parameterization.TrackedParameter;
import elki.utilities.optionhandling.parameters.ClassParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SettingsResult {
    Collection<SettingInformation> settings = new ArrayList<SettingInformation>();

    public SettingsResult(Collection<TrackedParameter> settings) {
        Metadata.of((Object)this).setLongName("Settings");
        Object lastOwner = new Object();
        String ownername = "[unknown]";
        for (TrackedParameter setting : settings) {
            if (setting.getOwner() != lastOwner && setting.getOwner() != null) {
                try {
                    ownername = setting.getOwner() instanceof Class ? ((Class)setting.getOwner()).getName() : setting.getOwner().getClass().getName();
                    if (ClassParameter.class.isInstance(setting.getOwner())) {
                        ownername = ((Class)((ClassParameter)setting.getOwner()).getValue()).getName();
                    }
                }
                catch (NullPointerException e) {
                    ownername = "[null]";
                }
                lastOwner = setting.getOwner();
            }
            String name = setting.getParameter().getOptionID().getName();
            String value = "[unset]";
            try {
                if (setting.getParameter().isDefined()) {
                    value = setting.getParameter().getValueAsString();
                }
            }
            catch (NullPointerException e) {
                value = "[null]";
            }
            this.settings.add(new SettingInformation(ownername, name, value));
        }
    }

    public Collection<SettingInformation> getSettings() {
        return this.settings;
    }

    public static List<SettingsResult> getSettingsResults(Object r) {
        return (List)Metadata.hierarchyOf((Object)r).iterDescendantsSelf().filter(SettingsResult.class).collect(new ArrayList());
    }

    public static class SettingInformation {
        public String owner;
        public String name;
        public String value;

        public SettingInformation(String owner, String name, String value) {
            this.owner = owner;
            this.name = name;
            this.value = value;
        }
    }
}

