/*
 * Decompiled with CFR 0.152.
 */
package elki.result.textwriter;

import elki.logging.Logging;
import elki.result.textwriter.StreamFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPOutputStream;

public class MultipleFilesOutput
implements StreamFactory {
    private static final String EXTENSION = ".txt";
    private static final String GZIP_EXTENSION = ".gz";
    private Path basename;
    private boolean usegzip = false;
    private static final Logging LOG = Logging.getLogger(MultipleFilesOutput.class);

    public MultipleFilesOutput(Path base) {
        this(base, false);
    }

    public MultipleFilesOutput(Path base, boolean gzip) {
        this.basename = base;
        this.usegzip = gzip;
    }

    private PrintStream newStream(String name) throws IOException {
        if (LOG.isDebuggingFiner()) {
            LOG.debugFiner((CharSequence)("Requested stream: " + name));
        }
        Files.createDirectories(this.basename, new FileAttribute[0]);
        Path fn = this.basename.resolve(name + (this.usegzip ? GZIP_EXTENSION : EXTENSION));
        OutputStream os = Files.newOutputStream(fn, new OpenOption[0]);
        PrintStream res = new PrintStream(this.usegzip ? new GZIPOutputStream(os) : os);
        if (LOG.isDebuggingFiner()) {
            LOG.debugFiner((CharSequence)("Opened new output stream:" + fn));
        }
        return res;
    }

    public PrintStream openStream(String filename) throws IOException {
        return this.newStream(filename);
    }

    public void closeStream(PrintStream stream) {
        stream.close();
    }

    public void close() throws IOException {
    }
}

