/*
 * Decompiled with CFR 0.152.
 */
package elki.result.textwriter;

import elki.result.textwriter.StreamFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPOutputStream;

public class SingleStreamOutput
implements StreamFactory {
    private PrintStream stream;

    public SingleStreamOutput() throws IOException {
        this(System.out);
    }

    public SingleStreamOutput(Path out) throws IOException {
        this(Files.newOutputStream(out, new OpenOption[0]));
    }

    public SingleStreamOutput(Path out, boolean gzip) throws IOException {
        this(Files.newOutputStream(out, new OpenOption[0]), gzip);
    }

    public SingleStreamOutput(OutputStream out) throws IOException {
        this(out, false);
    }

    public SingleStreamOutput(OutputStream out, boolean gzip) throws IOException {
        this.stream = new PrintStream(gzip ? new GZIPOutputStream(out) : out);
    }

    public SingleStreamOutput(PrintStream os) {
        this.stream = os;
    }

    public PrintStream openStream(String filename) {
        return this.stream;
    }

    public void closeStream(PrintStream stream) {
    }

    public void close() throws IOException {
        if (this.stream == System.out) {
            this.stream.flush();
            return;
        }
        this.stream.close();
    }
}

