/*
 * Decompiled with CFR 0.152.
 */
package elki.result.textwriter;

import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.FeatureVector;
import elki.data.HierarchicalClassLabel;
import elki.data.LabelList;
import elki.data.SimpleClassLabel;
import elki.data.model.Model;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.Database;
import elki.database.ids.DBID;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.Relation;
import elki.datasource.bundle.SingleObjectBundle;
import elki.evaluation.classification.ConfusionMatrixEvaluationResult;
import elki.math.geometry.XYCurve;
import elki.result.CollectionResult;
import elki.result.IterableResult;
import elki.result.Metadata;
import elki.result.OrderingResult;
import elki.result.SettingsResult;
import elki.result.textwriter.StreamFactory;
import elki.result.textwriter.TextWriteable;
import elki.result.textwriter.TextWriterStream;
import elki.result.textwriter.TextWriterWriterInterface;
import elki.result.textwriter.naming.NamingScheme;
import elki.result.textwriter.naming.SimpleEnumeratingScheme;
import elki.result.textwriter.writers.TextWriterConfusionMatrixResult;
import elki.result.textwriter.writers.TextWriterDoubleArray;
import elki.result.textwriter.writers.TextWriterDoubleDoublePair;
import elki.result.textwriter.writers.TextWriterIntArray;
import elki.result.textwriter.writers.TextWriterObjectArray;
import elki.result.textwriter.writers.TextWriterObjectComment;
import elki.result.textwriter.writers.TextWriterObjectInline;
import elki.result.textwriter.writers.TextWriterPair;
import elki.result.textwriter.writers.TextWriterTextWriteable;
import elki.result.textwriter.writers.TextWriterXYCurve;
import elki.utilities.HandlerList;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.pairs.DoubleDoublePair;
import elki.utilities.pairs.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TextWriter {
    public static final String FILE_EXTENSION = ".txt";
    public static final HandlerList<TextWriterWriterInterface<?>> writers = new HandlerList();
    protected Map<String, Object> filenames = new HashMap<String, Object>();
    private TextWriterWriterInterface<?> fallback = new TextWriterObjectComment();

    protected String getFilename(Object result, String filenamepre) {
        if (filenamepre == null || filenamepre.length() == 0) {
            filenamepre = "result";
        }
        int i = 0;
        while (true) {
            String filename;
            Object existing;
            if ((existing = this.filenames.get(filename = i > 0 ? filenamepre + "-" + i : filenamepre)) == null || existing == result) {
                this.filenames.put(filename, result);
                return filename;
            }
            ++i;
        }
    }

    public void output(Database db, Object r, StreamFactory streamOpener, Pattern filter) throws IOException {
        LinkedList ra = new LinkedList();
        LinkedList ro = new LinkedList();
        LinkedList rc = new LinkedList();
        LinkedList ri = new LinkedList();
        LinkedList<SettingsResult> rs = new LinkedList<SettingsResult>();
        LinkedList otherres = new LinkedList();
        Metadata.hierarchyOf((Object)r).iterDescendantsSelf().forEach(res -> {
            String nam;
            if (!(filter == null || (nam = Metadata.of((Object)res).getLongName()) != null && filter.matcher(nam).find())) {
                return;
            }
            if (res instanceof Database) {
                return;
            }
            if (res instanceof Relation) {
                ra.add((Relation)res);
            } else if (res instanceof OrderingResult) {
                ro.add((OrderingResult)res);
            } else if (res instanceof Clustering) {
                rc.add((Clustering)res);
            } else if (res instanceof IterableResult) {
                ri.add((IterableResult)res);
            } else if (res instanceof SettingsResult) {
                rs.add((SettingsResult)res);
            } else {
                otherres.add(res);
            }
        });
        this.writeSettingsResult(streamOpener, rs);
        for (IterableResult rii : ri) {
            this.writeIterableResult(streamOpener, rii);
        }
        for (Clustering c : rc) {
            SimpleEnumeratingScheme naming = new SimpleEnumeratingScheme(c);
            for (Cluster clus : c.getAllClusters()) {
                this.writeClusterResult(db, streamOpener, (Clustering<Model>)c, (Cluster<Model>)clus, ra, naming);
            }
        }
        for (OrderingResult ror : ro) {
            this.writeOrderingResult(db, streamOpener, ror, ra);
        }
        for (Object otherr : otherres) {
            this.writeOtherResult(streamOpener, otherr);
        }
    }

    private void printObject(TextWriterStream out, Database db, DBIDRef objID, List<Relation<?>> ra) throws IOException {
        SingleObjectBundle bundle = db.getBundle(objID);
        for (int i = 0; i < bundle.metaLength(); ++i) {
            Object obj = bundle.data(i);
            if (obj == null) continue;
            TextWriterWriterInterface owriter = out.getWriterFor(obj);
            if (owriter == null) {
                throw new IOException("No handler for database object itself: " + obj.getClass().getSimpleName());
            }
            String lbl = null;
            if (TypeUtil.DBID.isAssignableFromType((TypeInformation)bundle.meta(i))) {
                lbl = "ID";
            }
            owriter.writeObject(out, lbl, obj);
        }
        Collection dbrels = db.getRelations();
        if (ra != null) {
            for (Relation<?> a : ra) {
                TextWriterWriterInterface writer;
                if (dbrels.contains(a)) continue;
                String label = Metadata.of(a).getLongName();
                Object value = a.get(objID);
                if (value == null || (writer = out.getWriterFor(value)) == null) continue;
                writer.writeObject(out, label, value);
            }
        }
        out.flush();
    }

    private void writeClusterResult(Database db, StreamFactory streamOpener, Clustering<Model> clustering, Cluster<Model> clus, List<Relation<?>> ra, NamingScheme naming) throws FileNotFoundException, IOException {
        It iter;
        StringBuilder buf;
        String cname = naming.getNameFor(clus);
        String filename = this.filenameFromLabel(cname);
        PrintStream outStream = streamOpener.openStream(this.getFilename(clus, filename));
        TextWriterStream out = new TextWriterStream(outStream, writers, this.fallback);
        out.commentPrintLn((CharSequence)("Cluster: " + cname));
        clus.writeToText(out, null);
        if (clustering.getClusterHierarchy().numParents(clus) > 0) {
            buf = new StringBuilder(100).append("Parents:");
            iter = clustering.getClusterHierarchy().iterParents(clus);
            while (iter.valid()) {
                buf.append(' ').append(naming.getNameFor((Cluster)iter.get()));
                iter.advance();
            }
            out.commentPrintLn((CharSequence)buf.toString());
        }
        if (clustering.getClusterHierarchy().numChildren(clus) > 0) {
            buf = new StringBuilder(100).append("Children:");
            iter = clustering.getClusterHierarchy().iterChildren(clus);
            while (iter.valid()) {
                buf.append(' ').append(naming.getNameFor((Cluster)iter.get()));
                iter.advance();
            }
            out.commentPrintLn((CharSequence)buf.toString());
        }
        out.flush();
        DBIDIter iter2 = clus.getIDs().iter();
        while (iter2.valid()) {
            this.printObject(out, db, (DBIDRef)iter2, ra);
            iter2.advance();
        }
        out.flush();
        streamOpener.closeStream(outStream);
    }

    private void writeIterableResult(StreamFactory streamOpener, IterableResult<?> ri) throws IOException {
        Collection hdr;
        PrintStream outStream = streamOpener.openStream(this.getFilename(ri, Metadata.of(ri).getLongName()));
        TextWriterStream out = new TextWriterStream(outStream, writers, this.fallback);
        if (ri instanceof CollectionResult && (hdr = ((CollectionResult)ri).getHeader()) != null) {
            for (String header : hdr) {
                out.commentPrintLn((CharSequence)header);
            }
            out.flush();
        }
        for (Object o : ri) {
            TextWriterWriterInterface writer = out.getWriterFor(o);
            if (writer != null) {
                writer.writeObject(out, null, o);
            }
            out.flush();
        }
        out.flush();
        streamOpener.closeStream(outStream);
    }

    private void writeOrderingResult(Database db, StreamFactory streamOpener, OrderingResult or, List<Relation<?>> ra) throws IOException {
        PrintStream outStream = streamOpener.openStream(this.getFilename(or, Metadata.of((Object)or).getLongName()));
        TextWriterStream out = new TextWriterStream(outStream, writers, this.fallback);
        DBIDArrayMIter i = or.order(or.getDBIDs()).iter();
        while (i.valid()) {
            this.printObject(out, db, (DBIDRef)i, ra);
            i.advance();
        }
        out.flush();
        streamOpener.closeStream(outStream);
    }

    private void writeSettingsResult(StreamFactory streamOpener, List<SettingsResult> rs) throws IOException {
        if (rs.isEmpty()) {
            return;
        }
        SettingsResult r = rs.get(0);
        PrintStream outStream = streamOpener.openStream(this.getFilename(r, Metadata.of((Object)r).getLongName()));
        TextWriterStream out = new TextWriterStream(outStream, writers, this.fallback);
        out.commentPrintLn((CharSequence)"Settings:");
        for (SettingsResult settings : rs) {
            String last = null;
            for (SettingsResult.SettingInformation setting : settings.getSettings()) {
                if (setting.owner != last) {
                    if (last != null) {
                        out.commentPrintLn((CharSequence)"");
                    }
                    out.commentPrintLn((CharSequence)setting.owner);
                    last = setting.owner;
                }
                out.commentPrintLn((CharSequence)("-" + setting.name + " " + setting.value));
            }
        }
        out.flush();
        streamOpener.closeStream(outStream);
    }

    private void writeOtherResult(StreamFactory streamOpener, Object r) throws IOException {
        if (writers.getHandler(r) != null) {
            PrintStream outStream = streamOpener.openStream(this.getFilename(r, Metadata.of((Object)r).getLongName()));
            TextWriterStream out = new TextWriterStream(outStream, writers, this.fallback);
            TextWriterWriterInterface owriter = out.getWriterFor(r);
            if (owriter == null) {
                throw new IOException("No handler for result class: " + r.getClass().getSimpleName());
            }
            owriter.writeObject(out, null, r);
            out.flush();
            streamOpener.closeStream(outStream);
        }
    }

    private String filenameFromLabel(String label) {
        return label.toLowerCase().replaceAll("[^a-zA-Z0-9_.\\[\\]-]", "_");
    }

    static {
        TextWriterObjectInline trivialwriter = new TextWriterObjectInline();
        writers.insertHandler(Pair.class, (Object)new TextWriterPair());
        writers.insertHandler(DoubleDoublePair.class, (Object)new TextWriterDoubleDoublePair());
        writers.insertHandler(FeatureVector.class, (Object)trivialwriter);
        writers.insertHandler(double[].class, (Object)new TextWriterDoubleArray());
        writers.insertHandler(int[].class, (Object)new TextWriterIntArray());
        writers.insertHandler(String.class, (Object)trivialwriter);
        writers.insertHandler(Double.class, (Object)trivialwriter);
        writers.insertHandler(Integer.class, (Object)trivialwriter);
        writers.insertHandler(String[].class, new TextWriterObjectArray());
        writers.insertHandler(Double[].class, new TextWriterObjectArray());
        writers.insertHandler(Integer[].class, new TextWriterObjectArray());
        writers.insertHandler(SimpleClassLabel.class, (Object)trivialwriter);
        writers.insertHandler(HierarchicalClassLabel.class, (Object)trivialwriter);
        writers.insertHandler(LabelList.class, (Object)trivialwriter);
        writers.insertHandler(DBID.class, (Object)trivialwriter);
        writers.insertHandler(XYCurve.class, (Object)new TextWriterXYCurve());
        writers.insertHandler(TextWriteable.class, (Object)new TextWriterTextWriteable());
        writers.insertHandler(ConfusionMatrixEvaluationResult.class, (Object)new TextWriterConfusionMatrixResult());
    }
}

