/*
 * Decompiled with CFR 0.152.
 */
package elki.result.textwriter.writers;

import elki.evaluation.classification.ConfusionMatrixEvaluationResult;
import elki.result.textwriter.TextWriterStream;
import elki.result.textwriter.TextWriterWriterInterface;
import java.io.IOException;

public class TextWriterConfusionMatrixResult
extends TextWriterWriterInterface<ConfusionMatrixEvaluationResult> {
    public void write(TextWriterStream out, String label, ConfusionMatrixEvaluationResult eval) throws IOException {
        out.commentPrintLn((CharSequence)"Evaluation:");
        out.commentPrintLn((CharSequence)eval.evaluationName);
        out.commentPrintLn((CharSequence)"Accuracy: \n  correctly classified instances: ");
        out.commentPrintLn((Object)eval.confusionmatrix.truePositives());
        out.commentPrintLn((CharSequence)"true positive rate:         ");
        double tpr = eval.confusionmatrix.truePositiveRate();
        out.commentPrintLn((Object)tpr);
        out.commentPrintLn((CharSequence)"false positive rate:        ");
        out.commentPrintLn((Object)eval.confusionmatrix.falsePositiveRate());
        out.commentPrintLn((CharSequence)"positive predicted value:   ");
        double ppv = eval.confusionmatrix.positivePredictedValue();
        out.commentPrintLn((Object)ppv);
        out.commentPrintLn((CharSequence)"F1-measure:                 ");
        out.commentPrintLn((Object)(2.0 * ppv * tpr / (ppv + tpr)));
        out.commentPrintLn((CharSequence)"\nconfusion matrix:\n");
        out.commentPrintLn((CharSequence)eval.confusionmatrix.toString());
    }
}

