/*
 * Decompiled with CFR 0.152.
 */
package elki.workflow;

import elki.Algorithm;
import elki.database.Database;
import elki.index.Index;
import elki.logging.Logging;
import elki.logging.LoggingConfiguration;
import elki.logging.statistics.Duration;
import elki.logging.statistics.Statistic;
import elki.result.Metadata;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.ObjectListParameter;
import elki.workflow.WorkflowStep;
import java.util.List;

public class AlgorithmStep
implements WorkflowStep {
    private static final Logging LOG = Logging.getLogger(AlgorithmStep.class);
    private List<? extends Algorithm> algorithms;
    private Object stepresult;

    public AlgorithmStep(List<? extends Algorithm> algorithms) {
        this.algorithms = algorithms;
    }

    public Object runAlgorithms(Database database) {
        if (LOG.isStatistics()) {
            boolean first = true;
            It it = Metadata.hierarchyOf((Object)database).iterDescendants().filter(Index.class);
            while (it.valid()) {
                if (first) {
                    LOG.statistics((CharSequence)"Index statistics before running algorithms:");
                    first = false;
                }
                ((Index)it.get()).logStatistics();
                it.advance();
            }
        }
        this.stepresult = new Object();
        Metadata.of((Object)this.stepresult).setLongName("Algorithm Step");
        for (Algorithm algorithm : this.algorithms) {
            Thread.currentThread().setName(algorithm.toString());
            Duration duration = LOG.isStatistics() ? LOG.newDuration(algorithm.getClass().getName() + ".runtime").begin() : null;
            Object res = algorithm.autorun(database);
            if (duration != null) {
                LOG.statistics((Statistic)duration.end());
            }
            if (LOG.isStatistics()) {
                boolean first = true;
                It it = Metadata.hierarchyOf((Object)database).iterDescendants().filter(Index.class);
                while (it.valid()) {
                    if (first) {
                        LOG.statistics((CharSequence)("Index statistics after running algorithm " + algorithm.toString() + ":"));
                        first = false;
                    }
                    ((Index)it.get()).logStatistics();
                    it.advance();
                }
            }
            if (res == null) continue;
            Metadata.hierarchyOf((Object)database).addChild(res);
        }
        Thread.currentThread().setName("AlgorithmStep finished.");
        return this.stepresult;
    }

    public Object getResult() {
        return this.stepresult;
    }

    public static class Par
    implements Parameterizer {
        protected boolean time = false;
        protected List<? extends Algorithm> algorithms;
        public static final OptionID TIME_ID = new OptionID("time", "Enable logging of runtime data. Do not combine with more verbose logging, since verbose logging can significantly impact performance.");
        public static final OptionID ALGORITHM_ID = Algorithm.Utils.ALGORITHM_ID;

        public void configure(Parameterization config) {
            new Flag(TIME_ID).grab(config, x -> {
                this.time = x;
            });
            new ObjectListParameter(ALGORITHM_ID, Algorithm.class).grab(config, x -> {
                this.algorithms = x;
            });
        }

        public AlgorithmStep make() {
            if (this.time) {
                LoggingConfiguration.setStatistics();
            }
            return new AlgorithmStep(this.algorithms);
        }
    }
}

