/*
 * Decompiled with CFR 0.152.
 */
package elki.workflow;

import elki.database.Database;
import elki.evaluation.AutomaticEvaluation;
import elki.evaluation.Evaluator;
import elki.result.Metadata;
import elki.result.ResultListener;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ClassListParameter;
import elki.utilities.optionhandling.parameters.ObjectListParameter;
import elki.workflow.WorkflowStep;
import java.util.Arrays;
import java.util.List;

public class EvaluationStep
implements WorkflowStep {
    private List<? extends Evaluator> evaluators = null;
    private Object stepresult;

    public EvaluationStep(List<? extends Evaluator> evaluators) {
        this.evaluators = evaluators;
    }

    public void runEvaluators(Database db) {
        this.stepresult = new Object();
        Metadata.of((Object)this.stepresult).setLongName("Evaluation Step");
        if (this.evaluators != null) {
            new Evaluation(this.evaluators, db);
        }
    }

    public Object getResult() {
        return this.stepresult;
    }

    public static class Par
    implements Parameterizer {
        private List<? extends Evaluator> evaluators = null;
        public static final OptionID EVALUATOR_ID = new OptionID("evaluator", "Class to evaluate the results with.");

        public void configure(Parameterization config) {
            ((ClassListParameter)new ObjectListParameter(EVALUATOR_ID, Evaluator.class).setDefaultValue(Arrays.asList(AutomaticEvaluation.class))).grab(config, x -> {
                this.evaluators = x;
            });
        }

        public EvaluationStep make() {
            return new EvaluationStep(this.evaluators);
        }
    }

    private static class Evaluation
    implements ResultListener {
        private List<? extends Evaluator> evaluators;

        public Evaluation(List<? extends Evaluator> evaluators, Database db) {
            this.evaluators = evaluators;
            Metadata.of((Object)db).addResultListener((ResultListener)this);
            this.update(db);
        }

        public void update(Object r) {
            for (Evaluator evaluator : this.evaluators) {
                Thread.currentThread().setName(evaluator.toString());
                evaluator.processNewResult(r);
            }
            Thread.currentThread().setName("EvaluationStep finished.");
        }

        public void resultAdded(Object child, Object parent) {
            this.update(child);
        }
    }
}

