/*
 * Decompiled with CFR 0.152.
 */
package elki.workflow;

import elki.database.Database;
import elki.result.ResultHandler;
import elki.result.ResultWriter;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ClassListParameter;
import elki.utilities.optionhandling.parameters.ObjectListParameter;
import elki.workflow.WorkflowStep;
import java.util.ArrayList;
import java.util.List;

public class OutputStep
implements WorkflowStep {
    private List<? extends ResultHandler> resulthandlers = null;
    protected static ArrayList<Class<? extends ResultHandler>> defaultHandlers = null;

    public OutputStep(List<? extends ResultHandler> resulthandlers) {
        this.resulthandlers = resulthandlers;
    }

    public void runResultHandlers(Database db) {
        for (ResultHandler resultHandler : this.resulthandlers) {
            Thread.currentThread().setName(resultHandler.toString());
            resultHandler.processNewResult((Object)db);
        }
        Thread.currentThread().setName("OutputStep finished.");
    }

    public static void setDefaultHandlerWriter() {
        defaultHandlers = new ArrayList(1);
        defaultHandlers.add(ResultWriter.class);
    }

    public static void setDefaultHandlerVisualizer() {
        Class clz;
        defaultHandlers = new ArrayList(1);
        try {
            clz = Thread.currentThread().getContextClassLoader().loadClass("elki.result.AutomaticVisualization");
        }
        catch (ClassNotFoundException e) {
            clz = ResultWriter.class;
        }
        defaultHandlers.add(clz);
    }

    public static class Par
    implements Parameterizer {
        private List<? extends ResultHandler> resulthandlers = null;
        public static final OptionID RESULT_HANDLER_ID = new OptionID("resulthandler", "Result handler class.");
        public static final OptionID OUTPUT_ID = new OptionID("out", "Directory name (or name of an existing file) to write the obtained results in. If this parameter is omitted, per default the output will sequentially be given to STDOUT.");

        public void configure(Parameterization config) {
            ((ClassListParameter)new ObjectListParameter(RESULT_HANDLER_ID, ResultHandler.class).setDefaultValue(defaultHandlers)).grab(config, x -> {
                this.resulthandlers = x;
            });
        }

        public OutputStep make() {
            return new OutputStep(this.resulthandlers);
        }
    }
}

