/*
 * Decompiled with CFR 0.152.
 */
package io.github.embeddedkafka;

import io.github.embeddedkafka.EmbeddedKafkaConfig;
import io.github.embeddedkafka.ops.ZooKeeperOps;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.zookeeper.server.ServerCnxnFactory;
import scala.Function0;
import scala.Function1;
import scala.reflect.io.Directory$;
import scala.reflect.io.Path$;
import scala.runtime.BoxesRunTime;

public interface EmbeddedKafkaSupport<C extends EmbeddedKafkaConfig> {
    public <T> T withRunningServers(C var1, int var2, Path var3, Function1<C, T> var4);

    public static Object withRunningKafka$(EmbeddedKafkaSupport $this, Function0 body, EmbeddedKafkaConfig config) {
        return $this.withRunningKafka(body, config);
    }

    default public <T> T withRunningKafka(Function0<T> body, C config) {
        return this.withRunningZooKeeper(config.zooKeeperPort(), (Function1 & Serializable)actualZkPort -> this.withRunningKafka$$anonfun$1((EmbeddedKafkaConfig)config, body, BoxesRunTime.unboxToInt((Object)actualZkPort)));
    }

    public static Object withRunningKafkaOnFoundPort$(EmbeddedKafkaSupport $this, EmbeddedKafkaConfig config, Function1 body) {
        return $this.withRunningKafkaOnFoundPort(config, body);
    }

    default public <T> T withRunningKafkaOnFoundPort(C config, Function1<C, T> body) {
        return this.withRunningZooKeeper(config.zooKeeperPort(), (Function1 & Serializable)actualZkPort -> this.withRunningKafkaOnFoundPort$$anonfun$1((EmbeddedKafkaConfig)config, body, BoxesRunTime.unboxToInt((Object)actualZkPort)));
    }

    public static Object withRunningZooKeeper$(EmbeddedKafkaSupport $this, int port, Function1 body) {
        return $this.withRunningZooKeeper(port, body);
    }

    default public <T> T withRunningZooKeeper(int port, Function1<Object, T> body) {
        return this.withTempDir("zookeeper-logs", (Function1 & Serializable)zkLogsDir -> {
            Object object;
            ServerCnxnFactory factory = ((ZooKeeperOps)((Object)this)).startZooKeeper(port, (Path)zkLogsDir);
            try {
                object = body.apply((Object)BoxesRunTime.boxToInteger((int)factory.getLocalPort()));
            }
            finally {
                factory.shutdown();
            }
            return object;
        });
    }

    public static Object withTempDir$(EmbeddedKafkaSupport $this, String prefix, Function1 body) {
        return $this.withTempDir(prefix, body);
    }

    default public <T> T withTempDir(String prefix, Function1<Path, T> body) {
        Object object;
        Path dir = Files.createTempDirectory(prefix, new FileAttribute[0]);
        try {
            object = body.apply((Object)dir);
        }
        finally {
            boolean bl = Directory$.MODULE$.apply(Path$.MODULE$.jfile2path(dir.toFile())).deleteRecursively();
        }
        return (T)object;
    }

    private /* synthetic */ Object withRunningKafka$$anonfun$1(EmbeddedKafkaConfig config$1, Function0 body$1, int actualZkPort) {
        return this.withTempDir("kafka", (Function1 & Serializable)kafkaLogsDir -> this.withRunningServers((C)config$1, actualZkPort, (Path)kafkaLogsDir, (Function1 & Serializable)_$1 -> body$1.apply()));
    }

    private /* synthetic */ Object withRunningKafkaOnFoundPort$$anonfun$1(EmbeddedKafkaConfig config$3, Function1 body$4, int actualZkPort) {
        return this.withTempDir("kafka", (Function1 & Serializable)kafkaLogsDir -> this.withRunningServers((C)config$3, actualZkPort, (Path)kafkaLogsDir, (Function1)body$4));
    }
}

