/*
 * Decompiled with CFR 0.152.
 */
package io.github.embeddedkafka.ops;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.FaultHandlerFactory;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.Server$;
import kafka.server.SharedServer;
import kafka.server.StandardFaultHandlerFactory;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.server.ServerSocketFactory;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Using;
import scala.util.Using$;

public interface KafkaOps {
    public static void $init$(KafkaOps $this) {
        $this.io$github$embeddedkafka$ops$KafkaOps$_setter_$io$github$embeddedkafka$ops$KafkaOps$$logger_$eq(LoggerFactory.getLogger($this.getClass()));
        $this.io$github$embeddedkafka$ops$KafkaOps$_setter_$nodeId_$eq(0);
        $this.io$github$embeddedkafka$ops$KafkaOps$_setter_$autoCreateTopics_$eq(true);
        $this.io$github$embeddedkafka$ops$KafkaOps$_setter_$logCleanerDedupeBufferSize_$eq(0x100001);
    }

    public Logger io$github$embeddedkafka$ops$KafkaOps$$logger();

    public void io$github$embeddedkafka$ops$KafkaOps$_setter_$io$github$embeddedkafka$ops$KafkaOps$$logger_$eq(Logger var1);

    public int nodeId();

    public void io$github$embeddedkafka$ops$KafkaOps$_setter_$nodeId_$eq(int var1);

    public boolean autoCreateTopics();

    public void io$github$embeddedkafka$ops$KafkaOps$_setter_$autoCreateTopics_$eq(boolean var1);

    public int logCleanerDedupeBufferSize();

    public void io$github$embeddedkafka$ops$KafkaOps$_setter_$logCleanerDedupeBufferSize_$eq(int var1);

    public static Tuple2 startKafka$(KafkaOps $this, int kafkaPort, int controllerPort, scala.collection.immutable.Map customBrokerProperties, Path kafkaLogDir) {
        return $this.startKafka(kafkaPort, controllerPort, (scala.collection.immutable.Map<String, String>)customBrokerProperties, kafkaLogDir);
    }

    default public Tuple2<BrokerServer, ControllerServer> startKafka(int kafkaPort, int controllerPort, scala.collection.immutable.Map<String, String> customBrokerProperties, Path kafkaLogDir) {
        int actualControllerPort = this.findPortForControllerOrFail(controllerPort);
        String brokerListener = new StringBuilder(19).append("BROKER://localhost:").append(kafkaPort).toString();
        String controllerListener = new StringBuilder(23).append("CONTROLLER://localhost:").append(actualControllerPort).toString();
        Object[] objectArray = new Tuple2[17];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"process.roles");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"broker,controller");
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"node.id");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToInteger((int)this.nodeId()).toString());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"inter.broker.listener.name");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)"BROKER");
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"controller.listener.names");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)"CONTROLLER");
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"controller.quorum.voters");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)new StringBuilder(11).append(this.nodeId()).append("@localhost:").append(actualControllerPort).toString());
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"broker.id");
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)BoxesRunTime.boxToInteger((int)this.nodeId()).toString());
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"listeners");
        objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)new StringBuilder(1).append(brokerListener).append(",").append(controllerListener).toString());
        String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"advertised.listeners");
        objectArray[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)brokerListener);
        String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"listener.security.protocol.map");
        objectArray[8] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)"BROKER:PLAINTEXT,CONTROLLER:PLAINTEXT");
        String string10 = (String)Predef$.MODULE$.ArrowAssoc((Object)"auto.create.topics.enable");
        objectArray[9] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string10, (Object)BoxesRunTime.boxToBoolean((boolean)this.autoCreateTopics()).toString());
        String string11 = (String)Predef$.MODULE$.ArrowAssoc((Object)"log.dirs");
        objectArray[10] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string11, (Object)kafkaLogDir.toAbsolutePath().toString());
        String string12 = (String)Predef$.MODULE$.ArrowAssoc((Object)ServerLogConfigs.LOG_FLUSH_INTERVAL_MESSAGES_CONFIG);
        objectArray[11] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string12, (Object)BoxesRunTime.boxToInteger((int)1).toString());
        String string13 = (String)Predef$.MODULE$.ArrowAssoc((Object)"offsets.topic.replication.factor");
        objectArray[12] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string13, (Object)BoxesRunTime.boxToInteger((int)1).toString());
        String string14 = (String)Predef$.MODULE$.ArrowAssoc((Object)"offsets.topic.num.partitions");
        objectArray[13] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string14, (Object)BoxesRunTime.boxToInteger((int)1).toString());
        String string15 = (String)Predef$.MODULE$.ArrowAssoc((Object)"transaction.state.log.replication.factor");
        objectArray[14] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string15, (Object)BoxesRunTime.boxToInteger((int)1).toString());
        String string16 = (String)Predef$.MODULE$.ArrowAssoc((Object)"transaction.state.log.min.isr");
        objectArray[15] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string16, (Object)BoxesRunTime.boxToInteger((int)1).toString());
        String string17 = (String)Predef$.MODULE$.ArrowAssoc((Object)"log.cleaner.dedupe.buffer.size");
        objectArray[16] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string17, (Object)BoxesRunTime.boxToInteger((int)this.logCleanerDedupeBufferSize()).toString());
        scala.collection.immutable.Map configProperties = (scala.collection.immutable.Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus$plus(customBrokerProperties);
        KafkaConfig config = new KafkaConfig(CollectionConverters$.MODULE$.MapHasAsJava((Map)configProperties).asJava());
        Time time = Time.SYSTEM;
        String clusterIdBase64 = this.generateRandomClusterId();
        MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(clusterIdBase64).setNodeId(this.nodeId()).build();
        String logIdent = new StringBuilder(26).append("[KafkaRaftServer nodeId=").append(config.nodeId()).append("] ").toString();
        this.writeMetaProperties(Paths.get(config.metadataLogDir(), new String[0]).toFile(), metaProperties);
        Tuple2 tuple2 = KafkaRaftServer$.MODULE$.initializeLogDirs(config, this.io$github$embeddedkafka$ops$KafkaOps$$logger(), logIdent);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        MetaPropertiesEnsemble metaPropsEnsemble = (MetaPropertiesEnsemble)tuple2._1();
        BootstrapMetadata bootstrapMetadata = (BootstrapMetadata)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)metaPropsEnsemble, (Object)bootstrapMetadata);
        MetaPropertiesEnsemble metaPropsEnsemble2 = (MetaPropertiesEnsemble)tuple22._1();
        BootstrapMetadata bootstrapMetadata2 = (BootstrapMetadata)tuple22._2();
        Metrics metrics = Server$.MODULE$.initializeMetrics(config, time, (String)metaPropsEnsemble2.clusterId().get());
        SharedServer sharedServer = new SharedServer(config, metaPropsEnsemble2, time, metrics, CompletableFuture.completedFuture(QuorumConfig.parseVoterConnections((List)config.quorumConfig().voters())), (Collection)QuorumConfig.parseBootstrapServers((List)config.quorumConfig().bootstrapServers()), (FaultHandlerFactory)new StandardFaultHandlerFactory(), ServerSocketFactory.INSTANCE);
        BrokerServer broker = new BrokerServer(sharedServer);
        ControllerServer controller = new ControllerServer(sharedServer, KafkaRaftServer$.MODULE$.configSchema(), bootstrapMetadata2);
        controller.startup();
        broker.startup();
        return Tuple2$.MODULE$.apply((Object)broker, (Object)controller);
    }

    private String generateRandomClusterId() {
        return Uuid.randomUuid().toString();
    }

    private void writeMetaProperties(File logDir, MetaProperties metaProperties) {
        File metaPropertiesFile = new File(logDir.getAbsolutePath(), "meta.properties");
        PropertiesUtils.writePropertiesFile((Properties)metaProperties.toProperties(), (String)metaPropertiesFile.getAbsolutePath(), (boolean)false);
    }

    private int findPortForControllerOrFail(int controllerPort) {
        if (controllerPort == 0) {
            Try<Object> try_ = this.findRandomFreePort();
            if (try_ instanceof Success) {
                int port = BoxesRunTime.unboxToInt((Object)((Success)try_).value());
                this.io$github$embeddedkafka$ops$KafkaOps$$logger().info(new StringBuilder(31).append("Found free port ").append(port).append(" for controller").toString());
                return port;
            }
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                this.io$github$embeddedkafka$ops$KafkaOps$$logger().error("Could not find a free port for the controller", exception);
                throw new RuntimeException("Could not find a free port for the controller", exception);
            }
            throw new MatchError(try_);
        }
        return controllerPort;
    }

    private Try<Object> findRandomFreePort() {
        return Using$.MODULE$.apply(KafkaOps::findRandomFreePort$$anonfun$1, (Function1 & Serializable)serverSocket -> serverSocket.getLocalPort(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).recoverWith((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof IOException) {
                    IOException ex = (IOException)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof IOException) {
                    IOException ex = (IOException)throwable;
                    return Failure$.MODULE$.apply((Throwable)new RuntimeException("Could not find a free port", ex));
                }
                return function1.apply((Object)x);
            }
        });
    }

    private static ServerSocket findRandomFreePort$$anonfun$1() {
        return new ServerSocket(0);
    }
}

