/*
 * Decompiled with CFR 0.152.
 */
package io.github.embeddedkafka.ops;

import io.github.embeddedkafka.EmbeddedKafkaConfig;
import io.github.embeddedkafka.KafkaUnavailableException;
import io.github.embeddedkafka.package$;
import java.io.Serializable;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

public interface ProducerOps<C extends EmbeddedKafkaConfig> {
    public static void $init$(ProducerOps $this) {
        $this.io$github$embeddedkafka$ops$ProducerOps$_setter_$producerPublishTimeout_$eq(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds());
    }

    public FiniteDuration producerPublishTimeout();

    public void io$github$embeddedkafka$ops$ProducerOps$_setter_$producerPublishTimeout_$eq(FiniteDuration var1);

    public Map<String, Object> baseProducerConfig(C var1);

    public static Map defaultProducerConf$(ProducerOps $this, EmbeddedKafkaConfig config) {
        return $this.defaultProducerConf(config);
    }

    default public Map<String, Object> defaultProducerConf(C config) {
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new StringBuilder(10).append("localhost:").append(config.kafkaPort()).toString());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"max.block.ms");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToInteger((int)10000).toString());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"retry.backoff.ms");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToInteger((int)1000).toString());
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public static void publishStringMessageToKafka$(ProducerOps $this, String topic, String message, EmbeddedKafkaConfig config) {
        $this.publishStringMessageToKafka(topic, message, config);
    }

    default public void publishStringMessageToKafka(String topic, String message, C config) {
        this.publishToKafka(topic, (Object)message, config, (Serializer)new StringSerializer());
    }

    public static void publishToKafka$(ProducerOps $this, String topic, Object message, EmbeddedKafkaConfig config, Serializer serializer) {
        $this.publishToKafka(topic, message, config, serializer);
    }

    default public <T> void publishToKafka(String topic, T message, C config, Serializer<T> serializer) throws KafkaUnavailableException {
        this.publishToKafka(new KafkaProducer(CollectionConverters$.MODULE$.MapHasAsJava(this.baseProducerConfig(config)).asJava(), (Serializer)new StringSerializer(), serializer), new ProducerRecord(topic, message));
    }

    public static void publishToKafka$(ProducerOps $this, ProducerRecord producerRecord, EmbeddedKafkaConfig config, Serializer serializer) {
        $this.publishToKafka(producerRecord, config, serializer);
    }

    default public <T> void publishToKafka(ProducerRecord<String, T> producerRecord, C config, Serializer<T> serializer) throws KafkaUnavailableException {
        this.publishToKafka(new KafkaProducer(CollectionConverters$.MODULE$.MapHasAsJava(this.baseProducerConfig(config)).asJava(), (Serializer)new StringSerializer(), serializer), producerRecord);
    }

    public static void publishToKafka$(ProducerOps $this, String topic, Object key, Object message, EmbeddedKafkaConfig config, Serializer keySerializer, Serializer serializer) {
        $this.publishToKafka(topic, key, message, config, keySerializer, serializer);
    }

    default public <K, T> void publishToKafka(String topic, K key, T message, C config, Serializer<K> keySerializer, Serializer<T> serializer) throws KafkaUnavailableException {
        this.publishToKafka(new KafkaProducer(CollectionConverters$.MODULE$.MapHasAsJava(this.baseProducerConfig(config)).asJava(), keySerializer, serializer), new ProducerRecord(topic, key, message));
    }

    public static void publishToKafka$(ProducerOps $this, String topic, Seq messages, EmbeddedKafkaConfig config, Serializer keySerializer, Serializer serializer) {
        $this.publishToKafka(topic, messages, config, keySerializer, serializer);
    }

    default public <K, T> void publishToKafka(String topic, Seq<Tuple2<K, T>> messages, C config, Serializer<K> keySerializer, Serializer<T> serializer) throws KafkaUnavailableException {
        KafkaProducer producer = new KafkaProducer(CollectionConverters$.MODULE$.MapHasAsJava(this.baseProducerConfig(config)).asJava(), keySerializer, serializer);
        Function1 tupleToRecord = ((Function2 & Serializable)(Function2 & Serializable)(_$1, _$2) -> new ProducerRecord(topic, _$1, _$2)).tupled();
        Function1 futureSend = tupleToRecord.andThen((Function1 & Serializable)x$0 -> producer.send(x$0));
        Seq futures = (Seq)messages.map(futureSend);
        Seq records = (Seq)futures.map((Function1 & Serializable)f -> Try$.MODULE$.apply(() -> this.$anonfun$3$$anonfun$1(f)));
        producer.close();
        Option option = records.collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Try x) {
                Try try_ = x;
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Try x, Function1 function1) {
                Try try_ = x;
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    throw new KafkaUnavailableException(ex);
                }
                return function1.apply((Object)x);
            }
        });
    }

    public static Object withProducer$(ProducerOps $this, Function1 body, EmbeddedKafkaConfig config, Serializer keySerializer, Serializer valueSerializer) {
        return $this.withProducer(body, config, keySerializer, valueSerializer);
    }

    default public <K, V, T> T withProducer(Function1<KafkaProducer<K, V>, T> body, C config, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return package$.MODULE$.loanAndClose(new KafkaProducer(CollectionConverters$.MODULE$.MapHasAsJava(this.baseProducerConfig(config)).asJava(), keySerializer, valueSerializer), body);
    }

    private <K, T> void publishToKafka(KafkaProducer<K, T> kafkaProducer, ProducerRecord<K, T> record) {
        Future sendFuture = kafkaProducer.send(record);
        Try sendResult = Try$.MODULE$.apply(() -> this.$anonfun$4(sendFuture));
        kafkaProducer.close();
        Try try_ = sendResult;
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            throw new KafkaUnavailableException(ex);
        }
    }

    private RecordMetadata $anonfun$3$$anonfun$1(Future f$1) {
        return (RecordMetadata)f$1.get(this.producerPublishTimeout().length(), this.producerPublishTimeout().unit());
    }

    private RecordMetadata $anonfun$4(Future sendFuture$1) {
        return (RecordMetadata)sendFuture$1.get(this.producerPublishTimeout().length(), this.producerPublishTimeout().unit());
    }
}

