/*
 * Decompiled with CFR 0.152.
 */
package io.github.embeddedkafka.ops;

import io.github.embeddedkafka.EmbeddedK;
import io.github.embeddedkafka.EmbeddedK$;
import io.github.embeddedkafka.EmbeddedKafkaConfig;
import io.github.embeddedkafka.EmbeddedKafkaConfig$;
import io.github.embeddedkafka.EmbeddedServer;
import io.github.embeddedkafka.ops.KafkaOps;
import io.github.embeddedkafka.ops.RunningServersOps;
import java.io.Serializable;
import java.nio.file.Path;
import kafka.cluster.EndPoint;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;

public interface RunningKafkaOps {
    public static EmbeddedK startKafka$(RunningKafkaOps $this, Path kafkaLogsDir, EmbeddedKafkaConfig config) {
        return $this.startKafka(kafkaLogsDir, config);
    }

    default public EmbeddedK startKafka(Path kafkaLogsDir, EmbeddedKafkaConfig config) {
        Tuple2<BrokerServer, ControllerServer> tuple2 = ((KafkaOps)((Object)this)).startKafka(config.kafkaPort(), config.controllerPort(), config.customBrokerProperties(), kafkaLogsDir);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        BrokerServer brokerServer = (BrokerServer)tuple2._1();
        ControllerServer controllerServer = (ControllerServer)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)brokerServer, (Object)controllerServer);
        BrokerServer brokerServer2 = (BrokerServer)tuple22._1();
        ControllerServer controllerServer2 = (ControllerServer)tuple22._2();
        EmbeddedKafkaConfig configWithUsedPorts = EmbeddedKafkaConfig$.MODULE$.apply(this.kafkaPort(brokerServer2), this.controllerPort(controllerServer2), config.customBrokerProperties(), config.customProducerProperties(), config.customConsumerProperties());
        EmbeddedK servers = EmbeddedK$.MODULE$.apply(brokerServer2, controllerServer2, kafkaLogsDir, configWithUsedPorts);
        ((RunningServersOps)((Object)((KafkaOps)((Object)this)))).runningServers().add(servers);
        return servers;
    }

    public static void stopKafka$(RunningKafkaOps $this) {
        $this.stopKafka();
    }

    default public void stopKafka() {
        ((RunningServersOps)((Object)((KafkaOps)((Object)this)))).runningServers().stopAndRemove((Function1<EmbeddedServer, Object>)(Function1 & Serializable)server -> this.isEmbeddedK((EmbeddedServer)server), false);
    }

    public static boolean isEmbeddedK$(RunningKafkaOps $this, EmbeddedServer server) {
        return $this.isEmbeddedK(server);
    }

    default public boolean isEmbeddedK(EmbeddedServer server) {
        return server instanceof EmbeddedK;
    }

    public static int kafkaPort$(RunningKafkaOps $this, BrokerServer kafkaBrokerServer) {
        return $this.kafkaPort(kafkaBrokerServer);
    }

    default public int kafkaPort(BrokerServer kafkaBrokerServer) {
        return kafkaBrokerServer.boundPort(((EndPoint)kafkaBrokerServer.config().listeners().head()).listenerName());
    }

    public static int controllerPort$(RunningKafkaOps $this, ControllerServer controllerServer) {
        return $this.controllerPort(controllerServer);
    }

    default public int controllerPort(ControllerServer controllerServer) {
        return controllerServer.socketServer().boundPort(((EndPoint)controllerServer.config().controllerListeners().head()).listenerName());
    }
}

