/*
 * Decompiled with CFR 0.152.
 */
package io.github.encryptorcode.pluralize;

import io.github.encryptorcode.pluralize.entities.RegexRule;
import io.github.encryptorcode.pluralize.entities.RegexRules;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Pluralize {
    private static final RegexRules PLURAL_RULES = new RegexRules();
    private static final RegexRules SINGULAR_RULES = new RegexRules();
    private static final List<String> UNCOUNTABLES = new ArrayList<String>();
    private static final Map<String, String> IRREGULAR_PLURALS = new HashMap<String, String>();
    private static final Map<String, String> IRREGULAR_SINGLES = new HashMap<String, String>();
    private static final String EMPTY_STRING = "";
    private static final Pattern MARKERS_REGEX = Pattern.compile("\\$(\\d{1,2})");

    private static Pattern sanitizeRule(String word) {
        return Pluralize.p("^" + word + "$");
    }

    private static String restoreCase(String word, String token) {
        if (token.isEmpty()) {
            return token;
        }
        if (word.equals(token)) {
            return token;
        }
        if (word.equals(word.toLowerCase())) {
            return token.toLowerCase();
        }
        if (word.equals(word.toUpperCase())) {
            return token.toUpperCase();
        }
        if ('A' <= word.charAt(0) && word.charAt(0) <= 'Z') {
            return String.valueOf(token.charAt(0)).toUpperCase() + token.substring(1).toLowerCase();
        }
        return token.toLowerCase();
    }

    private static String interpolate(List<String> matches, String replacement) {
        StringBuffer resultantString = new StringBuffer();
        Matcher matcher = MARKERS_REGEX.matcher(replacement);
        while (matcher.find()) {
            String group = matcher.group();
            int index = Integer.parseInt(group.substring(1));
            matcher.appendReplacement(resultantString, matches.get(index));
        }
        matcher.appendTail(resultantString);
        return resultantString.toString();
    }

    private static String replace(String word, Matcher matcher, RegexRule rule) {
        ArrayList<String> matches = new ArrayList<String>();
        for (int i = 0; i <= matcher.groupCount(); ++i) {
            matches.add(matcher.group(i) == null ? EMPTY_STRING : matcher.group(i));
        }
        return Pluralize.replaceFirst(matcher, word, Pluralize.interpolate(matches, rule.getReplacement()));
    }

    private static String replaceFirst(Matcher matcher, String word, String replacement) {
        StringBuffer buffer = new StringBuffer();
        matcher.reset();
        if (matcher.find()) {
            String group = matcher.group();
            if (group.equals(EMPTY_STRING)) {
                matcher.appendReplacement(buffer, Pluralize.restoreCase(String.valueOf(word.charAt(word.length() - 1)), replacement));
            } else {
                matcher.appendReplacement(buffer, Pluralize.restoreCase(group, replacement));
            }
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private static String sanitizeWord(String token, String word, RegexRules rules) {
        if (token.isEmpty() || UNCOUNTABLES.contains(token)) {
            return word;
        }
        int len = rules.size();
        while (len-- > 0) {
            RegexRule rule = (RegexRule)rules.get(len);
            Matcher matcher = rule.getPattern().matcher(word);
            if (!matcher.find()) continue;
            return Pluralize.replace(word, matcher, rule);
        }
        return word;
    }

    private static String replaceWord(String word, Map<String, String> replaceMap, Map<String, String> keepMap, RegexRules rules) {
        String token = word.toLowerCase();
        if (keepMap.containsKey(token)) {
            return Pluralize.restoreCase(word, token);
        }
        if (replaceMap.containsKey(token)) {
            return Pluralize.restoreCase(word, replaceMap.get(token));
        }
        return Pluralize.sanitizeWord(token, word, rules);
    }

    private static boolean checkWord(String word, Map<String, String> replaceMap, Map<String, String> keepMap, RegexRules rules) {
        String token = word.toLowerCase();
        if (keepMap.containsKey(token)) {
            return true;
        }
        if (replaceMap.containsKey(token)) {
            return false;
        }
        return Pluralize.sanitizeWord(token, token, rules).equals(token);
    }

    public static String pluralize(String word) {
        return Pluralize.pluralize(word, null);
    }

    public static String pluralize(String word, Integer count) {
        return Pluralize.pluralize(word, count, false);
    }

    public static String pluralize(String word, Integer count, boolean inclusive) {
        String pluralized = count != null && count == 1 ? Pluralize.singular(word) : Pluralize.plural(word);
        return (inclusive ? count + " " : EMPTY_STRING) + pluralized;
    }

    public static String plural(String word) {
        return Pluralize.replaceWord(word, IRREGULAR_SINGLES, IRREGULAR_PLURALS, PLURAL_RULES);
    }

    public static boolean isPlural(String word) {
        return Pluralize.checkWord(word, IRREGULAR_SINGLES, IRREGULAR_PLURALS, PLURAL_RULES);
    }

    public static String singular(String word) {
        return Pluralize.replaceWord(word, IRREGULAR_PLURALS, IRREGULAR_SINGLES, SINGULAR_RULES);
    }

    public static boolean isSingular(String word) {
        return Pluralize.checkWord(word, IRREGULAR_PLURALS, IRREGULAR_SINGLES, SINGULAR_RULES);
    }

    public static void addPluralRule(String word, String replacement) {
        PLURAL_RULES.add(Pluralize.sanitizeRule(word), replacement);
    }

    public static void addPluralRule(Pattern rule, String replacement) {
        PLURAL_RULES.add(rule, replacement);
    }

    public static void addSingularRule(String word, String replacement) {
        SINGULAR_RULES.add(Pluralize.sanitizeRule(word), replacement);
    }

    public static void addSingularRule(Pattern rule, String replacement) {
        SINGULAR_RULES.add(rule, replacement);
    }

    public static void addUncountableRule(String word) {
        UNCOUNTABLES.add(word.toLowerCase());
    }

    public static void addUncountableRule(Pattern pattern) {
        Pluralize.addSingularRule(pattern, "$0");
        Pluralize.addPluralRule(pattern, "$0");
    }

    public static void addIrregularRule(String single, String plural) {
        single = single.toLowerCase();
        plural = plural.toLowerCase();
        IRREGULAR_SINGLES.put(single, plural);
        IRREGULAR_PLURALS.put(plural, single);
    }

    public static Pattern p(String pattern) {
        return Pattern.compile(pattern, 2);
    }

    static {
        Pluralize.addIrregularRule("I", "we");
        Pluralize.addIrregularRule("me", "us");
        Pluralize.addIrregularRule("he", "they");
        Pluralize.addIrregularRule("she", "they");
        Pluralize.addIrregularRule("them", "them");
        Pluralize.addIrregularRule("myself", "ourselves");
        Pluralize.addIrregularRule("yourself", "yourselves");
        Pluralize.addIrregularRule("itself", "themselves");
        Pluralize.addIrregularRule("herself", "themselves");
        Pluralize.addIrregularRule("himself", "themselves");
        Pluralize.addIrregularRule("themself", "themselves");
        Pluralize.addIrregularRule("is", "are");
        Pluralize.addIrregularRule("was", "were");
        Pluralize.addIrregularRule("has", "have");
        Pluralize.addIrregularRule("this", "these");
        Pluralize.addIrregularRule("that", "those");
        Pluralize.addIrregularRule("echo", "echoes");
        Pluralize.addIrregularRule("dingo", "dingoes");
        Pluralize.addIrregularRule("volcano", "volcanoes");
        Pluralize.addIrregularRule("tornado", "tornadoes");
        Pluralize.addIrregularRule("torpedo", "torpedoes");
        Pluralize.addIrregularRule("genus", "genera");
        Pluralize.addIrregularRule("viscus", "viscera");
        Pluralize.addIrregularRule("stigma", "stigmata");
        Pluralize.addIrregularRule("stoma", "stomata");
        Pluralize.addIrregularRule("dogma", "dogmata");
        Pluralize.addIrregularRule("lemma", "lemmata");
        Pluralize.addIrregularRule("schema", "schemata");
        Pluralize.addIrregularRule("anathema", "anathemata");
        Pluralize.addIrregularRule("ox", "oxen");
        Pluralize.addIrregularRule("axe", "axes");
        Pluralize.addIrregularRule("die", "dice");
        Pluralize.addIrregularRule("yes", "yeses");
        Pluralize.addIrregularRule("foot", "feet");
        Pluralize.addIrregularRule("eave", "eaves");
        Pluralize.addIrregularRule("goose", "geese");
        Pluralize.addIrregularRule("tooth", "teeth");
        Pluralize.addIrregularRule("quiz", "quizzes");
        Pluralize.addIrregularRule("human", "humans");
        Pluralize.addIrregularRule("proof", "proofs");
        Pluralize.addIrregularRule("carve", "carves");
        Pluralize.addIrregularRule("valve", "valves");
        Pluralize.addIrregularRule("looey", "looies");
        Pluralize.addIrregularRule("thief", "thieves");
        Pluralize.addIrregularRule("groove", "grooves");
        Pluralize.addIrregularRule("pickaxe", "pickaxes");
        Pluralize.addIrregularRule("passerby", "passersby");
        Pluralize.addPluralRule(Pluralize.p("s?$"), "s");
        Pluralize.addPluralRule(Pluralize.p("[^\\u0000-\\u007F]$"), "$0");
        Pluralize.addPluralRule(Pluralize.p("([^aeiou]ese)$"), "$1");
        Pluralize.addPluralRule(Pluralize.p("(ax|test)is$"), "$1es");
        Pluralize.addPluralRule(Pluralize.p("(alias|[^aou]us|t[lm]as|gas|ris)$"), "$1es");
        Pluralize.addPluralRule(Pluralize.p("(e[mn]u)s?$"), "$1s");
        Pluralize.addPluralRule(Pluralize.p("([^l]ias|[aeiou]las|[ejzr]as|[iu]am)$"), "$1");
        Pluralize.addPluralRule(Pluralize.p("(alumn|syllab|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$"), "$1i");
        Pluralize.addPluralRule(Pluralize.p("(alumn|alg|vertebr)(?:a|ae)$"), "$1ae");
        Pluralize.addPluralRule(Pluralize.p("(seraph|cherub)(?:im)?$"), "$1im");
        Pluralize.addPluralRule(Pluralize.p("(her|at|gr)o$"), "$1oes");
        Pluralize.addPluralRule(Pluralize.p("(agend|addend|millenni|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|automat|quor)(?:a|um)$"), "$1a");
        Pluralize.addPluralRule(Pluralize.p("(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)(?:a|on)$"), "$1a");
        Pluralize.addPluralRule(Pluralize.p("sis$"), "ses");
        Pluralize.addPluralRule(Pluralize.p("(?:(kni|wi|li)fe|(ar|l|ea|eo|oa|hoo)f)$"), "$1$2ves");
        Pluralize.addPluralRule(Pluralize.p("([^aeiouy]|qu)y$"), "$1ies");
        Pluralize.addPluralRule(Pluralize.p("([^ch][ieo][ln])ey$"), "$1ies");
        Pluralize.addPluralRule(Pluralize.p("(x|ch|ss|sh|zz)$"), "$1es");
        Pluralize.addPluralRule(Pluralize.p("(matr|cod|mur|sil|vert|ind|append)(?:ix|ex)$"), "$1ices");
        Pluralize.addPluralRule(Pluralize.p("\\b((?:tit)?m|l)(?:ice|ouse)$"), "$1ice");
        Pluralize.addPluralRule(Pluralize.p("(pe)(?:rson|ople)$"), "$1ople");
        Pluralize.addPluralRule(Pluralize.p("(child)(?:ren)?$"), "$1ren");
        Pluralize.addPluralRule(Pluralize.p("eaux$"), "$0");
        Pluralize.addPluralRule(Pluralize.p("m[ae]n$"), "men");
        Pluralize.addPluralRule(Pluralize.p("^thou$"), "you");
        Pluralize.addSingularRule(Pluralize.p("s$"), EMPTY_STRING);
        Pluralize.addSingularRule(Pluralize.p("(ss)$"), "$1");
        Pluralize.addSingularRule(Pluralize.p("(wi|kni|(?:after|half|high|low|mid|non|night|[^\\w]|^)li)ves$"), "$1fe");
        Pluralize.addSingularRule(Pluralize.p("(ar|(?:wo|[ae])l|[eo][ao])ves$"), "$1f");
        Pluralize.addSingularRule(Pluralize.p("ies$"), "y");
        Pluralize.addSingularRule(Pluralize.p("(dg|ss|ois|lk|ok|wn|mb|th|ch|ec|oal|is|ck|ix|sser|ts|wb)ies$"), "$1ie");
        Pluralize.addSingularRule(Pluralize.p("\\b(l|(?:neck|cross|hog|aun)?t|coll|faer|food|gen|goon|group|hipp|junk|vegg|(?:pork)?p|charl|calor|cut)ies$"), "$1ie");
        Pluralize.addSingularRule(Pluralize.p("\\b(mon|smil)ies$"), "$1ey");
        Pluralize.addSingularRule(Pluralize.p("\\b((?:tit)?m|l)ice$"), "$1ouse");
        Pluralize.addSingularRule(Pluralize.p("(seraph|cherub)im$"), "$1");
        Pluralize.addSingularRule(Pluralize.p("(x|ch|ss|sh|zz|tto|go|cho|alias|[^aou]us|t[lm]as|gas|(?:her|at|gr)o|[aeiou]ris)(?:es)?$"), "$1");
        Pluralize.addSingularRule(Pluralize.p("(analy|diagno|parenthe|progno|synop|the|empha|cri|ne)(?:sis|ses)$"), "$1sis");
        Pluralize.addSingularRule(Pluralize.p("(movie|twelve|abuse|e[mn]u)s$"), "$1");
        Pluralize.addSingularRule(Pluralize.p("(test)(?:is|es)$"), "$1is");
        Pluralize.addSingularRule(Pluralize.p("(alumn|syllab|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$"), "$1us");
        Pluralize.addSingularRule(Pluralize.p("(agend|addend|millenni|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|quor)a$"), "$1um");
        Pluralize.addSingularRule(Pluralize.p("(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)a$"), "$1on");
        Pluralize.addSingularRule(Pluralize.p("(alumn|alg|vertebr)ae$"), "$1a");
        Pluralize.addSingularRule(Pluralize.p("(cod|mur|sil|vert|ind)ices$"), "$1ex");
        Pluralize.addSingularRule(Pluralize.p("(matr|append)ices$"), "$1ix");
        Pluralize.addSingularRule(Pluralize.p("(pe)(rson|ople)$"), "$1rson");
        Pluralize.addSingularRule(Pluralize.p("(child)ren$"), "$1");
        Pluralize.addSingularRule(Pluralize.p("(eau)x?$"), "$1");
        Pluralize.addSingularRule(Pluralize.p("men$"), "man");
        Pluralize.addUncountableRule("adulthood");
        Pluralize.addUncountableRule("advice");
        Pluralize.addUncountableRule("agenda");
        Pluralize.addUncountableRule("aid");
        Pluralize.addUncountableRule("aircraft");
        Pluralize.addUncountableRule("alcohol");
        Pluralize.addUncountableRule("ammo");
        Pluralize.addUncountableRule("analytics");
        Pluralize.addUncountableRule("anime");
        Pluralize.addUncountableRule("athletics");
        Pluralize.addUncountableRule("audio");
        Pluralize.addUncountableRule("bison");
        Pluralize.addUncountableRule("blood");
        Pluralize.addUncountableRule("bream");
        Pluralize.addUncountableRule("buffalo");
        Pluralize.addUncountableRule("butter");
        Pluralize.addUncountableRule("carp");
        Pluralize.addUncountableRule("cash");
        Pluralize.addUncountableRule("chassis");
        Pluralize.addUncountableRule("chess");
        Pluralize.addUncountableRule("clothing");
        Pluralize.addUncountableRule("cod");
        Pluralize.addUncountableRule("commerce");
        Pluralize.addUncountableRule("cooperation");
        Pluralize.addUncountableRule("corps");
        Pluralize.addUncountableRule("debris");
        Pluralize.addUncountableRule("diabetes");
        Pluralize.addUncountableRule("digestion");
        Pluralize.addUncountableRule("elk");
        Pluralize.addUncountableRule("energy");
        Pluralize.addUncountableRule("equipment");
        Pluralize.addUncountableRule("excretion");
        Pluralize.addUncountableRule("expertise");
        Pluralize.addUncountableRule("firmware");
        Pluralize.addUncountableRule("flounder");
        Pluralize.addUncountableRule("fun");
        Pluralize.addUncountableRule("gallows");
        Pluralize.addUncountableRule("garbage");
        Pluralize.addUncountableRule("graffiti");
        Pluralize.addUncountableRule("hardware");
        Pluralize.addUncountableRule("headquarters");
        Pluralize.addUncountableRule("health");
        Pluralize.addUncountableRule("herpes");
        Pluralize.addUncountableRule("highjinks");
        Pluralize.addUncountableRule("homework");
        Pluralize.addUncountableRule("housework");
        Pluralize.addUncountableRule("information");
        Pluralize.addUncountableRule("jeans");
        Pluralize.addUncountableRule("justice");
        Pluralize.addUncountableRule("kudos");
        Pluralize.addUncountableRule("labour");
        Pluralize.addUncountableRule("literature");
        Pluralize.addUncountableRule("machinery");
        Pluralize.addUncountableRule("mackerel");
        Pluralize.addUncountableRule("mail");
        Pluralize.addUncountableRule("media");
        Pluralize.addUncountableRule("mews");
        Pluralize.addUncountableRule("moose");
        Pluralize.addUncountableRule("music");
        Pluralize.addUncountableRule("mud");
        Pluralize.addUncountableRule("manga");
        Pluralize.addUncountableRule("news");
        Pluralize.addUncountableRule("only");
        Pluralize.addUncountableRule("personnel");
        Pluralize.addUncountableRule("pike");
        Pluralize.addUncountableRule("plankton");
        Pluralize.addUncountableRule("pliers");
        Pluralize.addUncountableRule("police");
        Pluralize.addUncountableRule("pollution");
        Pluralize.addUncountableRule("premises");
        Pluralize.addUncountableRule("rain");
        Pluralize.addUncountableRule("research");
        Pluralize.addUncountableRule("rice");
        Pluralize.addUncountableRule("salmon");
        Pluralize.addUncountableRule("scissors");
        Pluralize.addUncountableRule("series");
        Pluralize.addUncountableRule("sewage");
        Pluralize.addUncountableRule("shambles");
        Pluralize.addUncountableRule("shrimp");
        Pluralize.addUncountableRule("software");
        Pluralize.addUncountableRule("staff");
        Pluralize.addUncountableRule("swine");
        Pluralize.addUncountableRule("tennis");
        Pluralize.addUncountableRule("traffic");
        Pluralize.addUncountableRule("transportation");
        Pluralize.addUncountableRule("trout");
        Pluralize.addUncountableRule("tuna");
        Pluralize.addUncountableRule("wealth");
        Pluralize.addUncountableRule("welfare");
        Pluralize.addUncountableRule("whiting");
        Pluralize.addUncountableRule("wildebeest");
        Pluralize.addUncountableRule("wildlife");
        Pluralize.addUncountableRule("you");
        Pluralize.addUncountableRule(Pluralize.p("pok[e\u00e9]mon$"));
        Pluralize.addUncountableRule(Pluralize.p("[^aeiou]ese$"));
        Pluralize.addUncountableRule(Pluralize.p("deer$"));
        Pluralize.addUncountableRule(Pluralize.p("fish$"));
        Pluralize.addUncountableRule(Pluralize.p("measles$"));
        Pluralize.addUncountableRule(Pluralize.p("o[iu]s$"));
        Pluralize.addUncountableRule(Pluralize.p("pox$"));
        Pluralize.addUncountableRule(Pluralize.p("sheep$"));
    }
}

