/*
 * Decompiled with CFR 0.152.
 */
package io.github.evaggelos99.r2dbc.h2;

import io.github.evaggelos99.r2dbc.h2.H2DatabaseExceptionFactory;
import io.github.evaggelos99.r2dbc.h2.H2Type;
import io.github.evaggelos99.r2dbc.h2.codecs.Codecs;
import io.github.evaggelos99.r2dbc.h2.util.Assert;
import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Nullability;
import java.util.Objects;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.value.TypeInfo;

public final class H2ColumnMetadata
implements ColumnMetadata {
    private final Codecs codecs;
    private final String name;
    private final H2Type type;
    private final Nullability nullability;
    private final Long precision;
    private final Integer scale;

    H2ColumnMetadata(Codecs codecs, String name, TypeInfo typeInfo, Nullability nullability, Long precision, Integer scale) {
        this.codecs = Assert.requireNonNull(codecs, "codecs must not be null");
        this.name = Assert.requireNonNull(name, "name must not be null");
        this.nullability = Assert.requireNonNull(nullability, "nullability must not be null");
        this.precision = Assert.requireNonNull(precision, "precision must not be null");
        this.scale = Assert.requireNonNull(scale, "scale must not be null");
        this.type = new H2Type(Assert.requireNonNull(typeInfo, "typeInfo must not be null"), codecs.preferredType(typeInfo.getValueType()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof H2ColumnMetadata)) {
            return false;
        }
        H2ColumnMetadata that = (H2ColumnMetadata)o;
        return Objects.equals(this.codecs, that.codecs) && this.name.equals(that.name) && this.type.equals(that.type) && this.nullability == that.nullability && this.precision.equals(that.precision) && this.scale.equals(that.scale);
    }

    public Class<?> getJavaType() {
        return this.type.getJavaType();
    }

    public String getName() {
        return this.name;
    }

    public Object getNativeTypeMetadata() {
        return this.type.getTypeInfo().getValueType();
    }

    public Nullability getNullability() {
        return this.nullability;
    }

    public Integer getPrecision() {
        return this.precision.intValue();
    }

    public Integer getScale() {
        return this.scale;
    }

    public H2Type getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.codecs, this.name, this.type, this.nullability, this.precision, this.scale);
    }

    public String toString() {
        return "H2ColumnMetadata{codecs=" + this.codecs + ", name='" + this.name + '\'' + ", type=" + this.type + ", nullability=" + this.nullability + ", precision=" + this.precision + ", scale=" + this.scale + '}';
    }

    static H2ColumnMetadata toColumnMetadata(Codecs codecs, ResultInterface result, int index) {
        Assert.requireNonNull(codecs, "codecs must not be null");
        Assert.requireNonNull(result, "result must not be null");
        try {
            TypeInfo typeInfo = result.getColumnType(index);
            String alias = result.getAlias(index);
            return new H2ColumnMetadata(codecs, alias, typeInfo, H2ColumnMetadata.toNullability(result.getNullable(index)), typeInfo.getPrecision(), typeInfo.getScale());
        }
        catch (DbException e) {
            throw H2DatabaseExceptionFactory.convert(e);
        }
    }

    private static Nullability toNullability(int n) {
        switch (n) {
            case 0: {
                return Nullability.NON_NULL;
            }
            case 1: {
                return Nullability.NULLABLE;
            }
        }
        return Nullability.UNKNOWN;
    }
}

