/*
 * Decompiled with CFR 0.152.
 */
package io.github.evaggelos99.r2dbc.h2;

import io.github.evaggelos99.r2dbc.h2.H2ConnectionOption;
import io.github.evaggelos99.r2dbc.h2.util.Assert;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public final class H2ConnectionConfiguration {
    private final CharSequence password;
    private final String url;
    private final String username;
    private final Map<String, String> properties;

    private H2ConnectionConfiguration(@Nullable CharSequence password, String url, @Nullable String username, Map<String, String> properties) {
        this.password = password;
        this.url = Assert.requireNonNull(url, "url must not be null");
        this.username = username;
        this.properties = Assert.requireNonNull(properties, "properties must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "H2ConnectionConfiguration{password='REDACTED', properties='" + this.properties + '\'' + ", url='" + this.url + '\'' + ", username='" + this.username + '\'' + '}';
    }

    Optional<CharSequence> getPassword() {
        return Optional.ofNullable(this.password);
    }

    String getUrl() {
        return this.url;
    }

    Map<String, String> getProperties() {
        return this.properties;
    }

    Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public static final class Builder {
        private List<String> options = new ArrayList<String>();
        private Map<String, String> properties = new LinkedHashMap<String, String>();
        private CharSequence password;
        private String url;
        private String username;

        public H2ConnectionConfiguration build() {
            if (this.options.isEmpty()) {
                return new H2ConnectionConfiguration(this.password, this.url, this.username, this.properties);
            }
            String urlWithOptions = this.options.stream().reduce(this.url, (url, option) -> {
                url = url + ";" + option;
                return url;
            });
            return new H2ConnectionConfiguration(this.password, urlWithOptions, this.username, this.properties);
        }

        public Builder file(String path) {
            return this.url(String.format("file:%s", path));
        }

        public Builder inMemory(String name) {
            return this.url(String.format("mem:%s", name));
        }

        public Builder tcp(String host, String path) {
            return this.url(String.format("tcp://%s/%s", host, path));
        }

        public Builder tcp(String host, int port, String path) {
            return this.url(String.format("tcp://%s:%s/%s", host, port, path));
        }

        public Builder option(String option) {
            this.options.add(option);
            return this;
        }

        public Builder property(String option, String value) {
            this.properties.put(Assert.requireNonNull(option, "option must not be null"), Assert.requireNonNull(value, "value must not be null"));
            return this;
        }

        public Builder property(H2ConnectionOption option, String value) {
            Assert.requireNonNull(option, "option must not be null");
            return this.property(option.getKey(), value);
        }

        public Builder password(@Nullable CharSequence password) {
            this.password = password;
            return this;
        }

        public String toString() {
            return "Builder{password='REDACTED', properties='" + this.properties + '\'' + ", url='" + this.url + '\'' + ", username='" + this.username + '\'' + '}';
        }

        public Builder url(String url) {
            this.url = Assert.requireNonNull(url, "url must not be null");
            return this;
        }

        public Builder username(@Nullable String username) {
            this.username = username;
            return this;
        }
    }
}

