/*
 * Decompiled with CFR 0.152.
 */
package io.github.evaggelos99.r2dbc.h2;

import io.github.evaggelos99.r2dbc.h2.H2ConnectionConfiguration;
import io.github.evaggelos99.r2dbc.h2.H2ConnectionFactory;
import io.github.evaggelos99.r2dbc.h2.H2ConnectionOption;
import io.github.evaggelos99.r2dbc.h2.util.Assert;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import io.r2dbc.spi.Option;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public final class H2ConnectionFactoryProvider
implements ConnectionFactoryProvider {
    public static final String H2_DRIVER = "h2";
    public static final Option<String> OPTIONS = Option.valueOf((String)"options");
    public static final String PROTOCOL_FILE = "file";
    public static final String PROTOCOL_MEM = "mem";
    public static final Option<String> URL = Option.valueOf((String)"url");
    private static final Set<String> KNOWN_OPTION_KEYS = Collections.unmodifiableSet(Arrays.stream(H2ConnectionOption.values()).map(H2ConnectionOption::getKey).collect(Collectors.toSet()));

    public H2ConnectionFactory create(ConnectionFactoryOptions connectionFactoryOptions) {
        CharSequence password;
        String options;
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        H2ConnectionConfiguration.Builder builder = H2ConnectionConfiguration.builder();
        String protocol = (String)connectionFactoryOptions.getValue(ConnectionFactoryOptions.PROTOCOL);
        if (PROTOCOL_FILE.equals(protocol)) {
            builder.file((String)connectionFactoryOptions.getRequiredValue(ConnectionFactoryOptions.DATABASE));
        } else if (PROTOCOL_MEM.equals(protocol)) {
            builder.inMemory((String)connectionFactoryOptions.getRequiredValue(ConnectionFactoryOptions.DATABASE));
        } else if (protocol != null) {
            throw new IllegalArgumentException(String.format("protocol option %s is unsupported (%s, %s)", protocol, PROTOCOL_FILE, PROTOCOL_MEM));
        }
        String url = (String)connectionFactoryOptions.getValue(URL);
        if (url != null) {
            builder.url(url);
        }
        if ((options = (String)connectionFactoryOptions.getValue(OPTIONS)) != null) {
            for (String option : options.split(";")) {
                builder.option(option);
            }
        }
        if ((password = (CharSequence)connectionFactoryOptions.getValue(ConnectionFactoryOptions.PASSWORD)) != null) {
            builder.password(password.toString());
        }
        builder.username((String)connectionFactoryOptions.getValue(ConnectionFactoryOptions.USER));
        for (String knownOptionKey : KNOWN_OPTION_KEYS) {
            Option uc = Option.valueOf((String)knownOptionKey);
            if (connectionFactoryOptions.hasOption(uc)) {
                builder.property(uc.name(), (String)connectionFactoryOptions.getRequiredValue(uc));
                continue;
            }
            Option lc = Option.valueOf((String)knownOptionKey.toLowerCase(Locale.ENGLISH));
            if (!connectionFactoryOptions.hasOption(lc)) continue;
            builder.property(lc.name(), (String)connectionFactoryOptions.getRequiredValue(lc));
        }
        return new H2ConnectionFactory(builder.build());
    }

    public boolean supports(ConnectionFactoryOptions connectionFactoryOptions) {
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        String driver = (String)connectionFactoryOptions.getValue(ConnectionFactoryOptions.DRIVER);
        if (driver == null || !driver.equals(H2_DRIVER)) {
            return false;
        }
        if (connectionFactoryOptions.hasOption(URL)) {
            return true;
        }
        return connectionFactoryOptions.hasOption(ConnectionFactoryOptions.PROTOCOL) && connectionFactoryOptions.hasOption(ConnectionFactoryOptions.DATABASE);
    }

    public String getDriver() {
        return H2_DRIVER;
    }
}

