/*
 * Decompiled with CFR 0.152.
 */
package io.github.evaggelos99.r2dbc.h2;

import io.r2dbc.spi.R2dbcBadGrammarException;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import io.r2dbc.spi.R2dbcRollbackException;
import io.r2dbc.spi.R2dbcTimeoutException;
import io.r2dbc.spi.R2dbcTransientException;
import io.r2dbc.spi.R2dbcTransientResourceException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLTransientException;
import org.h2.message.DbException;

public final class H2DatabaseExceptionFactory {
    public static R2dbcException convert(DbException dbException) {
        SQLException e = DbException.toSQLException((Throwable)dbException);
        if (SQLDataException.class.isAssignableFrom(e.getClass())) {
            return new H2R2dbcDataException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e);
        }
        if (SQLFeatureNotSupportedException.class.isAssignableFrom(e.getClass())) {
            return new H2R2dbcNonTransientException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e);
        }
        if (SQLIntegrityConstraintViolationException.class.isAssignableFrom(e.getClass())) {
            return new R2dbcDataIntegrityViolationException(e.getMessage(), e.getSQLState(), e.getErrorCode(), (Throwable)e);
        }
        if (SQLInvalidAuthorizationSpecException.class.isAssignableFrom(e.getClass())) {
            return new R2dbcPermissionDeniedException(e.getMessage(), e.getSQLState(), e.getErrorCode(), (Throwable)e);
        }
        if (SQLNonTransientConnectionException.class.isAssignableFrom(e.getClass())) {
            return new R2dbcNonTransientResourceException(e.getMessage(), e.getSQLState(), e.getErrorCode(), (Throwable)e);
        }
        if (SQLRecoverableException.class.isAssignableFrom(e.getClass())) {
            return new H2R2dbcNonTransientException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e);
        }
        if (SQLSyntaxErrorException.class.isAssignableFrom(e.getClass())) {
            return new R2dbcBadGrammarException(e.getMessage(), e.getSQLState(), e.getErrorCode(), (Throwable)e);
        }
        if (SQLTimeoutException.class.isAssignableFrom(e.getClass())) {
            return new R2dbcTimeoutException(e.getMessage(), e.getSQLState(), e.getErrorCode(), (Throwable)e);
        }
        if (SQLTransactionRollbackException.class.isAssignableFrom(e.getClass())) {
            return new R2dbcRollbackException(e.getMessage(), e.getSQLState(), e.getErrorCode(), (Throwable)e);
        }
        if (SQLTransientConnectionException.class.isAssignableFrom(e.getClass())) {
            return new R2dbcTransientResourceException(e.getMessage(), e.getSQLState(), e.getErrorCode(), (Throwable)e);
        }
        if (SQLTransientException.class.isAssignableFrom(e.getClass())) {
            return new H2R2dbcTransientException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e);
        }
        if (SQLNonTransientException.class.isAssignableFrom(e.getClass())) {
            return new H2R2dbcNonTransientException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e);
        }
        if (SQLException.class.isAssignableFrom(e.getClass())) {
            return new H2R2dbcException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e);
        }
        return new H2R2dbcException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e);
    }

    static class H2R2dbcDataException
    extends R2dbcException {
        private static final long serialVersionUID = 1L;

        H2R2dbcDataException(String message, String sqlState, int errorCode, SQLException e) {
            super(message, sqlState, errorCode, (Throwable)e);
        }
    }

    static class H2R2dbcNonTransientException
    extends R2dbcNonTransientException {
        private static final long serialVersionUID = 1L;

        H2R2dbcNonTransientException(String message, String sqlState, int errorCode, SQLException e) {
            super(message, sqlState, errorCode, (Throwable)e);
        }
    }

    static class H2R2dbcTransientException
    extends R2dbcTransientException {
        private static final long serialVersionUID = 1L;

        H2R2dbcTransientException(String message, String sqlState, int errorCode, SQLException e) {
            super(message, sqlState, errorCode, (Throwable)e);
        }
    }

    static class H2R2dbcException
    extends R2dbcException {
        private static final long serialVersionUID = 1L;

        H2R2dbcException(String message, String sqlState, int errorCode, SQLException e) {
            super(message, sqlState, errorCode, (Throwable)e);
        }
    }

    static class H2R2dbcNonTransientResourceException
    extends R2dbcNonTransientResourceException {
        private static final long serialVersionUID = 1L;

        public H2R2dbcNonTransientResourceException(String reason) {
            super(reason);
        }
    }
}

