/*
 * Decompiled with CFR 0.152.
 */
package io.github.evaggelos99.r2dbc.h2.codecs;

import io.github.evaggelos99.r2dbc.h2.codecs.Codec;
import io.github.evaggelos99.r2dbc.h2.util.Assert;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import reactor.util.annotation.Nullable;

abstract class AbstractCodec<T>
implements Codec<T> {
    private final Class<T> type;

    AbstractCodec(Class<T> type) {
        this.type = Assert.requireNonNull(type, "type must not be null");
    }

    @Override
    public boolean canDecode(int dataType, Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        return type.isAssignableFrom(this.type) && this.doCanDecode(dataType);
    }

    @Override
    public boolean canEncode(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.type.isInstance(value);
    }

    @Override
    public boolean canEncodeNull(Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        return this.type.isAssignableFrom(type);
    }

    @Override
    @Nullable
    public T decode(Value value, Class<? extends T> type) {
        if (value == null || value == ValueNull.INSTANCE) {
            return null;
        }
        return this.doDecode(value, type);
    }

    @Override
    public Value encode(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.doEncode(value);
    }

    @Override
    public Value encodeNull() {
        return ValueNull.INSTANCE;
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    abstract boolean doCanDecode(int var1);

    abstract T doDecode(Value var1, Class<? extends T> var2);

    abstract Value doEncode(T var1);
}

