/*
 * Decompiled with CFR 0.152.
 */
package io.github.evaggelos99.r2dbc.h2.codecs;

import io.github.evaggelos99.r2dbc.h2.client.Client;
import io.github.evaggelos99.r2dbc.h2.codecs.AbstractCodec;
import io.github.evaggelos99.r2dbc.h2.codecs.ValueLobClob;
import io.github.evaggelos99.r2dbc.h2.util.Assert;
import io.r2dbc.spi.Clob;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Iterator;
import org.h2.value.Value;
import org.h2.value.ValueClob;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

final class ClobCodec
extends AbstractCodec<Clob> {
    private final Client client;

    ClobCodec(Client client) {
        super(Clob.class);
        this.client = client;
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType == 3;
    }

    @Override
    Clob doDecode(Value value, Class<? extends Clob> type) {
        if (value == null || value instanceof ValueNull) {
            return null;
        }
        return new ValueLobClob(value);
    }

    @Override
    Value doEncode(Clob value) {
        Assert.requireNonNull(value, "value must not be null");
        ValueClob clob = this.client.getSession().getDataHandler().getLobStorage().createClob((Reader)new AggregateCharArrayReader(value), -1L);
        this.client.getSession().addTemporaryLob((ValueLob)clob);
        return clob;
    }

    private final class AggregateCharArrayReader
    extends Reader {
        private final Iterator<CharArrayReader> readers;
        private CharArrayReader current;

        private AggregateCharArrayReader(Clob value) {
            this.readers = Flux.from((Publisher)value.stream()).map(CharBuffer::wrap).map(charBuffer -> {
                if (charBuffer.hasArray()) {
                    return charBuffer.array();
                }
                return charBuffer.toString().toCharArray();
            }).map(CharArrayReader::new).toIterable().iterator();
            if (this.readers.hasNext()) {
                this.current = this.readers.next();
            }
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int results = this.current.read(cbuf, off, len);
            if (results == -1 && this.readers.hasNext()) {
                this.current = this.readers.next();
                return this.read(cbuf, off, len);
            }
            return results;
        }

        @Override
        public void close() {
            this.current.close();
        }
    }
}

