/*
 * Decompiled with CFR 0.152.
 */
package io.github.evaggelos99.r2dbc.h2.codecs;

import io.github.evaggelos99.r2dbc.h2.client.Client;
import io.github.evaggelos99.r2dbc.h2.codecs.AbstractCodec;
import io.github.evaggelos99.r2dbc.h2.util.Assert;
import java.io.Reader;
import java.io.StringReader;
import org.h2.value.Value;
import org.h2.value.ValueClob;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;

final class ClobToStringCodec
extends AbstractCodec<String> {
    private final Client client;

    ClobToStringCodec(Client client) {
        super(String.class);
        this.client = client;
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType == 3;
    }

    @Override
    String doDecode(Value value, Class<? extends String> type) {
        if (value == null || value instanceof ValueNull) {
            return null;
        }
        return value.getString();
    }

    @Override
    Value doEncode(String value) {
        Assert.requireNonNull(value, "value must not be null");
        ValueClob clob = this.client.getSession().getDataHandler().getLobStorage().createClob((Reader)new StringReader(value), (long)value.length());
        this.client.getSession().addTemporaryLob((ValueLob)clob);
        return clob;
    }
}

