/*
 * Decompiled with CFR 0.152.
 */
package io.github.evaggelos99.r2dbc.h2.codecs;

import io.github.evaggelos99.r2dbc.h2.client.Client;
import io.github.evaggelos99.r2dbc.h2.codecs.AbstractCodec;
import org.h2.engine.CastDataProvider;
import org.h2.value.ExtTypeInfoEnum;
import org.h2.value.Value;

public final class EnumCodec
extends AbstractCodec<Enum> {
    private final Client client;

    EnumCodec(Client client) {
        super(Enum.class);
        this.client = client;
    }

    @Override
    boolean doCanDecode(int dataType) {
        return 36 == dataType;
    }

    @Override
    Enum doDecode(Value value, Class<? extends Enum> type) {
        return Enum.valueOf(type, value.getString());
    }

    @Override
    Value doEncode(Enum value) {
        E[] enumConstants = value.getDeclaringClass().getEnumConstants();
        int length = enumConstants.length;
        String[] enumStrings = new String[length];
        for (int i = 0; i < length; ++i) {
            Enum en = (Enum)enumConstants[i];
            enumStrings[i] = en.name();
        }
        return new ExtTypeInfoEnum(enumStrings).getValue(value.name(), (CastDataProvider)this.client.getSession());
    }
}

