/*
 * Decompiled with CFR 0.152.
 */
package io.github.evaggelos99.r2dbc.h2.codecs;

import io.github.evaggelos99.r2dbc.h2.codecs.AbstractCodec;
import io.github.evaggelos99.r2dbc.h2.util.Assert;
import org.h2.value.Value;
import org.h2.value.ValueBigint;

final class LongCodec
extends AbstractCodec<Long> {
    LongCodec() {
        super(Long.class);
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType == 12;
    }

    @Override
    Long doDecode(Value value, Class<? extends Long> type) {
        return value.getLong();
    }

    @Override
    Value doEncode(Long value) {
        return ValueBigint.get((long)Assert.requireNonNull(value, "value must not be null"));
    }
}

