/*
 * Decompiled with CFR 0.152.
 */
package io.github.evaggelos99.r2dbc.h2.codecs;

import io.github.evaggelos99.r2dbc.h2.codecs.AbstractCodec;
import io.github.evaggelos99.r2dbc.h2.util.Assert;
import java.time.Period;
import org.h2.util.JSR310Utils;
import org.h2.value.Value;

final class PeriodCodec
extends AbstractCodec<Period> {
    PeriodCodec() {
        super(Period.class);
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType == 22 || dataType == 23 || dataType == 28;
    }

    @Override
    Period doDecode(Value value, Class<? extends Period> type) {
        return JSR310Utils.valueToPeriod((Value)value);
    }

    @Override
    Value doEncode(Period value) {
        Assert.requireNonNull(value, "value must not be null");
        return JSR310Utils.periodToValue((Period)value);
    }
}

