/*
 * Decompiled with CFR 0.152.
 */
package io.github.evaggelos99.r2dbc.h2.codecs;

import io.github.evaggelos99.r2dbc.h2.client.Client;
import io.github.evaggelos99.r2dbc.h2.codecs.AbstractCodec;
import io.github.evaggelos99.r2dbc.h2.util.Assert;
import java.time.ZonedDateTime;
import org.h2.engine.CastDataProvider;
import org.h2.util.JSR310Utils;
import org.h2.value.Value;

final class ZonedDateTimeCodec
extends AbstractCodec<ZonedDateTime> {
    private final Client client;

    ZonedDateTimeCodec(Client client) {
        super(ZonedDateTime.class);
        this.client = client;
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType == 21;
    }

    @Override
    ZonedDateTime doDecode(Value value, Class<? extends ZonedDateTime> type) {
        Assert.requireType(this.client.getSession(), CastDataProvider.class, "The session must implement CastDataProvider.");
        return JSR310Utils.valueToZonedDateTime((Value)value, (CastDataProvider)this.client.getSession());
    }

    @Override
    Value doEncode(ZonedDateTime value) {
        return JSR310Utils.zonedDateTimeToValue((ZonedDateTime)Assert.requireNonNull(value, "value must not be null"));
    }
}

