package com.ezviz.opensdk.data;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.videogo.exception.EZOpenSDKErrorInfo;
import com.videogo.util.LogUtil;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * TODO description
 *
 * @author dingwei3
 * @date 2018/1/29
 */

public class EZDatabaseManager {

    private EZDatabaseManager() {
    }



    private static EZDatabaseManager mDatabaseManager;
    private static EZDatabaseHelper mDatabaseHelper;
    private SQLiteDatabase mDatabase;


    public static EZDatabaseManager getInstance() {
        return mDatabaseManager;
    }

    public  synchronized void insertData(EZOpenSDKErrorInfo ezOpenSDKErrorInfo){
        if (ezOpenSDKErrorInfo == null || TextUtils.isEmpty(ezOpenSDKErrorInfo.detailCode)){
            return;
        }
        try {
            //得到一个可写的数据库
            SQLiteDatabase db = getWritableDatabase();
            //生成ContentValues对象 //key:列名，value:想插入的值
            ContentValues cv = new ContentValues();
            //往ContentValues对象存放数据，键-值对模式
            cv.put(DBTable.TABLE_ERROR_CODE.COLUMN_module_code, ezOpenSDKErrorInfo.moduleCode);
            cv.put(DBTable.TABLE_ERROR_CODE.COLUMN_detail_code, ezOpenSDKErrorInfo.detailCode);
            cv.put(DBTable.TABLE_ERROR_CODE.COLUMN_description, ezOpenSDKErrorInfo.description);
            cv.put(DBTable.TABLE_ERROR_CODE.COLUMN_solution, ezOpenSDKErrorInfo.solution);
            cv.put(DBTable.TABLE_ERROR_CODE.COLUMN_update_time,ezOpenSDKErrorInfo.updateTime);
            //调用insert方法，将数据插入数据库
            db.insert(DBTable.TABLE_ERROR_CODE.TABLE_ERROR_CODE_NAME, null, cv);
        } catch (Exception e) {
            LogUtil.e("EZDatabaseManager", "getErrorTableVersion: " + e.getMessage(), e);
        } finally {
            //关闭数据库
            closeDatabase(null);
        }
    }


    public synchronized void deleteData(EZOpenSDKErrorInfo ezOpenSDKErrorInfo){
        if (ezOpenSDKErrorInfo == null || TextUtils.isEmpty(ezOpenSDKErrorInfo.detailCode)){
            return;
        }
        try {
            //得到一个可写的数据库
            SQLiteDatabase db = getWritableDatabase();
            //调用insert方法，将数据插入数据库
            db.delete(DBTable.TABLE_ERROR_CODE.TABLE_ERROR_CODE_NAME, DBTable.TABLE_ERROR_CODE.COLUMN_detail_code+"=?", new String[]{ezOpenSDKErrorInfo.detailCode});
        } catch (Exception e) {
            LogUtil.e("EZDatabaseManager", "getErrorTableVersion: " + e.getMessage(), e);
        } finally {
            //关闭数据库
            closeDatabase(null);
        }
    }

    public synchronized ArrayList<EZOpenSDKErrorInfo>   searchAllData(){
        ArrayList<EZOpenSDKErrorInfo> errorInfos = new ArrayList<EZOpenSDKErrorInfo>();
        Cursor cursor = null;
        try {
            //得到一个可写的数据库
            SQLiteDatabase db = getWritableDatabase();
            //调用insert方法，将数据插入数据库
            cursor = db.query(true,DBTable.TABLE_ERROR_CODE.TABLE_ERROR_CODE_NAME, null,null,null,null,null,null,null,null);
            while (cursor != null && cursor.moveToNext()){
                EZOpenSDKErrorInfo errorInfo = new EZOpenSDKErrorInfo();
                errorInfo.moduleCode =  cursor.getString(cursor.getColumnIndex(DBTable.TABLE_ERROR_CODE.COLUMN_module_code));
                errorInfo.detailCode =  cursor.getString(cursor.getColumnIndex(DBTable.TABLE_ERROR_CODE.COLUMN_detail_code));
                errorInfo.description = cursor.getString(cursor.getColumnIndex(DBTable.TABLE_ERROR_CODE.COLUMN_description));
                errorInfo.solution = cursor.getString(cursor.getColumnIndex(DBTable.TABLE_ERROR_CODE.COLUMN_solution));
                errorInfo.updateTime = cursor.getLong(cursor.getColumnIndex(DBTable.TABLE_ERROR_CODE.COLUMN_update_time));
                errorInfos.add(errorInfo);
            }
        }  catch (Exception e) {
            LogUtil.e("EZDatabaseManager", "getErrorTableVersion: " + e.getMessage(), e);
        } finally {
            //关闭数据库
            closeDatabase(cursor);
        }
        return errorInfos;
    }

    public synchronized EZOpenSDKErrorInfo searchData(String detailCode){
        if (TextUtils.isEmpty(detailCode)){
            return null;
        }
        EZOpenSDKErrorInfo errorInfo = null;
        Cursor cursor = null;
        try {
            //得到一个可写的数据库
            SQLiteDatabase db = getReadableDatabase();
            //调用insert方法，将数据插入数据库
            cursor = db.query(true,DBTable.TABLE_ERROR_CODE.TABLE_ERROR_CODE_NAME, null,DBTable.TABLE_ERROR_CODE.COLUMN_detail_code+"=?",new String[]{detailCode},null,null,null,null,null);
            if (cursor != null && cursor.moveToNext()){
                errorInfo = new EZOpenSDKErrorInfo();
                errorInfo.moduleCode =  cursor.getString(cursor.getColumnIndex(DBTable.TABLE_ERROR_CODE.COLUMN_module_code));
                errorInfo.detailCode =  cursor.getString(cursor.getColumnIndex(DBTable.TABLE_ERROR_CODE.COLUMN_detail_code));
                errorInfo.description = cursor.getString(cursor.getColumnIndex(DBTable.TABLE_ERROR_CODE.COLUMN_description));
                errorInfo.solution = cursor.getString(cursor.getColumnIndex(DBTable.TABLE_ERROR_CODE.COLUMN_solution));
                errorInfo.updateTime = cursor.getLong(cursor.getColumnIndex(DBTable.TABLE_ERROR_CODE.COLUMN_update_time));
            }
        } catch (Exception e) {
            LogUtil.e("EZDatabaseManager", "searchData: " + e.getMessage(), e);
        } finally {
            //关闭数据库
            closeDatabase(cursor);
        }
        return errorInfo;
    }

    public synchronized void  updateData(EZOpenSDKErrorInfo ezOpenSDKErrorInfo){
        if (ezOpenSDKErrorInfo == null || TextUtils.isEmpty(ezOpenSDKErrorInfo.detailCode)){
            return;
        }
        //生成ContentValues对象 //key:列名，value:想插入的值
        ContentValues cv = new ContentValues();
        //往ContentValues对象存放数据，键-值对模式
        cv.put(DBTable.TABLE_ERROR_CODE.COLUMN_module_code, ezOpenSDKErrorInfo.moduleCode);
        cv.put(DBTable.TABLE_ERROR_CODE.COLUMN_detail_code, ezOpenSDKErrorInfo.detailCode);
        cv.put(DBTable.TABLE_ERROR_CODE.COLUMN_description, ezOpenSDKErrorInfo.description);
        cv.put(DBTable.TABLE_ERROR_CODE.COLUMN_solution, ezOpenSDKErrorInfo.solution);
        cv.put(DBTable.TABLE_ERROR_CODE.COLUMN_update_time,ezOpenSDKErrorInfo.updateTime);
        Cursor cursor = null;
        try {
            //得到一个可写的数据库
            SQLiteDatabase db = getWritableDatabase();
            //调用insert方法，将数据插入数据库
            cursor = db.query(true,DBTable.TABLE_ERROR_CODE.TABLE_ERROR_CODE_NAME, null,DBTable.TABLE_ERROR_CODE.COLUMN_detail_code+"=?",new String[]{ezOpenSDKErrorInfo.detailCode},null,null,null,null,null);
            if (cursor != null && cursor.moveToNext()){
                db.update(DBTable.TABLE_ERROR_CODE.TABLE_ERROR_CODE_NAME,cv,DBTable.TABLE_ERROR_CODE.COLUMN_detail_code+"=?",new String[]{ezOpenSDKErrorInfo.detailCode});
            }else{
                db.insert(DBTable.TABLE_ERROR_CODE.TABLE_ERROR_CODE_NAME, null, cv);
            }
        } catch (Exception e) {
            LogUtil.e("EZDatabaseManager", "updateData: " + e.getMessage(), e);
        } finally {
            //关闭数据库
            closeDatabase(cursor);
        }
    }

    public synchronized String  getErrorTableVersion() {
        //得到一个可写的数据库
        String errorTableVersion = null;
        Cursor cursor = null;
        try {
            SQLiteDatabase db = getReadableDatabase();
            //调用insert方法，将数据插入数据库
            cursor = db.query(true,DBTable.TABLE_OPEN_VERSON.TABLE_OPEN_VERSON_NAME, null,DBTable.TABLE_OPEN_VERSON.COLUMN_name+"=?",new String[]{DBTable.TABLE_OPEN_VERSON.error_code_version},null,null,null,null,null);
            if (cursor != null && cursor.moveToNext()){
                errorTableVersion = cursor.getString(cursor.getColumnIndex(DBTable.TABLE_OPEN_VERSON.COLUMN_version));
            }
        } catch (Exception e) {
            LogUtil.e("EZDatabaseManager", "getErrorTableVersion: " + e.getMessage(), e);
        } finally {
            //关闭数据库
            closeDatabase(cursor);
        }
        return errorTableVersion;
    }


    public synchronized void  setErrorTableVersion(String time) {
        try {
            //得到一个可写的数据库
            SQLiteDatabase db = getWritableDatabase();
            ContentValues contentValues = new ContentValues();
            contentValues.put(DBTable.TABLE_OPEN_VERSON.COLUMN_name,DBTable.TABLE_OPEN_VERSON.error_code_version);
            contentValues.put(DBTable.TABLE_OPEN_VERSON.COLUMN_version,String.valueOf(time));
            db.update(DBTable.TABLE_OPEN_VERSON.TABLE_OPEN_VERSON_NAME,contentValues,DBTable.TABLE_OPEN_VERSON.COLUMN_name+"=?",new String[]{DBTable.TABLE_OPEN_VERSON.error_code_version});
        }  catch (Exception e) {
            LogUtil.e("EZDatabaseManager", "getErrorTableVersion: " + e.getMessage(), e);
        } finally {
            //关闭数据库
            closeDatabase(null);
        }
    }


    private AtomicInteger mOpenCounter = new AtomicInteger();


    public static synchronized void initializeInstance(EZDatabaseHelper helper) {
        if (mDatabaseManager == null) {
            mDatabaseManager = new EZDatabaseManager();
            mDatabaseHelper = helper;
        }
    }
    public static synchronized EZDatabaseManager getInstance(EZDatabaseHelper helper) {
        if (mDatabaseManager == null) {
            initializeInstance(helper);    }
        return mDatabaseManager;
    }
    public synchronized SQLiteDatabase getWritableDatabase() {
        if(mOpenCounter.incrementAndGet() == 1) {
             mDatabase = mDatabaseHelper.getWritableDatabase();
        }
        return mDatabase;
    }
    public synchronized SQLiteDatabase getReadableDatabase() {
        if(mOpenCounter.incrementAndGet() == 1) {
            mDatabase = mDatabaseHelper.getReadableDatabase();
        }
        return mDatabase;
    }
    private synchronized void closeDatabase(Cursor cursor) {
        try {
            if (cursor != null){
                cursor.close();
            }
        } catch (Exception e) {
            LogUtil.e("EZDatabaseManager", "closeDatabase cursor:" + e.getMessage(), e);
        }
        try {
            if(mOpenCounter.decrementAndGet() == 0) {
                mDatabase.close();
            }
        }catch (Exception e) {
            LogUtil.e("EZDatabaseManager", "closeDatabase mDatabase:" + e.getMessage(), e);
        }
    }
}
