/**
 * Copyright (C), 2022, 萤石软件有限公司
 * FileName: ErrorOpenSDKProxy
 * Author: lihaitao10
 * Date: 2022/9/16 16:42
 * Description: OpenSDK层的代理实现
 * History:
 * <author> <time> <version> <desc>
 * 作者姓名 修改时间 版本号 描述
 */
package com.videogo.errorlayer;

import android.text.TextUtils;

import com.videogo.exception.EZOpenSDKErrorInfo;
import com.videogo.exception.EZOpenSDKErrorMamager;

public class ErrorOpenSDKProxy extends ErrorProxy{

    private static ErrorOpenSDKProxy proxy;

    public static ErrorOpenSDKProxy getInstance(){
        if (proxy == null){
            proxy = new ErrorOpenSDKProxy();
        }
        return proxy;
    }

    @Override
    ErrorInfo getErrorLayer(int operationType, int errorCode) {
        ErrorLayer errorLayer = null;
        switch (operationType) {
            case ErrorDefine.OPERATION_NO_REPORT:
                errorLayer = new WebErrorLayer();
                break;
            case ErrorDefine.OPERATION_WEB:
                errorLayer = new WebErrorLayer();
                break;
            case ErrorDefine.OPERATION_INNER:
                errorLayer = new InnerErrorLayer();
                break;
            case ErrorDefine.OPERATION_STREAM_CAS:
                errorLayer = new StreamCASErrorLayer();
                break;
            case ErrorDefine.OPERATION_STREAM_STREAMCLIENT:
                errorLayer = new StreamClientErrorLayer();
                break;
            case ErrorDefine.OPERATION_STREAM_RTSP:
                errorLayer = new StreamRtspErrorLayer();
                break;
            case ErrorDefine.OPERATION_STREAM_TTS:
                errorLayer = new StreamTtsErrorLayer();
                break;
            case ErrorDefine.OPERATION_STREAM_NEW_TTS:
                errorLayer = new StreamNewTtsErrorLayer();
                break;
            case ErrorDefine.OPERATION_STREAM_STREAMSDK:
                errorLayer = new StreamSdkErrorLayer();
                break;
            case ErrorDefine.OPERATION_STREAM_NPC:
                errorLayer = new NPCClientErrorLayer();
                break;
            default:
                break;
        }

        if (errorLayer == null) {
            return null;
        }

        ErrorInfo errorInfo = errorLayer.getErrorInfo(errorCode);
        errorLayer.checkTransf(errorInfo);
        EZOpenSDKErrorInfo errorInfo1 = EZOpenSDKErrorMamager.getMamager().getEZOpenSDKErrorInfo(String.valueOf(errorInfo.errorCode),operationType != ErrorDefine.OPERATION_NO_REPORT);
        if (errorInfo1 != null && TextUtils.isEmpty(errorInfo1.description)){
            errorInfo.description = errorInfo1.description;
            errorInfo.moduleCode = errorInfo1.moduleCode;
            errorInfo.sulution = errorInfo1.solution;
        }
        return errorInfo;
    }
}
