package com.videogo.errorlayer;

import com.videogo.exception.ErrorCode;

/**
 * Created by yudan on 16/5/9.
 */
public class InnerErrorLayer extends ErrorLayer {

    // 获取完整的错误码信息
    public ErrorInfo getErrorInfo(int errorCode) {
        ErrorInfo errorInfo = new ErrorInfo();

        // 内部错误码都是在开放平台sdk中内部定义的，定义时已经增加了错误基数，无需再增加了
        errorInfo.errorCode = errorCode;
        errorInfo.description = getDescription(errorInfo.errorCode);

        return errorInfo;
    }

    // 根据错误码获取错误描述
    public String getDescription(int errorCode) {
        String description = "";
        switch (errorCode) {
            case ErrorCode.ERROR_INNER_NO_ERROR:
                description = "no error";
                break;
            case ErrorCode.ERROR_INNER_PARAM_NULL:
                description = "参数为空，可以查看logcat日志定位到具体参数";
                break;
            case ErrorCode.ERROR_INNER_TALKBACK_UNSUPPORT:
                description = "设备不支持对讲";
                break;
            case ErrorCode.ERROR_INNER_USER_STOP:
                description = "用户主动停止";
                break;
            case ErrorCode.ERROR_INNER_SDK_NOINITORRELEASED:
                description = "没有初始化或资源被释放";
                break;
            case ErrorCode.ERROR_INNER_WEBRESPONSE_JSONERROR:
                description = "JSON解析异常，可以查看日志中的异常打印信息定位问题";
                break;
            case ErrorCode.ERROR_INNER_NETWORK_EXCEPTION:
                description = "网络异常，请求出现错误";
                break;
            case ErrorCode.ERROR_INNER_DEVICE_NULLINFO:
                description = "设备信息异常为空，刷新下设备信息或重新打开app试试";
                break;
            case ErrorCode.ERROR_INNER_UNKNOWERROR:
                description = "未知错误，真的收到了这种错误，带上日志找我们程序员GG吧";
                break;
            case ErrorCode.ERROR_INNER_PLAYSDK_ERROR:
                description = "PlayerSDK出错，真的收到了这种问题，带上日志找我们程序员GG吧";
                break;
            case ErrorCode.ERROR_INNER_PARAM_ERROR:
                description = "参数错误";
                break;
            case ErrorCode.ERROR_INNER_OUTOFMEMORY:
                description = "内存溢出";
                break;
            case ErrorCode.ERROR_INNER_VERIFYCODE_NEED:
                description = "视频已加密，需要输入密码，初始密码为设备标签上的6位验证码。开发者可以考虑在获取到验证码后重新播放。";
                break;
            case ErrorCode.ERROR_INNER_VERIFYCODE_ERROR:
                description = "视频密码错误，初始密码为设备标签上的6位验证码。开发者可以考虑在获取到验证码后重新播放。";
                break;
            case ErrorCode.ERROR_INNER_SURFACE_ERROR:
                description = "surfacehold错误，请检查是否是播放之前销毁了surface，收到此错误也可以重新建立surface后播放";
                break;

            case ErrorCode.ERROR_TRANSF_DEVICE_OFFLINE:
                description = "设备不在线";
                break;
            case ErrorCode.ERROR_TRANSF_ACCESSTOKEN_ERROR:
                description = "AccessToken异常，可能是过期或校验失败，请在重新获取accessToken后重试之前操作";
                break;
            case ErrorCode.ERROR_TRANSF_TERMINAL_BINDING:
                description = "当前账号开启了终端绑定，只允许指定设备登录操作，请登录i.ys7.com上解除终端绑定";
                break;
            case ErrorCode.ERROR_TRANSF_DEVICE_TALKING:
                description = "设备正在对讲中。停止对讲后设备需要短暂的时间释放资源，停止对讲后立刻重新开启对讲也有可能报此错误";
                break;
            case ErrorCode.ERROR_TRANSF_DEVICE_PRIVACYON:
                description = "设备开启了隐私保护，不允许预览、对讲等";

            case ErrorCode.ERROR_EXTRA_USER_NAME_IS_NULL:
                description = "用户名为空";
                break;
            case ErrorCode.ERROR_EXTRA_USER_NAME_TOO_SHORT:
                description = "用户名长度小于最小限制";
                break;
            case ErrorCode.ERROR_EXTRA_USER_NAME_ALL_UNDER_LINE:
                description = "用户名全为下划线";
                break;
            case ErrorCode.ERROR_EXTRA_USER_NAME_TOO_LOOG:
                description = "用户名长度超出最长限制";
                break;
            case ErrorCode.ERROR_EXTRA_USER_NAME_IS_ILLEGAL:
                description = "用户名不合法";
                break;
            case ErrorCode.ERROR_EXTRA_USER_NAME_ALL_DIGIT:
                description = "用户名全为数字";
                break;
            case ErrorCode.ERROR_EXTRA_PASSWORD_IS_NULL:
                description = "密码为空";
                break;
            case ErrorCode.ERROR_EXTRA_PASSWORD_TOO_SHORT:
                description = "密码长度小于最小限制";
                break;
            case ErrorCode.ERROR_EXTRA_PASSWORD_TOO_LONG:
                description = "密码长度超出最长限制";
                break;
            case ErrorCode.ERROR_EXTRA_PASSWORD_SAME_CHARACTER:
                description = "密码为相同字符";
                break;
            case ErrorCode.ERROR_EXTRA_PASSWORD_IS_ILLEGAL:
                description = "密码不合法";
                break;
            case ErrorCode.ERROR_EXTRA_NEW_PASSWORD_IS_NULL:
                description = "新密码为空";
                break;
            case ErrorCode.ERROR_EXTRA_NEW_PASSWORD_TOO_SHORT:
                description = "新密码长度小于最小限制";
                break;
            case ErrorCode.ERROR_EXTRA_NEW_PASSWORD_TOO_LONG:
                description = "新密码长度超出最长限制";
                break;
            case ErrorCode.ERROR_EXTRA_NEW_PASSWORD_SAME_CHARACTER:
                description = "新密码不能为相同字符";
                break;
            case ErrorCode.ERROR_EXTRA_NEW_PASSWORD_IS_ILLEGAL:
                description = "新密码不合法";
                break;
            case ErrorCode.ERROR_EXTRA_COMFIRM_PASSWORD_IS_NULL:
                description = "确认密码为空";
                break;
            case ErrorCode.ERROR_EXTRA_PASSWORDS_NOT_EQUALS:
                description = "两次密码不一致";
                break;
            case ErrorCode.ERROR_EXTRA_PHONE_NUMBER_IS_NULL:
                description = "电话号码为空";
                break;
            case ErrorCode.ERROR_EXTRA_PHONE_NUMBER_IS_ILLEGAL:
                description = "电话号码不合法";
                break;
            case ErrorCode.ERROR_EXTRA_MOBILE_PHONE_NUMBER_IS_NULL:
                description = "手机号码为空";
                break;
            case ErrorCode.ERROR_EXTRA_MOBILE_PHONE_NUMBER_IS_ILLEGAL:
                description = "手机号码不合法";
                break;
            case ErrorCode.ERROR_EXTRA_VERIFY_CODE_IS_NULL:
                description = "验证码为空";
                break;
            case ErrorCode.ERROR_EXTRA_CAMERA_NAME_IS_NULL:
                description = "监控点名称为空";
                break;
            case ErrorCode.ERROR_EXTRA_CAMERA_NAME_IS_ILLEGAL:
                description = "监控点名字不合法";
                break;
            case ErrorCode.ERROR_EXTRA_SERIALNO_IS_NULL:
                description = "序列号为空";
                break;
            case ErrorCode.ERROR_EXTRA_CAMERA_IS_NULL:
                description = "监控点不存在";
                break;
            case ErrorCode.ERROR_EXTRA_DEVICE_SN_IS_NULL:
                description = "设备序列号为空";
                break;
            case ErrorCode.ERROR_EXTRA_CAMERA_PASSWORD_IS_NULL:
                description = "监控点密码为空";
                break;
            case ErrorCode.ERROR_EXTRA_SERIALNO_IS_ILLEGAL:
                description = "序列号不合法";
                break;
            case ErrorCode.ERROR_EXTRA_MOBILE_EMAIL_IS_ILLEGAL:
                description = "邮箱不合法";
                break;
            case ErrorCode.ERROR_EXTRA_MOBILE_EMAIL_IS_NULL:
                description = "邮箱为空";
                break;
            case ErrorCode.ERROR_EXTRA_DEVICE_IS_NULL:
                description = "设备信息为空";
                break;
            case ErrorCode.ERROR_EXTRA_SQUARE_NO_SHARING:
                description = "审核没通过或不在分享时间内";
                break;
            default:
                description = "Inner error";
        }

        return description;
    }
}
