package com.videogo.errorlayer;

import com.videogo.exception.ErrorCode;

/**
 * Created by dingwei3 on 17/12/19.
 * NPC错误信息
 */
public class NPCClientErrorLayer extends ErrorLayer {

    // 获取完整的错误码信息
    public ErrorInfo getErrorInfo(int errorCode) {
        ErrorInfo errorInfo = new ErrorInfo();
        if (errorCode < 0) {
            errorInfo.errorCode = ErrorDefine.NPC_CLIENT_ERROR_BASE + 10000 + errorCode;

        } else {
            errorInfo.errorCode = ErrorDefine.NPC_CLIENT_ERROR_BASE + errorCode;
        }

        errorInfo.description = getDescription(errorInfo.errorCode);
        return errorInfo;
    }
    public String getDescription(int errorCode) {
        String description = "";
        switch (errorCode) {
            case ErrorCode.ERROR_NPC_CLIENT_NO_ERROR:
                description = "no error";
                break;
            case ErrorCode.ERROR_NPC_CLIENT_PARAMETER_ERROR:
                description = "参数错误";
                break;
            case ErrorCode.ERROR_NPC_CLIENT_ORDER_ERROR:
                description = "调用顺序出错";
                break;
            case ErrorCode.ERROR_NPC_CLIENT_MEMORY_ERROR:
                description = "分配内存失败";
                break;
            case ErrorCode.ERROR_NPC_CLIENT_BUFFER_OVERFLOW_ERROR:
                description = "缓冲区溢出";
                break;
            case ErrorCode.ERROR_NPC_CLIENT_SYSTEM_NO_SUPPORT_ERROR:
                description = "系统不支持";
                break;
            case ErrorCode.ERROR_NPC_CLIENT_INVALID_PORT_ERROR:
                description = "无效端口";
                break;
            case ErrorCode.ERROR_NPC_CLIENT_STREAM_CLOSE_ERROR:
                description = "流关闭";
                break;
            case ErrorCode.ERROR_NPC_CLIENT_TRACK_CLOSE_ERROR:
                description = "TRACK_CLOSE";
                break;
            case ErrorCode.ERROR_NPC_CLIENT_NPCCREATE_ERROR:
                description = "创建失败";
                break;
            case ErrorCode.ERROR_NPC_CLIENT_TRSCREATE_ERROR:
                description = "TRSCREATE_ERROR";
                break;
            case ErrorCode.ERROR_NPC_CLIENT_FAIL_UNKNOWN_ERROR:
                description = "FAIL_UNKNOWN";
                break;
            default:
                description = "npcclient未知错误";
        }

        return description;
    }

}
