package com.videogo.errorlayer;

import com.videogo.exception.ErrorCode;

/**
 * Created by yudan on 16/5/5.
 */
public class StreamCASErrorLayer extends ErrorLayer {

    @Override
    // 获取完整的错误码信息
    public ErrorInfo getErrorInfo(int errorCode) {
        ErrorInfo errorInfo = new ErrorInfo();
        if (errorCode < 0) {
            errorInfo.errorCode = ErrorDefine.CAS_ERROR_BASE + 10000 + errorCode;

        } else {
            errorInfo.errorCode = ErrorDefine.CAS_ERROR_BASE + errorCode;
        }

        errorInfo.description = getDescription(errorInfo.errorCode);

        return errorInfo;
    }

    @Override
    // 根据错误码获取错误描述
    public String getDescription(int errorCode) {
        String description = "";
        switch (errorCode) {
            case ErrorCode.ERROR_CAS_MSG_NO_ERROR:
                description = "no error";
                break;
            case ErrorCode.ERROR_CAS_MSG_UNKNOW_ERROR:
                description = "未知错误";
                break;
            case ErrorCode.ERROR_CAS_MSG_PARAMS_ERROR:
                description = "报文参数错误";
                break;
            case ErrorCode.ERROR_CAS_MSG_PARSE_FAILED:
                description = "报文解析错误，一般都是设备重新上下线后，设备操作码发生了变化导致的";
                break;
            case ErrorCode.ERROR_CAS_MSG_COMMAND_UNKNOW:
                description = "非法命令，若sdk不是最新，请更新sdk";
                break;
            case ErrorCode.ERROR_CAS_MSG_COMMAND_NO_LONGER_SUPPORTED:
                description = "过时命令，若sdk不是最新，请更新sdk";
                break;
            case ErrorCode.ERROR_CAS_MSG_COMMAND_NOT_SUITABLE:
                description = "错误命令，若sdk不是最新，请更新sdk";
                break;
            case ErrorCode.ERROR_CAS_MSG_CHECKSUM_ERROR:
                description = "校验码错误";
                break;
            case ErrorCode.ERROR_CAS_MSG_VERSION_UNKNOW:
                description = "协议版本错误，请升级设备版本和sdk版本最新";
                break;
            case ErrorCode.ERROR_CAS_MSG_VERSION_NO_LONGER_SUPPORTED:
                description = "协议版本过低，请升级设备版本和sdk版本最新";
                break;
            case ErrorCode.ERROR_CAS_MSG_VERSION_FORBIDDEN:
                description = "协议版本已被禁用，请升级设备版本和sdk版本最新";
                break;
            case ErrorCode.ERROR_CAS_MSG_SERIAL_NOT_FOR_CIVIL:
                description = "序列号解析出错，请检查网络是否不稳定";
                break;
            case ErrorCode.ERROR_CAS_MSG_SERIAL_FORBIDDEN:
                description = "序列号被禁止，请检查网络是否不稳定";
                break;
            case ErrorCode.ERROR_CAS_MSG_SERIAL_DUPLICATE:
                description = "序列号重复，请检查网络是否不稳定";
                break;
            case ErrorCode.ERROR_CAS_MSG_SERIAL_FLUSHED_IN_A_SECOND:
                description = "相同序列号短时间内大量重复请求，请检查网络是否不稳定";
                break;
            case ErrorCode.ERROR_CAS_MSG_SERIAL_NO_LONGER_SUPPORTED:
                description = "序列号不再支持，请检查网络是否不稳定";
                break;
            case ErrorCode.ERROR_CAS_MSG_LOCAL_SERVER_BUSY:
                description = "本地无法响应";
                break;
            case ErrorCode.ERROR_CAS_MSG_LOCAL_SERVER_REFUSED:
                description = "本地主动拒绝";
                break;
            case ErrorCode.ERROR_CAS_REG_CANNOT_AFFORD_PU:
                description = "无法接受请求";
                break;
            case ErrorCode.ERROR_CAS_REG_CRYPTO_UNMATCHED:
                description = "设备加密算法不匹配";
                break;
            case ErrorCode.ERROR_CAS_MSG_DEV_TYPE_INVAILED:
                description = "设备类型错误";
                break;
            case ErrorCode.ERROR_CAS_MSG_DEV_TYPE_NO_LONGGER_SUPPORTED:
                description = "设备类型不再支持";
                break;
            case ErrorCode.ERROR_CAS_MSG_PU_BUSY:
                description = "设备无法响应，可能需要断掉部分预览或回放已释放设备的连接数";
                break;
            case ErrorCode.ERROR_CAS_MSG_OPERATION_FAILED:
                description = "操作码错误，重新获取操作码即可";
                break;
            case ErrorCode.ERROR_CAS_PU_NO_CRYPTO_FOUND:
                description = "设备或平台未找到对应的加密算法";
                break;
            case ErrorCode.ERROR_CAS_MSG_PU_REFUSED:
                description = "拒绝操作";
                break;
            case ErrorCode.ERROR_CAS_MSG_PU_NO_RESOURCE:
                description = "设备端没有可用资源";
                break;
            case ErrorCode.ERROR_CAS_MSG_PU_CHANNEL_ERROR:
                description = "通道错误";
                break;
            case ErrorCode.ERROR_CAS_SYSTEM_COMMAND_PU_COMMAND_UNSUPPORTED:
                description = "不支持的命令，设备不支持此操作或需要升级";
                break;
            case ErrorCode.ERROR_CAS_SYSTEM_COMMAND_PU_NO_RIGHTS_TO_DO_COMMAND:
                description = "没有权限";
                break;
            case ErrorCode.ERROR_CAS_MSG_NO_SESSION_FOUND:
                description = "没有找到会话";
                break;
            case ErrorCode.ERROR_CAS_PREVIEW_CHANNEL_BUSY:
                description = "该通道已在发流";
                break;
            case ErrorCode.ERROR_CAS_PREVIEW_CLIENT_BUSY:
                description = "取流地址重复";
                break;
            case ErrorCode.ERROR_CAS_PREVIEW_STREAM_UNSUPPORTED:
                description = "不支持的码流类型";
                break;
            case ErrorCode.ERROR_CAS_PREVIEW_TRANSPORT_UNSUPPORTED:
                description = "不支持的传输方式";
                break;
            case ErrorCode.ERROR_CAS_PREVIEW_CONNECT_SERVER_FAIL:
                description = "连接预览流媒体服务器失败，请重试";
                break;
            case ErrorCode.ERROR_CAS_PREVIEW_QUERY_WLAN_INFO_FAIL:
                description = "查询设备公网出口地址失败，请检查网络环境后重试，或者更换路由尝试";
                break;
            case ErrorCode.ERROR_CAS_PREVIEW_UNKNOW_ERROR:
                description = "渠道nvr出错，错误未知";
                break;
            case ErrorCode.ERROR_CAS_RECORD_SEARCH_START_TIME_ERROR:
                description = "查询录像的开始时间错误";
                break;
            case ErrorCode.ERROR_CAS_RECORD_SEARCH_STOP_TIME_ERROR:
                description = "查询录像的结束时间错误";
                break;
            case ErrorCode.ERROR_CAS_RECORD_SEARCH_FAIL:
                description = "查询录像失败";
                break;
            case ErrorCode.ERROR_CAS_PLAYBACK_TYPE_UNSUPPORTED:
                description = "不支持的回放类型";
                break;
            case ErrorCode.ERROR_CAS_PLAYBACK_NO_FILE_MATCHED:
                description = "没有找到文件";
                break;
            case ErrorCode.ERROR_CAS_PLAYBACK_START_TIME_ERROR:
                description = "回放的开始时间错误";
                break;
            case ErrorCode.ERROR_CAS_PLAYBACK_STOP_TIME_ERROR:
                description = "回放的结束时间错误";
                break;
            case ErrorCode.ERROR_CAS_PLAYBACK_NO_FILE_FOUND:
                description = "该时间段内没有录像";
                break;
            case ErrorCode.ERROR_CAS_PLAYBACK_CONNECT_SERVER_FAIL:
                description = "连接回放服务器失败，请稍后再试";
                break;
            case ErrorCode.ERROR_CAS_TALK_ENCODE_TYPE_UNSUPPORTED:
                description = "不支持的语音编码类型";
                break;
            case ErrorCode.ERROR_CAS_TALK_CHANNEL_BUSY:
                description = "该通道已在对讲，停止对讲后设备需要短暂的时间释放资源";
                break;
            case ErrorCode.ERROR_CAS_TALK_CLIENT_BUSY:
                description = "和目的地址已有链接";
                break;
            case ErrorCode.ERROR_CAS_TALK_UNSUPPORTED:
                description = "不支持对讲";
                break;
            case ErrorCode.ERROR_CAS_TALK_CHANNO_ERROR:
                description = "对讲通道号错误";
                break;
            case ErrorCode.ERROR_CAS_TALK_CONNECT_SERVER_FAILED:
                description = "连接对讲服务器失败，请稍后再试";
                break;
            case ErrorCode.ERROR_CAS_TALK_CONNECT_REFUSED:
                description = "设备端拒绝连接，重启下设备再试";
                break;
            case ErrorCode.ERROR_CAS_TALK_CONNECT_CAPACITY_LIMITED:
                description = "设备资源受限";
                break;
            case ErrorCode.ERROR_CAS_FORMAT_NO_LOCAL_STORAGE:
                description = "没有本地存储";
                break;
            case ErrorCode.ERROR_CAS_FORMAT_FORMATING:
                description = "正在格式化";
                break;
            case ErrorCode.ERROR_CAS_FORMAT_FAILED:
                description = "格式化失败";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_REQUEST_REFUSED:
                description = "服务器拒绝设备升级请求";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_REQUEST_VERSION_NOT_FOUND:
                description = "没有找到请求的版本";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_REQUEST_UNNEEDED:
                description = "不需要升级";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_REQUEST_NO_SERVER_ONLINE:
                description = "升级服务器不在线";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_REQUEST_ALL_SERVER_BUSY:
                description = "升级服务器达到最大负载，请稍后再试";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_UPGRADING:
                description = "正在升级";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_UPGRAD_FAILED:
                description = "升级失败";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_UPGRAD_WRITE_FLASH_FAILED:
                description = "升级写Flash失败";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_UPGRAD_LANGUAGE_DISMATCH:
                description = "升级语言不匹配";
                break;
            case ErrorCode.ERROR_CAS_PU_PASSWORD_UPDATE_NO_USER_MATHCED:
                description = "密码更新失败，没有对应用户";
                break;
            case ErrorCode.ERROR_CAS_PU_PASSWORD_UPDATE_ORIGINAL_PASSWORD_ERROR:
                description = "原始密码错误";
                break;
            case ErrorCode.ERROR_CAS_PU_PASSWORD_UPDATE_NEW_PASSWORD_DECRYPTE_FAILED:
                description = "密码更新失败，新密码解密失败";
                break;
            case ErrorCode.ERROR_CAS_PU_PASSWORD_UPDATE_NEW_PASSWORD_CHECK_FAILED:
                description = "新密码不符合规则";
                break;
            case ErrorCode.ERROR_CAS_PU_PASSWORD_UPDATE_WRITE_FLASH_FAILED:
                description = "更新密码失败，写Flash失败";
                break;
            case ErrorCode.ERROR_CAS_PU_PASSWORD_UPDATE_OTHER_FALIURE:
                description = "更新密码失败，其他原因";
                break;
            case ErrorCode.ERROR_CAS_PU_PASSWORD_VERIFY_PASSWORD_FAILED:
                description = "验证密码失败";
                break;
            case ErrorCode.ERROR_CAS_PLATFORM_CLIENT_REQUEST_NO_PU_FOUNDED:
                description = "设备不在线";
                break;
            case ErrorCode.ERROR_CAS_PLATFORM_CLIENT_REQUEST_REFUSED_TO_PROTECT_PU:
                description = "为了保护设备，拒绝请求";
                break;
            case ErrorCode.ERROR_CAS_PLATFORM_CLIENT_REQUEST_PU_LIMIT_REACHED:
                description = "设备的连接数达到上限";
                break;
            case ErrorCode.ERROR_CAS_PLATFORM_CLIENT_TEARDOWN_PU_CONNECTION:
                description = "要求客户端断开与设备连接";
                break;
            case ErrorCode.ERROR_CAS_PU_REFUSE_CLIENT_CONNECTION:
                description = "设备拒绝平台发送的客户端连接请求";
                break;
            case ErrorCode.ERROR_CAS_PLATFORM_CLIENT_VERIFY_AUTH_ERROR:
                description = "服务器向验证中心验证用户权限失败";
                break;
            case ErrorCode.ERROR_CAS_PLATFORM_CLIENT_REQUEST_PU_OPEN_PRIVACY:
                description = "设备开启了隐私保护";
                break;
            case ErrorCode.ERROR_CAS_PLATFORM_CLIENT_NO_SIGN_RELEATED:
                description = "账户开启了终端绑定，未绑定的手机无法登录，请通过i.ys7.com关闭终端绑定";
                break;
            case ErrorCode.ERROR_CAS_DEFENCE_TYPE_UNSUPPORTED:
                description = "不支持的布撤防类型，部分摄像机设备不支持在家/外出/睡眠模式的切换";
                break;
            case ErrorCode.ERROR_CAS_DEFENCE_TYPE_FAILED:
                description = "布撤防失败";
                break;
            case ErrorCode.ERROR_CAS_DEFENCE_TYPE_FORCE_FAILED:
                description = "强制布撤防失败";
                break;
            case ErrorCode.ERROR_CAS_DEFENCE_TYPE_NEED_FORCE:
                description = "需要强制布撤防，收到此错误码后，可以调用强制布撤防接口";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_NOT_FOUND:
                description = "未找到云存储服务器";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_NO_USER:
                description = "没有开通云存储";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_FILE_TAIL_REACHED:
                description = "文件已到结尾";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_INVALID_SESSION:
                description = "无效的session";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_INVALID_HANDLE:
                description = "无效的文件，可能是该文件在云存储服务器上已过存储期限";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_UNKNOWN_CLOUD:
                description = "未知的云存储类型";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_UNSUPPORT_FILETYPE:
                description = "不支持的文件类型";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_INVALID_FILE:
                description = "无效的文件";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_QUOTA_IS_FULL:
                description = "配额已满";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_FILE_IS_FULL:
                description = "文件已满";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_UPGRAD_PLATFORM_DISMATCH:
                description = "软件升级平台不匹配";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_UPGRAD_SPACE_DISMATCH:
                description = "软件升级空间不匹配";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_UPGRAD_MEM_DISMATCH:
                description = "软件升级内存不匹配";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_UPGRAD_MAJORTYPE_DISMATCH:
                description = "软件升级主类型不匹配";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_UPGRAD_MINORTYPE_DISMATCH:
                description = "软件升级次类型不匹配";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_UPGRAD_FILE_NUMS_INVALID:
                description = "文件个数值无效";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_UPGRAD_PACK_LEN_INVALID:
                description = "升级包长度值无效";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_UPGRAD_CHECKSUM_ERR:
                description = "软件升级校验和错误";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_UPGRADE_FRONT_FAIL:
                description = "升级前端数据摄像机失败";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_NO_RESOURCE:
                description = "没有资源";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_OPER_NOPERMIT:
                description = "没有权限";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_REBOOTING:
                description = "正在重启";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_NO_MEMORY:
                description = "没有内存";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_PARAM_ERR:
                description = "参数错误";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_HEAD_DATA_ERR:
                description = "升级包头部数据错误";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_DOWNLOAD_FAILED:
                description = "下载失败";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_DOWNLOAD_PATH_ERR:
                description = "路径或文件名错";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_DOWNLOAD_PARAM_ERR:
                description = "下载参数错误";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_DOWNLOAD_FTP_ESTCMD_ERR:
                description = "ftp建立命令出错";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_DOWNLOAD_FTP_CMD_FAILED:
                description = "ftp执行命令失败";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_DOWNLOAD_FTP_CONNINIT_FAILED:
                description = "ftp连接初始化失败";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_DOWNLOAD_FTP_TRANS_ABORT:
                description = "ftp异常中断";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_DOWNLOAD_FTP_SELECT_ERR:
                description = "ftp select出错";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_DOWNLOAD_FTP_GET_DATA_SOCK_ERR:
                description = "ftp获取数据套接字出错";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_DOWNLOAD_FTP_RECV_ERR:
                description = "ftp接收数据出错";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_DOWNLOAD_FTP_BUFF_ERR:
                description = "ftp缓冲区出错";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_DOWNLOAD_FILE_CHECK_ERR:
                description = "下载文件校验失败";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_DOWNLOAD_FTP_CONN_ERR:
                description = "ftp连接出错";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_DOWNLOAD_FTP_LOGIN_FAILED:
                description = "ftp 登陆失败";
                break;
            case ErrorCode.ERROR_CAS_UPGRADE_PU_DOWNLOAD_FTP_GET_FILEINFO_FAILED:
                description = "获取文件信息失败";
                break;
            case ErrorCode.ERROR_CAS_CAPTURE_PIC_LOCAL_FAILED:
                description = "设备本地抓图失败";
                break;
            case ErrorCode.ERROR_CAS_CAPTURE_PIC_APPLY_CACHE_FAILED:
                description = "图片缓存申请失败";
                break;
            case ErrorCode.ERROR_CAS_CAPTURE_PIC_PARSE_PMS_DOMAIN_FAILED:
                description = "PMS域名解析错误";
                break;
            case ErrorCode.ERROR_CAS_CAPTURE_PIC_CONNECT_PMS_FAILED:
                description = "PMS连接失败";
                break;
            case ErrorCode.ERROR_CAS_CAPTURE_PIC_CREATE_PMS_PACKET_FAILED:
                description = "创建PMS报文错误";
                break;
            case ErrorCode.ERROR_CAS_CAPTURE_PIC_SEND_PMS_FAILED:
                description = "PMS发送数据错误";
                break;
            case ErrorCode.ERROR_CAS_CAPTURE_PIC_RECV_PMS_FAILED:
                description = "PMS接收数据错误";
                break;
            case ErrorCode.ERROR_CAS_CAPTURE_PIC_PARSE_PMS_RESPONSE_FAILED:
                description = "PMS应答报文解析错误";
                break;
            case ErrorCode.ERROR_CAS_CAPTURE_PIC_GET_URL_FAILED:
                description = "获取URL失败";
                break;
            case ErrorCode.ERROR_CAS_BASE:
                description = "客户端错误号";
                break;
            case ErrorCode.ERROR_CAS_PARAMETER:
                description = "参数错误";
                break;
            case ErrorCode.ERROR_CAS_ALLOC_RESOURCE:
                description = "分配资源失败";
                break;
            case ErrorCode.ERROR_CAS_SEND_FAILED:
                description = "发送错误";
                break;
            case ErrorCode.ERROR_CAS_RECV_FAILED:
                description = "接收错误, 对方断开连接所致";
                break;
            case ErrorCode.ERROR_CAS_PARSE_XML:
                description = "解析报文错误";
                break;
            case ErrorCode.ERROR_CAS_CREATE_XML:
                description = "生成报文错误";
                break;
            case ErrorCode.ERROR_CAS_INIT_SOCKET:
                description = "初始化Socket失败";
                break;
            case ErrorCode.ERROR_CAS_CREATE_SOCKET:
                description = "创建socket失败";
                break;
            case ErrorCode.ERROR_CAS_CONNECT_FAILED:
                description = "连接服务器失败";
                break;
            case ErrorCode.ERROR_CAS_NO_INIT:
                description = "cas库未初始化";
                break;
            case ErrorCode.ERROR_CAS_OVER_MAX_SESSION:
                description = "超过CASCLIENT库支持的最大数";
                break;
            case ErrorCode.ERROR_CAS_SENDTIMEOUT:
                description = "信令发送超时";
                break;
            case ErrorCode.ERROR_CAS_RECV_TIMEOUT:
                description = "信令接收超时，超时时间内信令没有回应";
                break;
            case ErrorCode.ERROR_CAS_CREATE_PACKET:
                description = "创建数据包packet失败";
                break;
            case ErrorCode.ERROR_CAS_PARSE_PACKET:
                description = "解析数据包错误";
                break;
            case ErrorCode.ERROR_CAS_FORCE_STOP:
                description = "用户中途强行退出";
                break;
            case ErrorCode.ERROR_CAS_GETPORT_FAILED:
                description = "获取本地端口错误";
                break;
            case ErrorCode.ERROR_CAS_BASE64_ENCODE:
                description = "base64编码出错";
                break;
            case ErrorCode.ERROR_CAS_BASE64_DECODE:
                description = "base64编码失败";
                break;
            case ErrorCode.ERROR_CAS_RECV_DATAERROR:
                description = "接收数据错误";
                break;
            case ErrorCode.ERROR_CAS_AES_ENCRYPT_FAILED:
                description = "AES加密出错";
                break;
            case ErrorCode.ERROR_CAS_AES_DECRYPT_FAILED:
                description = "AES解密出错";
                break;
            case ErrorCode.ERROR_CAS_OPERATION_UNSUPPORTED:
                description = "不支持的操作";
                break;
            case ErrorCode.ERROR_CAS_P2P_FAILED:
                description = "P2P打洞失败";
                break;
            case ErrorCode.ERROR_CAS_SEND_KEEPLIVE_FAILED:
                description = "发送打洞包失败";
                break;
            case ErrorCode.ERROR_CAS_USER_FORCED_ABORT:
                description = "用户强制中止取流过程";
                break;
            case ErrorCode.ERROR_CAS_BUF_OVER:
                description = "缓冲区满";
                break;
            case ErrorCode.ERROR_CAS_INIT_SSL:
                description = "初始化ssl失败";
                break;
            case ErrorCode.ERROR_CAS_CONNECT_SSL:
                description = "ssl连接失败";
                break;
            case ErrorCode.ERROR_CAS_VERIFY_OTHER_ERROR:
                description = "认证的其他错误";
                break;
            case ErrorCode.ERROR_CAS_VERIFY_DB_ERROR:
                description = "认证的数据库错误";
                break;
            case ErrorCode.ERROR_CAS_VERIFY_PARAMS_ERROR:
                description = "认证的参数错误";
                break;
            case ErrorCode.ERROR_CAS_VERIFY_EXEC_ERROR:
                description = "认证的执行异常";
                break;
            case ErrorCode.ERROR_CAS_VERIFY_SESSION_ERROR:
                description = "认证的session不正常";
                break;
            case ErrorCode.ERROR_CAS_VERIFY_CACHE_ERROR:
                description = "认证的缓存异常";
                break;
            case ErrorCode.ERROR_CAS_VERIFY_AUTH_NONE:
                description = "认证的无权限";
                break;
            // X3/N1关联IPC相应错误码
            case ErrorCode.ERROR_CAS__ASSOCIATE_ADD_IPC_NOT_IN_LAN_FAILED:
                description = "添加的摄像机和设备不在同一局域网";
                break;
            case ErrorCode.ERROR_CAS__ASSOCIATE_ADD_IPC_ASSOCIATED_OR_TIMEOUT_FAILED:
                description = "添加的摄像机被其他设备关联或超时";
                break;
            case ErrorCode.ERROR_CAS__ASSOCIATE_ADD_IPC_KEY_FAILED:
                description = "添加摄像机的密码错误";
                break;
            case ErrorCode.ERROR_CAS__ASSOCIATE_DEL_IPC_FAILED:
                description = "删除摄像机失败";
                break;
            case ErrorCode.ERROR_CAS__ASSOCIATE_ADD_IPC_OVER_MAXNUM:
                description = "设备添加的摄像机已满";
                break;
            // 添加探测器错误码
            case ErrorCode.ERROR_CAS_DETECTOR_TYPE_NOT_SUPPORT:
                description = "不支持的探测器类型";
                break;
            // 增加的云存储错误码
            case ErrorCode.ERROR_CAS_CLOUD_DBA_IS_DEAD:
                description = "dba或数据库连接错误";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_LMFILE_IS_FULL:
                description = "留言文件已满";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_LMFILE_IS_EXIST:
                description = "留言文件已存在";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_LMFILE_FILE_NAME_ERROR:
                description = "文件名格式错误";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_LMFILE_NO_PERM:
                description = "无权限访问该文件";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_GET_SEGMENT_FAIL:
                description = "获取文件失败";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_SEGMENT_NO_EXIST:
                description = "文件不存在";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_DOWNLOAD_FAIL:
                description = "下载文件失败";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_NO_RESPONSE:
                description = "未收到Manager回应";
                break;
            case ErrorCode.ERROR_CAS_PTZ_CONTROL_CALLING_PRESET_FAILED:
                description = "正在调用预置点，键控动作无效";
                break;
            case ErrorCode.ERROR_CAS_PTZ_CONTROL_TIMEOUT_SOUND_LACALIZATION_FAILED:
                description = "当前正在声源定位";
                break;
            case ErrorCode.ERROR_CAS_PTZ_CONTROL_TIMEOUT_CRUISE_TRACK_FAILED:
                description = "键控动作超时(当前正在轨迹巡航)";
                break;
            case ErrorCode.ERROR_CAS_PTZ_PRESET_INVALID_POSITION_FAILED:
                description = "当前预置点信息无效";
                break;
            case ErrorCode.ERROR_CAS_PTZ_PRESET_CURRENT_POSITION_FAILED:
                description = "该预置点已是当前位置";
                break;
            case ErrorCode.ERROR_CAS_PTZ_PRESET_SOUND_LOCALIZATION_FAILED:
                description = "声源定位已开启，不允许调用预置点";
                break;
            case ErrorCode.ERROR_CAS_PTZ_PRESET_PRESETING_FAILE:
                description = "正在调用预置点";
                break;
            case ErrorCode.ERROR_CAS_PTZ_OPENING_PRIVACY_FAILED:
                description = "正在开启隐私遮蔽";
                break;
            case ErrorCode.ERROR_CAS_PTZ_CLOSING_PRIVACY_FAILED:
                description = "正在关闭隐私遮蔽";
                break;
            case ErrorCode.ERROR_CAS_PTZ_FAILED:
                description = "云台当前操作失败";
                break;
            case ErrorCode.ERROR_CAS_PTZ_PRESET_EXCEED_MAXNUM_FAILED:
                description = "当前预置点超过最大个数";
                break;
            case ErrorCode.ERROR_CAS_PTZ_PRIVACYING_FAILED:
                description = "设备处于隐私遮蔽状态（关闭镜头后，再去操作云台相关）";
                break;
            case ErrorCode.ERROR_CAS_PTZ_MIRRORING_FAILED:
                description = "设备正在镜像操作（设备镜像要几秒钟，防止频繁镜像操作）";
                break;
            case ErrorCode.ERROR_CAS_PTZ_CONTROLING_FAILED:
                description = "设备正在键控动作（上下左右）(一个客户端在上下左右控制，另外一个在开其它东西)";
                break;
            case ErrorCode.ERROR_CAS_PTZ_TTSING_FAILED:
                description = "设备处于语音对讲状态(此时不可以操作云台，该操作码仅用于云台操作是）";
                break;
            case ErrorCode.ERROR_CAS_PTZ_ROTATION_UP_LIMIT_FAILED:
                description = "设备云台旋转到达上限位，建议app层收到此错误码后提示用户或禁止用户继续操作";
                break;
            case ErrorCode.ERROR_CAS_PTZ_ROTATION_DOWN_LIMIT_FAILED:
                description = "设备云台旋转到达下限位，建议app层收到此错误码后提示用户或禁止用户继续操作";
                break;
            case ErrorCode.ERROR_CAS_PTZ_ROTATION_LEFT_LIMIT_FAILED:
                description = "设备云台旋转到达左限位，建议app层收到此错误码后提示用户或禁止用户继续操作";
                break;
            case ErrorCode.ERROR_CAS_PTZ_ROTATION_RIGHT_LIMIT_FAILED:
                description = "设备云台旋转到达右限位，建议app层收到此错误码后提示用户或禁止用户继续操作";
                break;
            case ErrorCode.ERROR_CAS_UNKNOW:
                description = "未知错误";
                break;
            case ErrorCode.ERROR_CAS_CLIENT_NOINT:
                description = "没有初始化";
                break;
            case ErrorCode.ERROR_CAS_NO_DATA:
                description = "头数据为0";
                break;
            case ErrorCode.ERROR_CAS_CLOUD_SERVER_IS_NULL:
                description = "云存储地址为空";
                break;
            case ErrorCode.ERROR_CAS_TIMEOUT:
                description = "取流超时";
                break;
            case ErrorCode.ERROR_CAS_STREAM_SOCKET_ERROR:
                description = "socket错误，可能是未收到取流结束标记，设备端即已断开socket";
                break;
            case ErrorCode.ERROR_CAS_STREAM_RECV_ERROR:
                description = "socket接收错误，可能是未收到取流结束标记，设备端即已断开socket";
                break;
            case ErrorCode.ERROR_CAS_STREAM_SEND_ERROR:
                description = "socket发送错误，可能是未收到取流结束标记，设备端即已断开socket";
                break;
            case ErrorCode.ERROR_CAS_AUDIO_SOCKET_ERROR:
                description = "音频socket错误";
                break;
            case ErrorCode.ERROR_CAS_AUDIO_RECV_ERROR:
                description = "音频流接收错误";
                break;
            case ErrorCode.ERROR_CAS_AUDIO_SEND_ERROR:
                description = "音频流发送错误";
                break;
            case ErrorCode.ERROR_CAS_PLAYBACK_OVER:
                description = "回放完成";
                break;
            case ErrorCode.ERROR_CAS_PLAYBACK_REALOVER:
                description = "服务器返回的结束标志，表示真正结束";
                break;
            default:
                description = "cas错误，错误未知";
        }

        return description;
    }
}
