package com.videogo.errorlayer;

import com.videogo.exception.ErrorCode;

/**
 * Created by yudan on 16/5/5.
 */
public class StreamClientErrorLayer extends ErrorLayer {

    // 获取完整的错误码信息
    public ErrorInfo getErrorInfo(int errorCode) {
        ErrorInfo errorInfo = new ErrorInfo();
        if (errorCode < 0) {
            errorInfo.errorCode = ErrorDefine.STREAMCLIENT_ERROR_BASE + 10000 + errorCode;

        } else {
            errorInfo.errorCode = ErrorDefine.STREAMCLIENT_ERROR_BASE + errorCode;
        }

        errorInfo.description = getDescription(errorInfo.errorCode);

        return errorInfo;
    }

    // 根据错误码获取错误描述
    public String getDescription(int errorCode) {
        String description = "";
        switch (errorCode) {
            case ErrorCode.ERROR_STREAM_NO_ERROR:
                description = "no error";
                break;
            case ErrorCode.ERROR_STREAM_TIMEOUT:
                description = "私有流媒体取流超时";
                break;
            case ErrorCode.ERROR_STREAM_ERR:
                description = "私有流媒体取流通用错误";
                break;
            case ErrorCode.ERROR_STREAM_NULL_PTR:
                description = "参数为空指针";
                break;
            case ErrorCode.ERROR_STREAM_INVALID_PARAS:
                description = "参数无效";
                break;
            case ErrorCode.ERROR_STREAM_BAD_MSG:
                description = "信令消息解析非法";
                break;
            case ErrorCode.ERROR_STREAM_NO_ENOUGH_ROOM:
                description = "内存资源不足";
                break;
            case ErrorCode.ERROR_STREAM_INVALID_MSGHEAD:
                description = "协议格式不对或者消息体长度超过上限";
                break;
            case ErrorCode.ERROR_STREAM_INVALID_SERIAL:
                description = "设备序列号长度不合法";
                break;
            case ErrorCode.ERROR_STREAM_INVALID_STREAMURL:
                description = "url长度不合法";
                break;
            case ErrorCode.ERROR_STREAM_INVALID_VTDU_HOST:
                description = "解析vtm返回vtdu地址不合法";
                break;
            case ErrorCode.ERROR_STREAM_STREAM_INVALID_PEER_HOST:
                description = "解析vtm返回级联vtdu地址不合法";
                break;
            case ErrorCode.ERROR_STREAM_INVALID_SSN_STREAMKEY:
                description = "解析vtm返回会话标识长度不合法";
                break;
            case ErrorCode.ERROR_STREAM_INVALID_STREAM_HEAD:
                description = "vtdu返回流头长度不合法";
                break;
            case ErrorCode.ERROR_STREAM_INVALID_STREAM_SSN:
                description = "vtdu会话长度非法";
                break;
            case ErrorCode.ERROR_STREAM_DATAOUT_CALLBACK_UNREG:
                description = "回调函数未注册";
                break;
            case ErrorCode.ERROR_STREAM_NO_STREAM_SSN:
                description = "vtdu成功响应未携带会话标识";
                break;
            case ErrorCode.ERROR_STREAM_NO_STREAM_HEAD:
                description = "vtdu成功响应未携带流头";
                break;
            case ErrorCode.ERROR_STREAM_NO_STREAM:
                description = "无数据流，尚未使用";
                break;
            case ErrorCode.ERROR_STREAM_PB_PARSE_FAILURE:
                description = "信令消息体PB解析失败";
                break;
            case ErrorCode.ERROR_STREAM_PB_ENCAPSULATE_FAILURE:
                description = "信令消息体PB封装失败";
                break;
            case ErrorCode.ERROR_STREAM_MEMALLOC_FAIL:
                description = "申请系统内存资源失败";
                break;
            case ErrorCode.ERROR_STREAM_VTDUSRV_NOT_SET:
                description = "vtdu地址尚未获取到";
                break;
            case ErrorCode.ERROR_STREAM_NOT_SUPPORTED:
                description = "客户端尚未支持";
                break;
            case ErrorCode.ERROR_STREAM_ALLOCATE_SOCKET_FAIL:
                description = "获取系统socket资源失败";
                break;
            case ErrorCode.ERROR_STREAM_INVALID_STREAM_SSN_ID:
                description = "上层填充的StreamSsnId不匹配";
                break;
            case ErrorCode.ERROR_STREAM_CONNECT_SRV_FAIL:
                description = "连接服务器失败";
                break;
            case ErrorCode.ERROR_STREAM_REQUEST_TIMEOUT:
                description = "客户端请求未收到服务端应答";
                break;
            case ErrorCode.ERROR_STREAM_DISCONNECTED_LINK:
                description = "链路断开";
                break;
            case ErrorCode.ERROR_STREAM_STREAM_NO_CONNECTION:
                description = "没有取流链接";
                break;
            case ErrorCode.ERROR_STREAM_STREAM_END_SUCC:
                description = "流成功停止";
                break;
            case ErrorCode.ERROR_STREAM_STREAM_DATAKEY_CHECK_FAIL:
                description = "客户端防串流校验失败";
                break;
            case ErrorCode.ERROR_STREAM_STREAM_TCP_BUFFER_FULL:
                description = "应用层tcp粘包处理缓冲区满";
                break;
            case ErrorCode.ERROR_STREAM_STREAM_INVALID_STATUS_CHANGE:
                description = "无效状态迁移";
                break;
            case ErrorCode.ERROR_STREAM_STREAM_BAD_STATUS:
                description = "无效客户端状态";
                break;
            case ErrorCode.ERROR_STREAM_STREAM_VTM_VTDUINFO_REQ_TMOUT:
                description = "向vtm取流流媒体信息请求超时";
                break;
            case ErrorCode.ERROR_STREAM_STREAM_PROXY_STARTSTREAM_REQ_TMOUT:
                description = "向代理取流请求超时";
                break;
            case ErrorCode.ERROR_STREAM_STREAM_PROXY_KEEPALIVE_REQ_TMOUT:
                description = "向代理保活取流请求超时";
                break;
            case ErrorCode.ERROR_STREAM_STREAM_VTDU_STARTSTREAM_REQ_TMOUT:
                description = "向vtdu取流请求超时";
                break;
            case ErrorCode.ERROR_STREAM_STREAM_VTDU_KEEPALIVE_REQ_TMOUT:
                description = "向vtdu保活取流请求超时";
                break;

            case ErrorCode.ERROR_STREAM_VTDU_STATUS_BASE:
                description = "服务端起始响应码";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_402:
                description = "回放找不到录像文件";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_403:
                description = "操作码或信令密钥与设备不匹配，需要重新获取设备操作码";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_404:
                description = "设备不在线";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_405:
                description = "流媒体向设备发送或接受信令超时";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_406:
                description = "token失效，重新启动客户端可解决此问题";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_407:
                description = "客户端的URL格式错误";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_409:
                description = "预览开启隐私保护";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_410:
                description = "设备达到最大连接数";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_411:
                description = "token无权限";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_412:
                description = "session不存在";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_413:
                description = "验证token的值异常";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_415:
                description = "通道号错误";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_451:
                description = "设备不支持的码流类型";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_452:
                description = "设备连接预览流媒体服务器失败";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_454:
                description = "设备与服务器之间的链路断开";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_491:
                description = "相同请求正在处理，拒绝本次处理";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_500:
                description = "流媒体服务器内部处理错误";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_503:
                description = "vtm分配vtdu服务器失败";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_544:
                description = "设备返回无视频源";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_545:
                description = "设备分享时间已经结束";
                break;
            case ErrorCode.ERROR_STREAM_NO_INIT:
                description = "私有流媒体库没有初始化";
                break;
            case ErrorCode.ERROR_STREAM_CREATE_ERROR:
                description = "create失败";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_546:
                description = "取流并发路数限制";
                break;
            case ErrorCode.ERROR_STREAM_VTDU_STATUS_416:
                description = "设备达到最大连接数";
                break;
            default:
                description = "streamclientsdk未知错误";
        }

        return description;
    }

}
