package com.videogo.errorlayer;

import android.text.TextUtils;

import com.ez.stream.EZError;
import com.videogo.exception.EZOpenSDKErrorInfo;
import com.videogo.exception.EZOpenSDKErrorMamager;

/**
 * Created by yudan on 16/6/3.
 */
public class StreamSdkErrorLayer extends ErrorLayer {

    // 获取完整的错误码信息
    public ErrorInfo getErrorInfo(int errorCode) {
        ErrorInfo errorInfo = new ErrorInfo();

        // streamsdk的错误码需要转义下，保证开放平台的错误码和之前版本一致
        switch (errorCode / 10000) {
            case EZError.EZ_ERROR_CAS_BASE / 10000: {
                int tranferCode = errorCode % 10000;
                if (tranferCode > 1000) {
                    tranferCode = 1000 + tranferCode % 1000;
                }
                errorInfo = ErrorLayer.getErrorLayer(ErrorDefine.OPERATION_STREAM_CAS, tranferCode);
            }
            break;
            case EZError.EZ_ERROR_PRIVATE_STREAM_BASE / 10000: {
                int tranferCode = errorCode % 10000;
                errorInfo = ErrorLayer.getErrorLayer(ErrorDefine.OPERATION_STREAM_STREAMCLIENT, tranferCode);
            }
            break;
            case EZError.EZ_ERROR_TTS_BASE / 10000: {
                int tranferCode = errorCode % EZError.EZ_ERROR_TTS_BASE;
                errorInfo = ErrorLayer.getErrorLayer(ErrorDefine.OPERATION_STREAM_TTS, tranferCode);
            }
            break;
            case EZError.EZ_ERROR_NEW_TTS_BASE / 10000: {
                int tranferCode = errorCode % EZError.EZ_ERROR_NEW_TTS_BASE;
                errorInfo = ErrorLayer.getErrorLayer(ErrorDefine.OPERATION_STREAM_NEW_TTS, tranferCode);
            }
            break;
            default: {
                errorInfo.errorCode = ErrorDefine.STREAMSDK_ERROR_BASE + errorCode;
                errorInfo.description = getDescription(errorCode);
                EZOpenSDKErrorInfo errorInfo1 = EZOpenSDKErrorMamager.getMamager().getEZOpenSDKErrorInfo(String.valueOf(errorInfo.errorCode),true);
                if (errorInfo1 != null && TextUtils.isEmpty(errorInfo1.description)){
                    errorInfo.description = errorInfo1.description;
                    errorInfo.moduleCode = errorInfo1.moduleCode;
                    errorInfo.sulution = errorInfo1.solution;
                }
            }
            break;
        }

        return errorInfo;
    }

    // 根据错误码获取错误描述
    public String getDescription(int errorCode) {
        String description = "";
        switch (errorCode) {
            case ErrorDefine.STREAMSDK_ERROR_BASE + EZError.EZ_ERROR_UNKOWN:
                description = "未知错误";
                break;
            case ErrorDefine.STREAMSDK_ERROR_BASE + EZError.EZ_ERROR_INVAILD_PARAM:
                description = "参数错误";
                break;
            case ErrorDefine.STREAMSDK_ERROR_BASE + EZError.EZ_ERROR_UNSUPPORT:
                description = "取流类型错误，是否使用了预览的类对象处理回放了？";
                break;
            case ErrorDefine.STREAMSDK_ERROR_BASE + EZError.EZ_ERROR_NO_MEMORY:
                description = "内存不够";
                break;
            case ErrorDefine.STREAMSDK_ERROR_BASE + EZError.EZ_ERROR_CREATE_CAS_SESSION:
                description = "创建CAS Session出错";
                break;
            case ErrorDefine.STREAMSDK_ERROR_BASE + EZError.EZ_ERROR_CREATE_CLOUD_SESSION:
                description = "创建云回放Session出错";
                break;
            case ErrorDefine.STREAMSDK_ERROR_BASE + EZError.EZ_ERROR_INVAILD_TOKEN:
                description = "取流token失效，请重新设置取流token";
                break;
            case ErrorDefine.STREAMSDK_ERROR_BASE + EZError.EZ_ERROR_NO_TOKENS:
                description = "未传入取流token";
                break;
            case ErrorDefine.STREAMSDK_ERROR_BASE + EZError.EZ_ERROR_NEED_RESET_CLIENT:
                description = "需要reset initParam参数";
                break;
            case ErrorDefine.STREAMSDK_ERROR_BASE + EZError.EZ_ERROR_NEED_RETRY:
                description = "请重试";
                break;
            case ErrorDefine.STREAMSDK_ERROR_BASE + EZError.EZ_ERROR_NEED_RETRY_AFTER_500MS:
                description = "sleep 500毫秒后再重试";
                break;
            case ErrorDefine.STREAMSDK_ERROR_BASE + EZError.EZ_ERROR_TOKEN_POOL_FULL:
                description = "token池已满";
                break;
            case ErrorDefine.STREAMSDK_ERROR_BASE + EZError.EZ_ERROR_OVER_P2P_COUNT:
                description = "P2P数量超过限制";
                break;
            case ErrorDefine.STREAMSDK_ERROR_BASE + EZError.EZ_ERROR_LIB_UNINITIALIZED:
                description = "SDK未初始化";
                break;
            default:
                description = "";
                break;
        }

        return description;
    }
}
