package com.videogo.errorlayer;

import com.videogo.exception.ErrorCode;

/**
 * Created by yudan on 16/5/6.
 */
public class StreamTtsErrorLayer extends ErrorLayer {

    // 获取完整的错误码信息
    public ErrorInfo getErrorInfo(int errorCode) {
        ErrorInfo errorInfo = new ErrorInfo();
        if (errorCode < 0) {
            errorInfo.errorCode = ErrorDefine.TTS_ERROR_BASE + 10000 + errorCode;
        } else {
            errorInfo.errorCode = ErrorDefine.TTS_ERROR_BASE + errorCode;
        }
        errorInfo.description = getDescription(errorInfo.errorCode);
        return errorInfo;
    }

    // 根据错误码获取错误描述
    public String getDescription(int errorCode) {
        String description = "";
        switch (errorCode) {
            case ErrorCode.ERROR_TTS_MSG_NO_ERROR:
                description = "no error";
                break;
            case ErrorCode.ERROR_TTS_MSG_REQ_TIMEOUT:
                description = "客户端请求超时";
                break;
            case ErrorCode.ERROR_TTS_MSG_SVR_HANDLE_TIMEOUT:
                description = "服务器处理请求超时";
                break;
            case ErrorCode.ERROR_TTS_MSG_DEV_CONN_ERROR:
                description = "TTS的设备端发生错误";
                break;
            case ErrorCode.ERROR_TTS_MSG_CLN_MSG_ERROR:
                description = "客户端发送的消息错误";
                break;
            case ErrorCode.ERROR_TTS_MSG_CLN_RECV_ERROR:
                description = "客户端接收发生错误";
                break;
            case ErrorCode.ERROR_TTS_MSG_SVR_CLOSE_CONN:
                description = "TTS关闭了与客户端的连接，此错误一般是由于关闭对讲和打开对讲时间间隔过低导致";
                break;
            case ErrorCode.ERROR_TTS_MSG_DEV_PRIVACY_ON:
                description = "设备开启了隐私保护";
                break;
            case ErrorCode.ERROR_TTS_CREATE_ERROR:
                description = "创建失败";
                break;
            case ErrorCode.ERROR_TTS_INIT_ERROR:
                description = "初始化失败";
                break;
                
            // 接口错误码，相比上面的错误码，以下错误码增加了基数1000
            case ErrorCode.ERROR_TTS_WAIT_TIMEOUT:
                description = "请求等待超时(客户端)";
                break;
            case ErrorCode.ERROR_TTS_HNADLE_TIMEOUT:
                description = "连接TTS失败(客户端)";
                break;
            case ErrorCode.ERROR_TTS_DEV_CONN_ERR:
                description = "TTS与设备的连接异常中断(服务器端)";
                break;
            case ErrorCode.ERROR_TTS_TTS_INTERNAL_ERR:
                description = "TTS内部处理异常(服务器端)";
                break;
            case ErrorCode.ERROR_TTS_MSG_TYPE_ERR:
                description = "TTS接受到的消息类型不正确(客户端)";
                break;
            case ErrorCode.ERROR_TTS_NEED_REDIRECT:
                description = "客户端需要重定向(服务器返回)";
                break;
            case ErrorCode.ERROR_TTS_REQ_URL_WRONG:
                description = "客户端的URL格式错误(服务器返回)";
                break;
            case ErrorCode.ERROR_TTS_CHAECK_TOKEN_FAIL:
                description = "TTS验证token失败(服务器返回)";
                break;
            case ErrorCode.ERROR_TTS_OPR_OR_CRT_NO_MATCH:
                description = "操作码或信令密钥与设备不匹配";
                break;
            case ErrorCode.ERROR_TTS_DEVICE_TAKLING_NOW:
                description = "设备正在对讲中(频繁迅速开关对讲比较容易报此错误，设备端关闭对讲资源需要一小段时间)";
                break;
            case ErrorCode.ERROR_TTS_DEV_MSG_TIMEOUT:
                description = "TTS发送或接受设备信令超时(服务器返回)";
                break;
            case ErrorCode.ERROR_TTS_DEV_NO_ONLINE:
                description = "设备不在线(服务器返回)";
                break;
            case ErrorCode.ERROR_TTS_DEV_PRIVACY_ON:
                description = "设备处于隐私保护状态(服务器返回)";
                break;
            case ErrorCode.ERROR_TTS_CLN_CREATE_THD_FAIL:
                description = "客户端创建线程失败(客户端)";
                break;
            case ErrorCode.ERROR_TTS_CLN_URL_WRONG:
                description = "客户端处理URL失败(客户端)";
                break;
            case ErrorCode.ERROR_TTS_REDIRECT_URL_WRONG:
                description = "客户端获取的重定向URL错误(客户端)";
                break;
            case ErrorCode.ERROR_TTS_TOEKN_NO_AUTH:
                description = "token无权限(服务器返回)";
                break;
            case ErrorCode.ERROR_TTS_TOEKN_SESSION_INVALID:
                description = "session不存在(服务器返回)";
                break;
            case ErrorCode.ERROR_TTS_TOEKN_OTHER_ERROR:
                description = "token认证的其他错误(服务器返回)";
                break;
            case ErrorCode.ERROR_TTS_CLN_PARAM_ERROR:
                description = "客户端函数传参错误(客户端)";
                break;
            case ErrorCode.ERROR_TTS_CLN_SOCK_CREATE_ERROR:
                description = "客户端创建socket出错(客户端)";
                break;
            case ErrorCode.ERROR_TTS_CLN_SOCK_RECV_ERROR:
                description = "客户端接收信令socket异常(客户端)";
                break;
            case ErrorCode.ERROR_TTS_CLN_SOCK_SEND_ERROR:
                description = "客户端发送信令socket异常(客户端)";
                break;
            case ErrorCode.ERROR_TTS_CLN_SOCK_CLOSE:
                description = "客户端获知TTS关闭了链接(客户端)";
                break;
            case ErrorCode.ERROR_TTS_RSP_TYPE_ERROR:
                description = "TTS返回的信令类型错误(客户端)";
                break;
            case ErrorCode.ERROR_TTS_RSP_RST_ERROR:
                description = "TTS响应中的result为负值(客户端)";
                break;
            default:
                description = "TTS库未知错误";
        }

        return description;
    }

}
