package com.videogo.errorlayer;


import com.videogo.exception.ErrorCode;

/**
 * Created by yudan on 16/5/4.
 */
public class WebErrorLayer extends ErrorLayer {

    public ErrorInfo getErrorInfo(int errorCode) {

        ErrorInfo errorInfo = new ErrorInfo();
        if (errorCode < 0) {
            errorInfo.errorCode = ErrorDefine.WEB_ERROR_BASE + 100000 + errorCode;

        } else {
            errorInfo.errorCode = ErrorDefine.WEB_ERROR_BASE + errorCode;
        }

        errorInfo.description = getDescription(errorInfo.errorCode);

        return errorInfo;
    }
    
    public String getDescription(int errorCode) {
        String description;
        switch (errorCode) {
            case ErrorCode.ERROR_WEB_USER_NAME_NOT_LEGAL:
                description = "用户名不合法";
                break;
            case ErrorCode.ERROR_WEB_USER_NAME_OCCUPIED:
                description = "用户名已存在";
                break;
            case ErrorCode.ERROR_WEB_PHONE_NUMBER_REGISTERED:
                description = "该手机号已被注册";
                break;
            case ErrorCode.ERROR_WEB_USER_NOT_EXIST:
                description = "用户名不存在";
                break;
            case ErrorCode.ERROR_WEB_PASSWORD_NOT_LEGAL:
                description = "密码不合法";
                break;
            case ErrorCode.ERROR_WEB_PASSWORD_SAME_CHARACTER:
                description = "密码不能为同一字符，如aaaaaaaa是不允许的";
                break;
            case ErrorCode.ERROR_WEB_SERVER_ERROR:
                description = "服务器可能在开小差";
                break;
            case ErrorCode.ERROR_WEB_GET_VEIFY_CODE_ERROR:
                description = "获取验证码失败-------------------------------------------";
                break;
            case ErrorCode.ERROR_WEB_USER_NOT_MATCH_PHONE_NUMBER:
                description = "用户名和手机不匹配";
                break;
            case ErrorCode.ERROR_WEB_USER_NAME_REGISTERED_MORE:
                description = "用户名被多次注册--------------------------------------------";
                break;
            case ErrorCode.ERROR_WEB_PARAM_ERROR:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_SESSION_ERROR:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_SESSION_EXPIRE:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_USER_PASSWORD_ERROR:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_APPKEY_ERROR:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_IP_LIMIT:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_INVOKE_LIMIT:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_SIGN_ERROR:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_SIGN_PARAM_ERROR:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_SIGN_EXPIRE:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_YSSERVICE_NOTOPENED:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_CODE_ERROR:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_SMS_VERIFY_BIND_ERROR:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_SESSION_KEY_NOMATCH:
                description = "AppKey和AccessToke不匹配，请确认获取token的接口用的appkey，和sdk初始化设置的appkey是否一致（部分开发者参照sdk demo，可能appkey没有改成自己的）";
                break;
            case ErrorCode.ERROR_WEB_CALLAPI_TOO_OFTEN:
                description = "接口调用太频繁";
                break;
            case ErrorCode.ERROR_WEB_TERMINAL_BINDING:
                description = "账号开启了终端绑定，请到i.ys7.com中解除终端绑定";
                break;
            case ErrorCode.ERROR_WEB_GET_CODE_LIMIT:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_HARDWARE_SIGNATURE_IS_NULL:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_HARDWARE_SIGNATURE_ERROR:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_HARDWARE_SIGNATURE_OP_ERROR:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_NET_EXCEPTION:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_CAMERA_NOT_EXIT:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_DEVICE_NOT_EXIT:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_DEVICE_OFFLINE:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_DEVICE_RESP_TIMEOUT:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_DEVICE_NOT_HAVE:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_DEVICE_VALICATECODE_ERROR:
                description = "设备验证码错误，验证码位于设备机身上的6位大写字符";
                break;
            case ErrorCode.ERROR_WEB_DEVICE_UNSUPPORT_CLOUD:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_DEVICE_NOT_ADD:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_DEVICE_ONLINE_NOT_ADD:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_DEVICE_ONLINE_ADDED:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_DEVICE_OFFLINE_NOT_ADD:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_DEVICE_OFFLINE_ADDED:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_DEVICE_ADD_OWN_AGAIN:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_DATA_ERROR:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_SERVER_EXCEPTION:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_DEVICE_NOTEXIT:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_CAMERA_NOTEXIT:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_DEVICE_ADDED:
                description = "";
                break;
            case ErrorCode.ERROR_WEB_DEVICE_NOT_ONLINE:
                description = "";
                break;
            default:
                description = "unknow error.";
        }

        return description;
    }

}
