package com.videogo.openapi;

import android.text.TextUtils;
import android.util.Log;

import com.ezviz.hcnetsdk.EZLoginDeviceInfo;
import com.ezviz.hcnetsdk.EZSADPDeviceInfo;
import com.hikvision.keyprotect.KeyProtect;
import com.hikvision.netsdk.HCNetSDK;
import com.hikvision.netsdk.INT_PTR;
import com.hikvision.netsdk.NET_DVR_DEVICEINFO_V30;
import com.hikvision.netsdk.NET_DVR_SDKLOCAL_CFG;
import com.hikvision.sadp.DeviceFindCallBack;
import com.hikvision.sadp.SADP_DEVICE_INFO;
import com.hikvision.sadp.Sadp;
import com.videogo.exception.BaseException;
import com.videogo.util.LogUtil;

import java.util.Locale;

/**
 * 项目名称：EZOpenSDK
 * 类描述：
 * 创建人：dingwei3
 * 创建时间：2017/8/15 14:19
 * 修改人：dingwei3
 * 修改时间：2017/8/15 14:19
 * 修改备注：
 */
public class EZHCNetDeviceSDK {
    static EZHCNetDeviceSDK mEZHCNetSDKApi = null;
    private static EZEncryptType mType;

    /**
     * 设置OEM加密类型,普通设备不用设置
     * @param type
     */
    public void setEncryptType(EZEncryptType type) {
        EZHCNetDeviceSDK.mType = type;
        setConfig();
    }


    private EZHCNetDeviceSDK(){
        Sadp mSadp = Sadp.getInstance();
        if(mSadp == null) {
        }
        if(HCNetSDK.getInstance() == null) {
            mSadp.SADP_Clearup();
            mSadp = null;
        }
        HCNetSDK.getInstance().NET_DVR_Init();
        //HCNetSDK.getInstance().NET_DVR_SetExceptionCallBack(EZHCNetExceptionMsg.getInstance());
        setConfig();
        HCNetSDK.getInstance().NET_DVR_SetConnectTime(5000);
    }

    public interface SadpDeviceFoundListener {
        public void onDeviceFound(EZSADPDeviceInfo sadp_device_info);
    }

    /**
     初始化SDK
     */
    public static EZHCNetDeviceSDK getInstance(){
        if (mEZHCNetSDKApi != null){
            return mEZHCNetSDKApi;
        }
        return new EZHCNetDeviceSDK();
    }


    private void setConfig(){
        NET_DVR_SDKLOCAL_CFG struSdkCfg = new NET_DVR_SDKLOCAL_CFG();
        HCNetSDK.getInstance().NET_DVR_GetSDKLocalConfig(struSdkCfg);
        struSdkCfg.byEnableAbilityParse = 1;
        //Begin:设置OEM加密密钥
        /**
         * 定制加密方法选择
         */
        if(mType == EZEncryptType.EZEncryptType_OEMBlue){
            byte[] bule_byScrkey = {'H', (byte)0x96, 0x68, (byte)0xa3, 0x61, (byte)0xbf, 0x6e, (byte)0xb5, 0x67, (byte)0xcd, 0x7a, (byte)0xfe, 0x68, (byte)0xca, 0x6f, (byte)0xde, 0x75, 'I', 'K', (byte)0x37, (byte)0x5c};
            KeyProtect.getInstance().ENCRYPT_GetKey(bule_byScrkey, 21, struSdkCfg.byProtectKey, 128);

        }else if(mType == EZEncryptType.EZEncryptType_OEMGreen){
            byte[] green_byScrkey = {'H', (byte)0x97, (byte)0x68, (byte)0xa3, (byte)0x61, (byte)0xbf, (byte)0x6e, (byte)0xb5, (byte)0x67, (byte)0xcd, (byte)0x7a, (byte)0xfe, (byte)0x68, (byte)0xca, (byte)0x6f, (byte)0xde, (byte)0x75,
                    'I', 'K', (byte)0x39, (byte)0x5c};
            KeyProtect.getInstance().ENCRYPT_GetKey(green_byScrkey, 21, struSdkCfg.byProtectKey, 128);
        }
        //End:设置OEM加密密钥
        HCNetSDK.getInstance().NET_DVR_SetSDKLocalConfig(struSdkCfg);// 用于开放本地模拟能力
    }

    /**
     * 开始搜索局域网设备
     * @param listener 搜索结果回调，每搜到一个设备都会回调一次
     */
    public boolean startLocalSearch(final SadpDeviceFoundListener listener) {
        boolean ret = false;
        Log.d("NetSDK", "startLocalSearch");
        if(Sadp.getInstance() != null && listener != null) {
            ret = Sadp.getInstance().SADP_Start_V30(new DeviceFindCallBack() {
                @Override
                public void fDeviceFindCallBack(SADP_DEVICE_INFO sadp_device_info) {
                    EZSADPDeviceInfo deviceInfo = new EZSADPDeviceInfo(sadp_device_info);
                    listener.onDeviceFound(deviceInfo);
                }
            });
        }
        return ret;
    }

    /**
     * 停止搜索
     * @return 成功或失败
     */
    public boolean stopLocalSearch(){
        boolean ret = false;
        if (Sadp.getInstance() != null) {
            ret = Sadp.getInstance().SADP_Stop();
        }
        return ret;
    }

    /**
     * 激活设备,耗时任务需在线程中使用
     * @param serail 设备序列号
     * @param pwd   激活密码
     * @return  成功或失败 1 成功;0失败
     */
    public int activeDeviceWithSerial(String serail,String pwd){
        Log.d("NetSDK", String.format(Locale.CHINA,"activeDeviceWithSerial [%s][%s]", serail, pwd));
        int iFlag = Sadp.getInstance().SADP_ActivateDevice(serail, pwd);
        if (iFlag == 0){
            int erroCode = Sadp.getInstance().SADP_GetLastError();
            if (erroCode  == 2021){
                iFlag = 0;
            }
        }
        return iFlag;
    }

    /**
     * 设备登录
     * @param userName 用户名
     * @param pwd        密码
     * @param deviceip    设备ip
     * @param port         设备port
     * @return userId,用作预览和登出,小于0为错误
     */
    public EZLoginDeviceInfo loginDeviceWithUerName(String userName,String pwd,String deviceip,int port) throws BaseException {
        int userId = -1;
        HCNetSDK mHCNetSDK = HCNetSDK.getInstance();
        if(mHCNetSDK == null || TextUtils.isEmpty(deviceip) || port < 1) {
            LogUtil.e("EZHCNetSDK", "mHCNetSDK is null or deviceip is null or port Less than 1" );
            return null;
        }
        int errorCode = 0;
        NET_DVR_DEVICEINFO_V30 devInfo = new NET_DVR_DEVICEINFO_V30();
        userId = mHCNetSDK.NET_DVR_Login_V30(deviceip,port,userName,pwd,devInfo);
        if(userId < 0) {
            errorCode = mHCNetSDK.NET_DVR_GetLastError();
            INT_PTR ptt = new INT_PTR();
            ptt.iValue = errorCode;
            String errorMsg = HCNetSDK.getInstance().NET_DVR_GetErrorMsg(ptt);
            LogUtil.e("EZHCNetSDK", "NET_DVR_Login is failed!err:" + errorCode);
            throw  new BaseException(errorMsg, errorCode,null);
        }
        if(errorCode == 0) {
            EZLoginDeviceInfo ezLoginDeviceInfo = new EZLoginDeviceInfo(devInfo,userId);
            return ezLoginDeviceInfo;
        }
        return null;
    }

    /**
     * 登出局域网设备
     * @param userId 登录设备成功后得到的userId
     * @return  成功或失败
     */
    public boolean logoutDeviceWithUserId(int userId){
        boolean ret = false;
        if(HCNetSDK.getInstance() != null && userId != -1) {
            ret = HCNetSDK.getInstance().NET_DVR_Logout_V30(userId);
        }
        return ret;
    }

    ///**
    // * 局域网设备云台控制接口
    // * @param userId    登录设备成功后得到的userId
    // * @param channelNo 通道channel number
    // * @param command
    // * @param action    PTZAction
    // * @return
    // */
    //public boolean ptzControlWithUserId(int userId, int channelNo, int command,PTZAction action){
    //    boolean ret = false;
    //    if(HCNetSDK.getInstance() != null && userId != -1) {
    //        ret = HCNetSDK.getInstance().NET_DVR_PTZControl_Other(userId,channelNo,command,action.getValue());
    //    }
    //    return ret;
    //}

    public enum  PTZAction {
        PTZ_ACTION_START(0),
        PTZ_ACTION_STOP(1);
        private int value;
        private PTZAction(int ret) {
            this.value = ret;
        }
        public int getValue() {
            return value;
        }
    }

    public enum EZEncryptType{
        /**
         * 普通模式
         */
        EZEncryptType_normal,
        /**
         * 绿巨人加密
         */
        EZEncryptType_OEMGreen,
        /**
         * 蓝精灵加密
         */
        EZEncryptType_OEMBlue,
    }
}
