/*
 * @ProjectName VideoGoJar
 * @Copyright null
 *
 * @FileName EzvizAPI.java
 * @Description 这里对文件进行描述
 *
 * @author chenxingyf1
 * @data 2014-7-8
 *
 * @note 这里写本文件的详细功能描述和注释
 * @note 历史记录
 *
 * @warning 这里写本文件的相关警告
 */
package com.videogo.openapi;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.text.TextUtils;

import com.ez.stream.JsonUtils;
import com.ezviz.opensdk.data.EZDatabaseHelper;
import com.ezviz.opensdk.data.EZDatabaseManager;
import com.ezviz.opensdk.data.FileCacheDeviceInfoManager;
import com.hikvision.wifi.configuration.DeviceDiscoveryListener;
import com.videogo.util.LocalInfo;
import com.videogo.errorlayer.ErrorDefine;
import com.videogo.errorlayer.ErrorInfo;
import com.videogo.errorlayer.ErrorLayer;
import com.videogo.exception.BaseException;
import com.videogo.exception.EZOpenSDKErrorMamager;
import com.videogo.exception.ErrorCode;
import com.videogo.openapi.annotation.HttpParam;
import com.videogo.openapi.bean.BaseInfo;
import com.videogo.openapi.bean.EZProbeDeviceInfo;
import com.videogo.openapi.bean.EZProbeDeviceInfoResult;
import com.videogo.openapi.model.ApiResponse;
import com.videogo.openapi.model.req.WebLoginReq;
import com.videogo.wificonfig.APWifiConfig;
import com.videogo.wificonfig.ConfigWifiSdkManager;
import com.videogo.util.LogUtil;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * 平台开放接口（api）
 *
 * @author chenxingyf1
 * @data 2014-7-8
 */
@SuppressLint("MissingPermission")
public class EzvizAPI extends PlayAPI {

    public static final String TAG = "EzvizAPI";

    private static EzvizAPI mEzvizAPI = null;

    public EzvizAPI(Application application, String appKey, boolean isUsingGlobal) {
        super(application, appKey, isUsingGlobal);
        EZDatabaseManager.initializeInstance(new EZDatabaseHelper(application.getApplicationContext()));
    }

    public synchronized static void init(Application application, String appKey, boolean isUsingGlobal) {
        if (mEzvizAPI == null) {
            mEzvizAPI = new EzvizAPI(application, appKey, isUsingGlobal);
            FileCacheDeviceInfoManager.getDeviceCacheDetailInfo();
        } else {
            if (!appKey.equalsIgnoreCase(mEzvizAPI.getAppKey())) {
                EzvizAPI.getInstance().setAccessToken("");
            }
            mEzvizAPI.setAppKey(appKey);
        }
    }

    public static EzvizAPI getInstance() {
        return mEzvizAPI;
    }

    protected void releaseSDK() {
        super.releaseSDK();
        mEzvizAPI = null;
    }

    @Override
    public void initErrorInfoList() {
        EZOpenSDKErrorMamager.getMamager().getEZOpenSDKErrorInfoList(EZDatabaseManager.getInstance().getErrorTableVersion());
    }

    public void startConfigWifi(Context context, String deviceSerial, final String ssid, final String password,
                                int mode, final String apiUrl, EZOpenSDKListener.EZStartConfigWifiCallback callback) {
        LogUtil.i(TAG, "Enter startConfigWifi  EZConfigWifiCallback");
        ConfigWifiSdkManager.startConfigWifi(context, deviceSerial, ssid, password, mode, apiUrl, callback);
    }

    public boolean startConfigWifi(Context context, final String ssid, final String password,
     final DeviceDiscoveryListener l) {
        LogUtil.i(TAG, "Enter startConfigWifi  DeviceDiscoveryListener");
        ConfigWifiSdkManager.startConfigWifi(context, ssid, password, l);
        return true;
    }

    public boolean stopConfigWiFi() {
        LogUtil.i(TAG, "Enter stopConfigWiFi");
        ConfigWifiSdkManager.stopConfigWifi();
        return true;
    }

    /**
     * AP配网接口,默认为"EZVIZ_"+设备序列号,设备AP热点密码默认为"EZVIZ_"+设备验证码,默认自动连接设备热点，需要获取可扫描wifi的权限
     *
     * @param ssid             WiFi的ssid
     * @param password         WiFi的密码
     * @param deviceSerial     设备序列号
     * @param verifyCode       设备验证码
     * @param apConfigCallback 结果回调
     */
    public void startAPConfigWifiWithSsid(final String ssid, final String password, String deviceSerial,
     final String verifyCode, final APWifiConfig.APConfigCallback apConfigCallback) {
        ConfigWifiSdkManager.startAPConfigWifiWithSsid(ssid, password, deviceSerial, verifyCode, apConfigCallback);
    }

    /**
     * AP配网接口
     *
     * @param ssid                       WiFi的ssid
     * @param password                   WiFi的密码
     * @param deviceSerial               设备序列号
     * @param verifyCode                 设备验证码
     * @param routerName                 设备热点名称，可传空，默认为"EZVIZ_"+设备序列号
     * @param routerPassword             设备热点密码,可传空，默认为"EZVIZ_"+设备验证码
     * @param isAutoConnectDeviceHotSpot 是否自动连接设备热点,需要获取可扫描wifi的权限
     * @param apConfigCallback           结果回调
     */
    public void startAPConfigWifiWithSsid(final String ssid, final String password, String deviceSerial,
     final String verifyCode, final String routerName, final String routerPassword,
      boolean isAutoConnectDeviceHotSpot, APWifiConfig.APConfigCallback apConfigCallback) {
        ConfigWifiSdkManager.startAPConfigWifiWithSsid(ssid, password, deviceSerial, verifyCode, routerName,
         routerPassword, isAutoConnectDeviceHotSpot, null, apConfigCallback);
    }

    /**
     * AP配网接口
     *
     * @param ssid                       WiFi的ssid
     * @param password                   WiFi的密码
     * @param deviceSerial               设备序列号
     * @param verifyCode                 设备验证码
     * @param routerName                 设备热点名称，可传空，默认为"EZVIZ_"+设备序列号
     * @param routerPassword             设备热点密码,可传空，默认为"EZVIZ_"+设备验证码
     * @param isAutoConnectDeviceHotSpot 是否自动连接设备热点,需要获取可扫描wifi的权限
     * @param apiUrl                     指定去哪个平台查询
     * @param apConfigCallback           结果回调
     */
    public void startAPConfigWifiWithSsid(final String ssid, final String password, String deviceSerial,
                                          final String verifyCode, final String routerName, final String routerPassword,
                                          boolean isAutoConnectDeviceHotSpot, final String apiUrl, APWifiConfig.APConfigCallback apConfigCallback) {
        ConfigWifiSdkManager.startAPConfigWifiWithSsid(ssid, password, deviceSerial, verifyCode, routerName,
                routerPassword, isAutoConnectDeviceHotSpot, apiUrl, apConfigCallback);
    }

    /**
     * 停止AP配网
     */
    public void stopAPConfigWifiWithSsid() {
        ConfigWifiSdkManager.stopAPConfigWifiWithSsid();
    }

    /**
     * @since 4.8.7
     */
    public void setVparamForLoginPage(String vParam) {
        WebLoginReq.setmVparam(vParam);
    }

    /**
     * 尝试查询设备信息（用于添加设备之前, 简单查询设备信息，如是否在线，是否添加等）
     *
     * @param deviceSerial 需要查询的设备序列号
     * @param deviceType   设备型号 (设备型号和设备序列号不能均为空,优先按照设备序列号查询)
     * @return 返回 EZProbeDeviceInfoResult 对象，包含查询的设备信息，以及异常情况
     */
    public EZProbeDeviceInfoResult probeDeviceInfo(final String deviceSerial, final String deviceType) {
        LogUtil.i(TAG, "Enter probeDeviceInfo");
        EZProbeDeviceInfoResult ezProbeDeviceInfoResult = new EZProbeDeviceInfoResult();
        int nRet = mLocalValidate.localValidatDeviceSerial(deviceSerial);
        if (nRet != 0) {
            //LogUtil.i(TAG, "probeDeviceInfo, invalid parameters deviceSerial");
            ErrorInfo errorInfo = ErrorLayer.getErrorLayer(ErrorDefine.OPERATION_INNER, nRet);
            ezProbeDeviceInfoResult.setEZProbeDeviceInfo(null);
            ezProbeDeviceInfoResult.setBaseException(new BaseException(STR_NATIVE_PARAM_ERROR, errorInfo));
            return ezProbeDeviceInfoResult;
        }

        final String modelType = TextUtils.isEmpty(deviceType) ? "" : deviceType;
        Object result = null;
        try {
            result = mRestfulUtils.post(new BaseInfo() {
                @HttpParam(name = "deviceSerial")
                private String mDeviceSerial = deviceSerial;
                @HttpParam(name = "model")
                private String model = modelType;
            }, "/api/device/searchDeviceInfo", new ApiResponse() {
                @Override
                public Object parse(String resultresponse) {
                    EZProbeDeviceInfoResult ezProbeDeviceInfoResult = new EZProbeDeviceInfoResult();
                    if (resultresponse == null) {
                        ErrorInfo errorInfo = ErrorLayer.getErrorLayer(ErrorDefine.OPERATION_INNER,
                                ErrorCode.ERROR_INNER_WEBRESPONSE_JSONERROR);
                        ezProbeDeviceInfoResult.setEZProbeDeviceInfo(null);
                        ezProbeDeviceInfoResult.setBaseException(new BaseException(NETWORK_EXCEPTION_ERROR_MSG,
                                errorInfo.errorCode, errorInfo));
                        return ezProbeDeviceInfoResult;
                    }
                    JSONObject response = null;
                    try {
                        response = new JSONObject(resultresponse);
                        String result = response.optString(RESULT);
                        JSONObject jsonObjectresult = null;
                        jsonObjectresult = new JSONObject(result);
                        if (jsonObjectresult != null) {
                            int resultCode = jsonObjectresult.optInt(CODE);
                            String resultDesc = jsonObjectresult.optString("description");
                            if (resultCode == RESULT_SUSCCEED) {
                                JSONObject data = jsonObjectresult.optJSONObject("data");
                                if (data == null) {
                                    ErrorInfo errorInfo = ErrorLayer.getErrorLayer(ErrorDefine.OPERATION_INNER, ErrorCode.ERROR_INNER_WEBRESPONSE_JSONERROR);
                                    ezProbeDeviceInfoResult.setEZProbeDeviceInfo(null);
                                    ezProbeDeviceInfoResult.setBaseException(new BaseException(NETWORK_EXCEPTION_ERROR_MSG, errorInfo.errorCode, errorInfo));
                                    return ezProbeDeviceInfoResult;
                                }
                                EZProbeDeviceInfo probeDeviceInfo = JsonUtils.fromJson(data.toString(), EZProbeDeviceInfo.class);
                                ezProbeDeviceInfoResult.setEZProbeDeviceInfo(probeDeviceInfo);
                                ezProbeDeviceInfoResult.setBaseException(null);
                                return ezProbeDeviceInfoResult;
                            } else if (resultCode == ErrorCode.ERROR_INNER_WEBRESPONSE_JSONERROR) {
                                ErrorInfo errorInfo = ErrorLayer.getErrorLayer(ErrorDefine.OPERATION_INNER,
                                        ErrorCode.ERROR_INNER_WEBRESPONSE_JSONERROR);
                                ezProbeDeviceInfoResult.setEZProbeDeviceInfo(null);
                                ezProbeDeviceInfoResult.setBaseException(new BaseException(NETWORK_EXCEPTION_ERROR_MSG, errorInfo.errorCode, errorInfo));
                                return ezProbeDeviceInfoResult;
                            } else {
                                ErrorInfo errorInfo = ErrorLayer.getErrorLayer(ErrorDefine.OPERATION_WEB, resultCode);
                                if (TextUtils.isEmpty(errorInfo.description)) {
                                    errorInfo.description = resultDesc;
                                }
                                BaseException baseException = new BaseException(resultDesc, errorInfo.errorCode, errorInfo);
                                ezProbeDeviceInfoResult.setBaseException(baseException);
                                JSONObject data = jsonObjectresult.optJSONObject("data");
                                if (data != null) {
                                    EZProbeDeviceInfo probeDeviceInfo = JsonUtils.fromJson(data.toString(),
                                            EZProbeDeviceInfo.class);
                                    ezProbeDeviceInfoResult.setEZProbeDeviceInfo(probeDeviceInfo);
                                }
                                return ezProbeDeviceInfoResult;
                            }
                        } else {
                            ErrorInfo errorInfo = ErrorLayer.getErrorLayer(ErrorDefine.OPERATION_INNER,
                                    ErrorCode.ERROR_INNER_WEBRESPONSE_JSONERROR);
                            ezProbeDeviceInfoResult.setEZProbeDeviceInfo(null);
                            ezProbeDeviceInfoResult.setBaseException(new BaseException(NETWORK_EXCEPTION_ERROR_MSG,
                                    errorInfo.errorCode, errorInfo));
                            return ezProbeDeviceInfoResult;
                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                        ErrorInfo errorInfo = ErrorLayer.getErrorLayer(ErrorDefine.OPERATION_INNER,
                                ErrorCode.ERROR_INNER_WEBRESPONSE_JSONERROR);
                        ezProbeDeviceInfoResult.setEZProbeDeviceInfo(null);
                        ezProbeDeviceInfoResult.setBaseException(new BaseException(NETWORK_EXCEPTION_ERROR_MSG,
                                errorInfo.errorCode, errorInfo));
                        return ezProbeDeviceInfoResult;
                    }
                }
            });
        } catch (BaseException e) {
            e.printStackTrace();
            ezProbeDeviceInfoResult.setEZProbeDeviceInfo(null);
            ezProbeDeviceInfoResult.setBaseException(e);
            return ezProbeDeviceInfoResult;
        }
        if (result != null) {
            LogUtil.i(TAG, ((EZProbeDeviceInfoResult) result).toString());
            return (EZProbeDeviceInfoResult) result;
        }
        return null;
    }

    /**
     * 尝试查询设备信息（用于添加设备之前, 简单查询设备信息，如是否在线，是否添加等）
     *
     * @param deviceSerial 需要查询的设备序列号
     * @param deviceType   设备型号 (设备型号和设备序列号不能均为空,优先按照设备序列号查询)
     * @param apiUrl       指定去哪个平台查询
     * @return 返回 EZProbeDeviceInfoResult 对象，包含查询的设备信息，以及异常情况
     */
    public EZProbeDeviceInfoResult probeDeviceInfo(final String deviceSerial, final String deviceType, final String apiUrl) {
        // 设置自定义域名，请求发送后切换回来
        String serverUrl = BaseAPI.getInstance().getServerUrl();
        if (apiUrl != null && apiUrl.length() > 0) {
            LocalInfo.getInstance().setServAddr(apiUrl);
        }
        EZProbeDeviceInfoResult result = probeDeviceInfo(deviceSerial, deviceType);
        LocalInfo.getInstance().setServAddr(serverUrl);

        return result;
    }
}
