package com.videogo.wificonfig;

import com.ezviz.sdk.configwifi.EZConfigWifiErrorEnum;
import com.ezviz.sdk.configwifi.EZConfigWifiInfoEnum;
import com.ezviz.sdk.configwifi.common.EZConfigWifiCallback;

/**
 * 拆分配网sdk后，仅保留用于兼容老接口
 */
public class APWifiConfig {

    /**
     * 配网回调（老接口）
     */
    public interface APConfigCallbackInterface {
        /**
         * 配网成功
         */
        void onSuccess();

        /**
         * 配网失败
         */
        void OnError(int code);

        /**
         * 配网失败，明确错误码
         */
        void onErrorNew(ConfigWifiErrorEnum error);
    }

    /**
     * 配网回调
     */
    public abstract static class APConfigCallback extends EZConfigWifiCallback implements  APConfigCallbackInterface{

        @Override
        public void onErrorNew(ConfigWifiErrorEnum error) { }

        @Override
        public void reportInfo(EZConfigWifiInfoEnum info) {
            super.reportInfo(info);
            if (info == EZConfigWifiInfoEnum.CONNECTING_SENT_CONFIGURATION_TO_DEVICE){
                onSuccess();
            }
        }

        @Override
        public void reportError(EZConfigWifiErrorEnum error) {
            super.reportError(error);
            if (error == EZConfigWifiErrorEnum.CONFIG_TIMEOUT){
                OnError(error.code);
                onErrorNew(ConfigWifiErrorEnum.CONFIG_TIMEOUT);
            }
        }
    }

}
