package com.videogo.wificonfig;

import com.ezviz.sdk.configwifi.common.LogUtil;
import com.ezviz.sdk.configwifi.finder.DeviceFindParam;
import com.ezviz.sdk.configwifi.finder.DeviceFinderAbstract;
import com.videogo.exception.ErrorCode;
import com.videogo.openapi.EzvizAPI;
import com.videogo.openapi.bean.EZProbeDeviceInfoResult;

/**
 * 从平台查设备设备是否已经上线
 */
public class DeviceFinderFromPlatform extends DeviceFinderAbstract {

    private final static String TAG = DeviceFinderFromPlatform.class.getSimpleName();

    private static DeviceFinderFromPlatform mInstance = new DeviceFinderFromPlatform();

    // 每隔一定时间从平台查一次设备状态
    private long mQueryIntervalSecond = 5;
    private long mQueryFindTimeoutSecond = 60;
    private int mMaxRetryCnt = (int) (mQueryFindTimeoutSecond / mQueryIntervalSecond);
    private boolean mFound = false;
    private String apiUrl;// 指定去哪个平台查询，默认为null

    public static DeviceFinderFromPlatform getInstance(){
        return mInstance;
    }

    @Override
    public void start(final DeviceFindParam param) {
        LogUtil.i(TAG, "start...");
        super.start(param);
        mFound = false;
        if (!QueryTaskManager.isInit()){
            QueryTaskManager.init();
        }
        final Runnable queryTask = new Runnable() {
            @Override
            public void run() {
                EZProbeDeviceInfoResult result = EzvizAPI.getInstance().probeDeviceInfo(param.serial, null, apiUrl);
                if (checkDeviceStatusFromQueryResult(result)){
                    LogUtil.i(TAG, "device is online now..." + mParam.serial);
                    mFound = true;
                    isFinding = false;
                    if (mCallback != null){
                        mCallback.onFind(param.serial);
                    }
                }
            }
        };

        QueryTaskManager.getInstance().submit(new Runnable() {
            @Override
            public void run() {
                int retryCnt = 0;
                while (isFinding && retryCnt < mMaxRetryCnt){
                    LogUtil.d(TAG, "try to find device from platform, " + mParam.serial);
                    QueryTaskManager.getInstance().submit(queryTask);
                    retryCnt++;
                    try {
                        Thread.sleep(mQueryIntervalSecond * 1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (!mFound){
                    LogUtil.e(TAG, "stopped querying, device is still offline");
                    if (mCallback != null){
                        mCallback.onTimeout(param.serial);
                    }
                }
                stop();
            }
        });
        LogUtil.i(TAG, "started");
    }

    private boolean checkDeviceStatusFromQueryResult(EZProbeDeviceInfoResult result) {
        if (result == null){
            return false;
        }
        // 设备在线，未被任何人添加
        if (result.getBaseException() == null){
            return true;
        }
        int errorCode = result.getBaseException().getErrorCode();
        // 设备在线，已被自己添加
        if (errorCode == ErrorCode.ERROR_WEB_DEVICE_NOT_ADD){
            return true;
        }
        LogUtil.i(TAG, "device is offline..." + mParam.serial);
        return false;
    }

    @Override
    public void stop() {
        super.stop();
        if (QueryTaskManager.isInit()){
            QueryTaskManager.unInit();
        }
        mFound = false;
        isFinding = false;
    }

    public void setApiUrl (String apiUrl) {
        this.apiUrl = apiUrl;
    }

    private DeviceFinderFromPlatform(){}

}
