/*
 * Decompiled with CFR 0.152.
 */
package com.ezviz.sdk.configwifi.touchAp;

import android.app.Application;
import android.content.Context;
import com.ezviz.http.bean.request.ConfigNewApRequest;
import com.ezviz.http.bean.resp.GetDeviceWifiListResp;
import com.ezviz.http.bean.resp.GetTokenResp;
import com.ezviz.http.bean.resp.NewApConfigResp;
import com.ezviz.http.core.EzvizCallback;
import com.ezviz.http.core.EzvizHttpClient;
import com.ezviz.http.exception.EzConfigWifiException;
import com.ezviz.http.model.AccessDeviceInfo;
import com.ezviz.http.model.EzWifiInfo;
import com.ezviz.sdk.configwifi.Config;
import com.ezviz.sdk.configwifi.EZConfigWifiErrorEnum;
import com.ezviz.sdk.configwifi.touchAp.GetAccessDeviceInfoCallback;
import com.ezviz.sdk.configwifi.touchAp.GetDeviceWifiListCallback;
import com.ezviz.sdk.configwifi.touchAp.GetTokenCallback;
import com.ezviz.sdk.configwifi.touchAp.StartNewApConfigCallback;
import com.ezviz.utils.JsonUtils;
import java.io.IOException;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TouchApApi {
    private static TouchApApi mTouchApApi;
    private static EzvizHttpClient mEzvizHttpClient;
    public static String TAG;
    public static String responseData;

    private TouchApApi(Application application) {
        mEzvizHttpClient = new EzvizHttpClient((Context)application);
    }

    public static synchronized void init(Application application) {
        if (mTouchApApi == null) {
            mTouchApApi = new TouchApApi(application);
        }
    }

    public static void getToken(String accessToken, final GetTokenCallback callback) {
        String url = Config.baseUrl + "/api/userdevice/v3/devices/token?accessToken=" + accessToken;
        Request.Builder requestBuilder = new Request.Builder().url(url).get();
        mEzvizHttpClient.ezEnqueue(requestBuilder.build(), new EzvizCallback(){

            @Override
            public void onSuccess(String data) {
                responseData = data;
                GetTokenResp getTokenResp = JsonUtils.fromJson(data, GetTokenResp.class);
                callback.onSuccess(getTokenResp.deviceTokenInfo);
            }

            @Override
            public void onException(EzConfigWifiException ezOpenException) {
                callback.onError(ezOpenException);
            }
        });
    }

    public static void getAccessDeviceInfo(final GetAccessDeviceInfoCallback callback) {
        String url = "http:/192.168.4.1/AccessDevInfo?format=json";
        Request.Builder requestBuilder = new Request.Builder().url(url).get();
        mEzvizHttpClient.newCall(requestBuilder.build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                callback.onError(new EzConfigWifiException(EZConfigWifiErrorEnum.NETWORK_EXCEPTION.code, e.getMessage()));
            }

            public void onResponse(Call call, Response response) throws IOException {
                responseData = response.body().string();
                if (response.isSuccessful()) {
                    AccessDeviceInfo accessDeviceInfo = JsonUtils.fromJson(responseData, AccessDeviceInfo.class);
                    callback.onSuccess(accessDeviceInfo);
                } else {
                    callback.onError(new EzConfigWifiException(response.code(), "server exception"));
                }
            }
        });
    }

    public static void getAccessDeviceWifiList(final GetDeviceWifiListCallback callback) {
        String url = "http:/192.168.4.1/PreNetwork/SecurityAndAccessPoint?format=json";
        Request.Builder requestBuilder = new Request.Builder().url(url).get();
        mEzvizHttpClient.newCall(requestBuilder.build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                callback.onError(new EzConfigWifiException(EZConfigWifiErrorEnum.NETWORK_EXCEPTION.code, e.getMessage()));
            }

            public void onResponse(Call call, Response response) throws IOException {
                responseData = response.body().string();
                if (response.isSuccessful()) {
                    GetDeviceWifiListResp getDeviceWifiListResp = JsonUtils.fromJson(responseData, GetDeviceWifiListResp.class);
                    List<EzWifiInfo> ezWifiInfoList = getDeviceWifiListResp.ezWifiInfoList;
                    callback.onSuccess(ezWifiInfoList);
                } else {
                    callback.onError(new EzConfigWifiException(response.code(), "server exception"));
                }
            }
        });
    }

    public static void startNewApConfigWithToken(String token, String ssid, String password, String lbsDomain, final StartNewApConfigCallback callback) {
        String url = "http:/192.168.4.1/PreNetwork/WifiConfig?format=json";
        ConfigNewApRequest.WifiInfo wifiInfo = new ConfigNewApRequest.WifiInfo();
        wifiInfo.ssid = ssid;
        wifiInfo.password = password;
        ConfigNewApRequest request = new ConfigNewApRequest();
        request.token = token;
        request.lbsDomain = lbsDomain;
        request.ezWifiInfo = wifiInfo;
        String postBody = JsonUtils.toJson(request);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)postBody);
        Request requestBuilder = new Request.Builder().url(url).put(requestBody).build();
        mEzvizHttpClient.newCall(requestBuilder).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                callback.onError(new EzConfigWifiException(EZConfigWifiErrorEnum.NETWORK_EXCEPTION.code, e.getMessage()));
            }

            public void onResponse(Call call, Response response) throws IOException {
                responseData = response.body().string();
                if (response.isSuccessful()) {
                    NewApConfigResp newApConfigResp = JsonUtils.fromJson(responseData, NewApConfigResp.class);
                    callback.onResponse(newApConfigResp.statusCode, newApConfigResp.statusDesc);
                } else {
                    callback.onError(new EzConfigWifiException(response.code(), "server exception"));
                }
            }
        });
    }

    static {
        TAG = "TouchApApi";
    }
}

