/*
 * Decompiled with CFR 0.152.
 */
package com.videogo.main;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.hc.CASClient.CASClient;
import com.hc.CASClient.ST_DEV_INFO;
import com.hc.CASClient.ST_DISPLAY_INFO;
import com.hc.CASClient.ST_PTZ_INFO;
import com.hc.CASClient.ST_SERVER_INFO;
import com.videogo.camera.CameraInfoEx;
import com.videogo.camera.CameraManager;
import com.videogo.device.DeviceInfoEx;
import com.videogo.device.DeviceManager;
import com.videogo.errorlayer.ErrorInfo;
import com.videogo.errorlayer.ErrorLayer;
import com.videogo.exception.BaseException;
import com.videogo.main.AppManager;
import com.videogo.util.LocalInfo;
import com.videogo.util.LogUtil;
import java.util.ArrayList;

public class EZPTZController {
    private static final String TAG = "EZPTZController";
    private CASClient mCASClient = null;
    private String mHardwareCode = null;
    private LocalInfo mLocalInfo = null;
    private DeviceInfoEx mDeviceInfoEx = null;
    private CameraInfoEx mCameraInfoEx = null;
    private String mDeviceSerial = null;
    private int mCameraNo = 1;

    public int getCameraNo() {
        return this.mCameraNo;
    }

    public void setCameraNo(int cameraNo) {
        this.mCameraNo = cameraNo;
    }

    public String getDeviceSerial() {
        return this.mDeviceSerial;
    }

    public void setDeviceSerial(String deviceSerial) {
        this.mDeviceSerial = deviceSerial;
    }

    private void initData() {
        if (TextUtils.isEmpty((CharSequence)this.mDeviceSerial)) {
            return;
        }
        if (this.mCameraInfoEx == null) {
            try {
                DeviceManager.getInstance().getDeviceInfoExFromOnlineToLocal(this.mDeviceSerial, this.mCameraNo);
                this.mCameraInfoEx = CameraManager.getInstance().getAddedCamera(this.mDeviceSerial, this.mCameraNo);
                this.mDeviceInfoEx = DeviceManager.getInstance().getDeviceInfoExById(this.mDeviceSerial);
            }
            catch (BaseException e) {
                LogUtil.printErrStackTrace(TAG, e.fillInStackTrace());
            }
        }
    }

    public EZPTZController(String deviceSerial, int cameraNo) {
        this.mDeviceSerial = deviceSerial;
        this.mCameraNo = cameraNo;
        this.mLocalInfo = LocalInfo.getInstance();
        this.mCASClient = AppManager.getInstance().getCASClientSDKInstance();
        this.mHardwareCode = this.mLocalInfo.getHardwareCode();
    }

    public int ptzControl(int command, String szAction, int speed, int presetIndex) {
        LogUtil.d(TAG, "ptzControl:command=" + command + ", szAction=" + szAction + ", speed=" + speed + ", presetIndex=" + presetIndex);
        this.initData();
        if (this.mCameraInfoEx == null || this.mDeviceInfoEx == null || this.mCASClient == null) {
            LogUtil.d(TAG, "mCameraInfoEx or mDeviceInfoEx or mCASClient is null, cant do ptzControl");
            return 400001;
        }
        String mSessionID = LocalInfo.getInstance().getEZAccesstoken().getAccessToken();
        int retryCount = 0;
        while (retryCount <= 3) {
            ++retryCount;
            ArrayList devInfoList = new ArrayList();
            ST_SERVER_INFO mSerVerInfo = new ST_SERVER_INFO();
            mSerVerInfo.szServerIP = this.mDeviceInfoEx.getCasIp();
            mSerVerInfo.nServerPort = this.mDeviceInfoEx.getCasPort();
            if (this.mDeviceInfoEx.getOperationCode() == null || this.mDeviceInfoEx.getEncryptKey() == null) {
                LogUtil.d(TAG, "ptzControl:operatinCode or encryptKey is null, " + retryCount);
                int errorCode = 0;
                for (int i = 0; i < 3; ++i) {
                    boolean result = this.mCASClient.getDevOperationCodeEx(mSerVerInfo, mSessionID, this.mHardwareCode, new String[]{this.mDeviceInfoEx.getDeviceID()}, 1, devInfoList);
                    ErrorInfo errorInfo = ErrorLayer.getErrorLayer(33, this.mCASClient.getLastError());
                    errorCode = errorInfo.errorCode;
                    LogUtil.d(TAG, "ptzControl:getDevOperationCodeEx return:" + result + " errorCode:" + errorCode);
                    if (!result || devInfoList.size() <= 0) continue;
                    this.mDeviceInfoEx.setOperationCode(((ST_DEV_INFO)devInfoList.get((int)0)).szOperationCode);
                    this.mDeviceInfoEx.setEncryptKey(((ST_DEV_INFO)devInfoList.get((int)0)).szKey);
                    this.mDeviceInfoEx.setEncryptType(((ST_DEV_INFO)devInfoList.get((int)0)).enEncryptType);
                    break;
                }
                if (this.mDeviceInfoEx.getOperationCode() == null || this.mDeviceInfoEx.getEncryptKey() == null) {
                    LogUtil.d(TAG, "ptzControl:still cant getDevOperationCodeEx or getEncryptKeyafter 3 times, ptzControl fail, return " + errorCode);
                    return errorCode;
                }
            }
            ST_DEV_INFO mDevInfo = new ST_DEV_INFO();
            mDevInfo.szDevSerial = this.mDeviceInfoEx.getDeviceID();
            mDevInfo.szOperationCode = this.mDeviceInfoEx.getOperationCode();
            mDevInfo.szKey = this.mDeviceInfoEx.getEncryptKey();
            int mSupportPtzmodel = this.mDeviceInfoEx.getSupportPtzModel();
            boolean flag = true;
            LogUtil.d("PTZ control info", "ability " + mSupportPtzmodel + "  inLan  " + this.mDeviceInfoEx.getInLan());
            if (mSupportPtzmodel == 1) {
                flag = false;
                mSerVerInfo.szServerIP = this.mDeviceInfoEx.getLocalDeviceIp();
                mSerVerInfo.nServerPort = this.mDeviceInfoEx.getLocalCmdPort();
            } else if (mSupportPtzmodel == 0 && this.mDeviceInfoEx.getInLan() == 1) {
                flag = false;
                mSerVerInfo.szServerIP = this.mDeviceInfoEx.getLocalDeviceIp();
                mSerVerInfo.nServerPort = this.mDeviceInfoEx.getLocalCmdPort();
            }
            boolean ret = false;
            switch (command) {
                case 4: {
                    ST_DISPLAY_INFO mDisplayInfo = new ST_DISPLAY_INFO();
                    mDisplayInfo.szCommand = szAction;
                    mDisplayInfo.iChannel = this.mCameraInfoEx.getChannelNo();
                    mDisplayInfo.szRes = "";
                    ret = this.mCASClient.displayCtrl(mSessionID, mSerVerInfo, mDevInfo, mDisplayInfo, flag);
                    break;
                }
                default: {
                    ST_PTZ_INFO mPtzInfo = new ST_PTZ_INFO();
                    mPtzInfo.szCommand = EZPTZController.getCasCommand(command);
                    mPtzInfo.iChannel = this.mCameraInfoEx.getChannelNo();
                    mPtzInfo.szAction = szAction;
                    mPtzInfo.iSpeed = speed;
                    mPtzInfo.iPresetIndex = presetIndex;
                    ret = this.mCASClient.ptzCtrl(mSessionID, mSerVerInfo, mDevInfo, mPtzInfo, flag);
                    LogUtil.d(TAG, "ptzControl: call mCASClient.ptzCtrl result:" + ret + " mSessionId:" + mSessionID + " servInfo.IP:" + mSerVerInfo.szServerIP + " port:" + mSerVerInfo.nServerPort + " devInfo.serial:" + mDevInfo.szDevSerial + " devInfo.opCode:" + mDevInfo.szOperationCode + " devInfo.szKey:" + mDevInfo.szKey + " encryptType:" + mDevInfo.enEncryptType + " ptzInfo:szCommand:" + mPtzInfo.szCommand + " iChannel:" + mPtzInfo.iChannel + " szAction:" + mPtzInfo.szAction + " iSpeed:" + mPtzInfo.iSpeed + " presetIndex:" + mPtzInfo.iPresetIndex + " flag:" + flag);
                }
            }
            if (!ret) {
                ErrorInfo errorInfo = ErrorLayer.getErrorLayer(33, this.mCASClient.getLastError());
                int errorCode = errorInfo.errorCode;
                if (errorCode == 380042 || errorCode == 380003) {
                    this.mDeviceInfoEx.setOperationCode(null);
                    this.mDeviceInfoEx.setEncryptKey(null);
                    if (retryCount <= 3) continue;
                    LogUtil.d(TAG, "ptzControl: operation fail");
                    return errorCode;
                }
                if (retryCount <= 3) continue;
                return errorCode;
            }
            return 100;
        }
        return 400100;
    }

    public static String getCasCommand(int command) {
        switch (command) {
            case 0: {
                return "UP";
            }
            case 1: {
                return "DOWN";
            }
            case 2: {
                return "LEFT";
            }
            case 3: {
                return "RIGHT";
            }
            case 5: {
                return "ZOOMIN";
            }
            case 6: {
                return "ZOOMOUT";
            }
            case 7: {
                return "SET_PRESET";
            }
            case 8: {
                return "CLE_PRESET";
            }
            case 9: {
                return "GOTO_PRESET";
            }
        }
        return "";
    }

    public void sendMessage(Handler handler, int msg, int arg1, int arg2) {
        if (handler != null) {
            Message message = Message.obtain();
            message.what = msg;
            message.arg1 = arg1;
            message.arg2 = arg2;
            handler.sendMessage(message);
        }
    }
}

