/*
 * Decompiled with CFR 0.152.
 */
package com.videogo.openapi;

import android.text.TextUtils;
import android.util.Log;
import com.ezviz.hcnetsdk.EZLoginDeviceInfo;
import com.ezviz.hcnetsdk.EZSADPDeviceInfo;
import com.hikvision.keyprotect.KeyProtect;
import com.hikvision.netsdk.HCNetSDK;
import com.hikvision.netsdk.INT_PTR;
import com.hikvision.netsdk.NET_DVR_DEVICEINFO_V30;
import com.hikvision.netsdk.NET_DVR_SDKLOCAL_CFG;
import com.hikvision.sadp.DeviceFindCallBack;
import com.hikvision.sadp.SADP_DEVICE_INFO;
import com.hikvision.sadp.Sadp;
import com.videogo.exception.BaseException;
import com.videogo.util.LogUtil;
import java.util.Locale;

public class EZHCNetDeviceSDK {
    static EZHCNetDeviceSDK mEZHCNetSDKApi = null;
    private static EZEncryptType mType;

    public void setEncryptType(EZEncryptType type) {
        mType = type;
        this.setConfig();
    }

    private EZHCNetDeviceSDK() {
        Sadp mSadp = Sadp.getInstance();
        if (mSadp == null) {
            // empty if block
        }
        if (HCNetSDK.getInstance() == null) {
            mSadp.SADP_Clearup();
            mSadp = null;
        }
        HCNetSDK.getInstance().NET_DVR_Init();
        this.setConfig();
        HCNetSDK.getInstance().NET_DVR_SetConnectTime(5000);
    }

    public static EZHCNetDeviceSDK getInstance() {
        if (mEZHCNetSDKApi != null) {
            return mEZHCNetSDKApi;
        }
        return new EZHCNetDeviceSDK();
    }

    private void setConfig() {
        NET_DVR_SDKLOCAL_CFG struSdkCfg = new NET_DVR_SDKLOCAL_CFG();
        HCNetSDK.getInstance().NET_DVR_GetSDKLocalConfig(struSdkCfg);
        struSdkCfg.byEnableAbilityParse = 1;
        if (mType == EZEncryptType.EZEncryptType_OEMBlue) {
            byte[] bule_byScrkey = new byte[]{72, -106, 104, -93, 97, -65, 110, -75, 103, -51, 122, -2, 104, -54, 111, -34, 117, 73, 75, 55, 92};
            KeyProtect.getInstance().ENCRYPT_GetKey(bule_byScrkey, 21, struSdkCfg.byProtectKey, 128);
        } else if (mType == EZEncryptType.EZEncryptType_OEMGreen) {
            byte[] green_byScrkey = new byte[]{72, -105, 104, -93, 97, -65, 110, -75, 103, -51, 122, -2, 104, -54, 111, -34, 117, 73, 75, 57, 92};
            KeyProtect.getInstance().ENCRYPT_GetKey(green_byScrkey, 21, struSdkCfg.byProtectKey, 128);
        }
        HCNetSDK.getInstance().NET_DVR_SetSDKLocalConfig(struSdkCfg);
    }

    public boolean startLocalSearch(final SadpDeviceFoundListener listener) {
        boolean ret = false;
        Log.d((String)"NetSDK", (String)"startLocalSearch");
        if (Sadp.getInstance() != null && listener != null) {
            ret = Sadp.getInstance().SADP_Start_V30(new DeviceFindCallBack(){

                public void fDeviceFindCallBack(SADP_DEVICE_INFO sadp_device_info) {
                    EZSADPDeviceInfo deviceInfo = new EZSADPDeviceInfo(sadp_device_info);
                    listener.onDeviceFound(deviceInfo);
                }
            });
        }
        return ret;
    }

    public boolean stopLocalSearch() {
        boolean ret = false;
        if (Sadp.getInstance() != null) {
            ret = Sadp.getInstance().SADP_Stop();
        }
        return ret;
    }

    public int activeDeviceWithSerial(String serail, String pwd) {
        int erroCode;
        Log.d((String)"NetSDK", (String)String.format(Locale.CHINA, "activeDeviceWithSerial [%s][%s]", serail, pwd));
        int iFlag = Sadp.getInstance().SADP_ActivateDevice(serail, pwd);
        if (iFlag == 0 && (erroCode = Sadp.getInstance().SADP_GetLastError()) == 2021) {
            iFlag = 0;
        }
        return iFlag;
    }

    public EZLoginDeviceInfo loginDeviceWithUerName(String userName, String pwd, String deviceip, int port) throws BaseException {
        int userId = -1;
        HCNetSDK mHCNetSDK = HCNetSDK.getInstance();
        if (mHCNetSDK == null || TextUtils.isEmpty((CharSequence)deviceip) || port < 1) {
            LogUtil.e("EZHCNetSDK", "mHCNetSDK is null or deviceip is null or port Less than 1");
            return null;
        }
        int errorCode = 0;
        NET_DVR_DEVICEINFO_V30 devInfo = new NET_DVR_DEVICEINFO_V30();
        userId = mHCNetSDK.NET_DVR_Login_V30(deviceip, port, userName, pwd, devInfo);
        if (userId < 0) {
            errorCode = mHCNetSDK.NET_DVR_GetLastError();
            INT_PTR ptt = new INT_PTR();
            ptt.iValue = errorCode;
            String errorMsg = HCNetSDK.getInstance().NET_DVR_GetErrorMsg(ptt);
            LogUtil.e("EZHCNetSDK", "NET_DVR_Login is failed!err:" + errorCode);
            throw new BaseException(errorMsg, errorCode, null);
        }
        if (errorCode == 0) {
            EZLoginDeviceInfo ezLoginDeviceInfo = new EZLoginDeviceInfo(devInfo, userId);
            return ezLoginDeviceInfo;
        }
        return null;
    }

    public boolean logoutDeviceWithUserId(int userId) {
        boolean ret = false;
        if (HCNetSDK.getInstance() != null && userId != -1) {
            ret = HCNetSDK.getInstance().NET_DVR_Logout_V30(userId);
        }
        return ret;
    }

    public static enum EZEncryptType {
        EZEncryptType_normal,
        EZEncryptType_OEMGreen,
        EZEncryptType_OEMBlue;

    }

    public static enum PTZAction {
        PTZ_ACTION_START(0),
        PTZ_ACTION_STOP(1);

        private int value;

        private PTZAction(int ret) {
            this.value = ret;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static interface SadpDeviceFoundListener {
        public void onDeviceFound(EZSADPDeviceInfo var1);
    }
}

